

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	debug.c
*
*	$Log:   /b/gregs/i960/newdebug/debug.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:36:24   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:25:42   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:26:10   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 12:55:20   franks
 * No change.
 * 
 *    Rev 1.0   05 Apr 1993 17:27:44   ramki
 * Initial revision.
 * 
 *    Rev 1.1   09 Jun 1992 19:14:54   kwok
 * Declare the static functions at the beginning of the files.
 * 
 *    Rev 1.0   30 Mar 1992 16:54:42   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include <types.h>
#include <dbdefines.h>
#include <globals.h>
#include "break.h"
#include <regs.h>


extern unsigned long ram_control_table[16];
static display_trace(unsigned bitmask);

/************************************************/
/* Display Breakpoints              	 	*/
/*                           			*/
/************************************************/
static
display_bpt( type )
char type;	/* BRK_INST or BRK_DATA */
{
int count;
struct bpt *bp;

	count = 0;
	dprintf("\n %s breakpoints set: ",type==BRK_INST ? "Instruction":"Data");
	for ( bp = &bptable[0]; bp->type != BRK_EOT; bp++ ){
		if (bp->active && bp->type == type){
			count++;
			dprintf(" %08X", bp->addr);
		}
	}
	if (count == 0) {
		dprintf(" none");
	}
}

/************************************************/
/* Search Table for a Specific Breakpoint	*/
/*						*/
/* To match, a breakpoint in the table must have*/
/* The specified type and the specified 'active'*/
/* state.  If and only if the breakpoint is 	*/
/* active, the address must also match.	`	*/
/*						*/
/************************************************/
static
struct bpt *
find_bpt( type, active, addr )
char type;		/* BRK_DATA or BRK_INST		*/
char active;		/* TRUE or FALSE		*/
int *addr;		/* Only valid if active == TRUE	*/
{
struct bpt *bp;

	for ( bp = &bptable[0]; bp->type != BRK_EOT; bp++ ){
		if ( bp->type == type
		&&   bp->active == active 
		&&   (!active || bp->addr == addr) ){
			return bp;
		}
	}
	return NULL;
}

/************************************************/
/* Set a Breakpoint              	 	*/
/*                           			*/
/* 'breakpt' and 'databreak' set (or display)	*/
/* instruction and data breakpoints, respectivly*/
/*						*/
/* 'set_bpt' is a lower-level entry point that 	*/
/* does the actual work.			*/
/************************************************/
breakpt( dummy, nargs, addr )
int dummy;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0 or 1) */
int addr;	/* Optional breakpoint address				*/

{
	if ( nargs == 0 ){
		display_bpt( BRK_INST );
	} else {
		(void) set_bpt( BRK_INST, addr );
	}
}


databreak( dummy, nargs, addr )
int dummy;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0 or 1) */
int addr;	/* Optional breakpoint address			*/
{
	if ( nargs == 0 ){
		display_bpt( BRK_DATA );
	} else {
		(void) set_bpt( BRK_DATA, addr );
	}
}


set_bpt( type, addr )
char type;
int addr;
{
struct bpt *bp;
char *typename;
int retval;	/* Return code */

	retval = TRUE;	/* Assume success */

	typename = (type == BRK_INST) ? "Instruction" : "Data";

	if ( find_bpt(type,TRUE,addr) ){
		dprintf("\n %s breakpoint already set at %08X", typename, addr);

	} else if ( (bp = find_bpt(type,FALSE,0)) == NULL ){
		dprintf("\n No %s breakpoints left", typename);
		retval = FALSE;

	} else {
		bp->addr = (int *)addr;
		bp->active = TRUE;
		pgm_bpt_hw(type);
	}

	return retval;
}

/************************************************/
/* Delete a Breakpoint              	 	*/
/*                           			*/
/* 'delete' and 'delete_data' remove instruc-	*/
/* tion and data breakpoints, respectivly.	*/
/*						*/
/* 'del_bpt' is a lower-level entry point that 	*/
/* does the actual work.			*/
/************************************************/
delete( dummy, nargs, addr )
int dummy;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0 or 1) */
int addr;	/* Optional breakpoint address	*/
{
	del_bpt( BRK_INST, addr );
}


delete_data( dummy, nargs, addr )
int dummy;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0 or 1) */
int addr;	/* Optional breakpoint address	*/
{
	del_bpt( BRK_DATA, addr );
}


del_bpt( type, addr )
char type;
int *addr;
{
struct bpt *bp;
int retval;	/* Return code */


	if ( (bp = find_bpt(type,TRUE,addr)) == NULL ){
		dprintf("\n No %s breakpoint set at %08X",
				type==BRK_INST ? "Instruction" : "Data", addr);
	} else {
		bp->active = FALSE;
		pgm_bpt_hw( type );
		display_bpt( type );
	}
}

/*
 * Silently delete all active breakpoints
 */
clear_bpts()
{
	int i;

	for ( i=0; bptable[i].type != BRK_EOT; i++ ){
		bptable[i].active = FALSE;
	}
	pgm_bpt_hw( BRK_DATA );
	pgm_bpt_hw( BRK_INST );
}


/**************************************************************************
 * HARDWARE BREAKPOINT TABLE
 *
 * 960 CX architecture has 2 instruction breakpoints and 2 data breakpoints
 **************************************************************************/
struct bpt bptable[] = {
	{ BRK_INST, FALSE, 0 },	
	{ BRK_INST, FALSE, 0 },
	{ BRK_DATA, FALSE, 0 },
	{ BRK_DATA, FALSE, 0 },
	{ BRK_EOT,  FALSE, 0 },
};


/**************************************************************************
 * PROGRAM BREAKPOINT HARDWARE
 *
 * Reprogram *all* breakpoints of the specified type to the state currently
 * found in 'bptable', by using the sysctl instruction to reload the
 * appropriate registers in the control	table.
 **************************************************************************/
pgm_bpt_hw( type )
char type;		/* BRK_INST or BRK_DATA */
{
int addr[2];
struct bpt *bp;
int count;
int mask;
int i;

	addr[0] = addr[1] = 2;	/* Will disable both instruction breakpoints */
	count = 0;

	if ( type == BRK_INST ){
		for ( bp = &bptable[0]; bp->type != BRK_EOT; bp++ ){
			if ( bp->active && bp->type == type ){
				addr[count++] = ((int) bp->addr) | 3;
				/* The '| 3' enables the instruction bpt */
			}
		}
		i = 0;	/* Entries 0 & 1 in control table will be set */

	} else {	/* DATA BREAKPOINT */

		ram_control_table[25] &= 0xffccffff;
		mask = 0x000f0000;
		for ( bp = &bptable[0]; bp->type != BRK_EOT; bp++ ){
			if ( bp->active && bp->type == type ){
				addr[count++] = (int) bp->addr;
				ram_control_table[25] |= mask;
				mask <<= 4;
			}
		}
		i = 2;	/* Entries 2 & 3 in control table will be set */
		send_sysctl(0x406, 0, 0);   /* Reload control register group 6*/
	}


	ram_control_table[i++] = addr[0];
	ram_control_table[i] = addr[1];
	send_sysctl(0x400, 0, 0);   /* Reload control register group 0 */

	register_set[REG_TC] |= 0x80;
}



/* Mask for appropriate bit in register tc for each trace type
 */
#define	BRANCH 	0x04		/* branch trace		*/
#define	CALL 	0x08		/* call trace		*/
#define	RET 	0x10		/* return trace		*/
#define	SUP 	0x40		/* supervisor trace	*/


/************************************************/
/* Trace Flags Set or Cleared        	 	*/
/*                           			*/
/************************************************/
trace( dummy, nargs, type, state )
int dummy;	/* Ignored */
int nargs;	/* Number of the following arguments that are valid (0,1,2) */
char *type;	/* Optional trace type: "br", "ca", "re", or "su"	*/
char *state;	/* Desired trace state ("on" or "off")	*/
{
unsigned bitmask;

	if ( nargs > 0 ){

		/* First argument (trace type) */

		if ( !strncmp(type,"br",2) ){
			bitmask = BRANCH;
		} else if ( !strncmp(type,"ca",2) ){
			bitmask = CALL;
		} else if ( !strncmp(type,"re",2) ){
			bitmask = RET;
		} else if ( !strncmp(type,"su",2) ){
			bitmask = SUP;
		} else {
			badarg( type );
			return;
		}

		/* Second argument ("on"/"off") */

		if ( nargs < 2 ) {
			/* no 2nd argument, display trace status */
			display_trace(bitmask);
			return;
		} else if ( !strncmp(state,"of",2) ){
			register_set[REG_TC] &= ~bitmask;
		} else if ( !strncmp(state,"on",2) ){
			register_set[REG_TC] |= bitmask;
		} else {
			badarg( state );
			return;
		}
	}

	display_trace(BRANCH);
	display_trace(CALL);
	display_trace(RET);
	display_trace(SUP);
}


/************************************************/
/* Display Trace Status                    	*/
/*                           			*/
/************************************************/
static
display_trace( bitmask)
unsigned bitmask;	/* BRANCH, CALL, RET, or SUP */
{
	char *p;

	switch ( bitmask ){
	case BRANCH: p = "Branch";     break;
	case CALL:   p = "Call";       break;
	case RET:    p = "Return";     break;
	case SUP:    p = "Supervisor"; break;
	}

	dprintf("\n %s trace %s",p,register_set[REG_TC] & bitmask ? "on" : "off" );
}

/************************************************/
/* Modify Memory or Register           		*/
/*                           			*/
/* If a register name is specified, display and	*/
/* modify its contents;  if a hex address is	*/
/* specified, display/modify contents of memory	*/
/* at that address.				*/
/************************************************/
modify( size, nargs, where, cnt )
int size;	/* BYTE or INTEGER */
int nargs;	/* Number of following arguments that are valid (1 or 2) */
char *where;	/* Register name or hex address (required)		*/
int cnt;	/* Number of items to display/mod (optional, default 1)	*/
{
char *addr;
unsigned int data;
int r;

	if ( (r=get_regnum(where)) != ERROR ){
		if ( nargs > 1 ){
			/* Never display more than one reg at a time */
			dprintf("\n Too many arguments");
		} else {
			mod_register( where, r );
		}

	} else if ( !atoh(where,&addr) ){
		badarg(where);

	} else {
		if ( nargs < 2 ){
			cnt = 1;  /* Set default */
		}
		dprintf("\n");
		while ( cnt-- ) {
			dprintf("%08X : ", addr );
			if (size == BYTE){
				if ( read_data(&data) ){
					store_byte(data, addr);
				}
				addr++;
			} else {   /* INT */
				dprintf("%08X : ", *(unsigned int*)addr );
				read_data(addr);
				addr += 4;
			}
		}
	}
}

/************************************************/
/* Display Memory               		*/
/*                           			*/
/* If a register name is specified and the size	*/
/* is INT, display register's contents;  if re-	*/
/* gister name is specified and size is *not*	*/
/* INT, display memory at address stored in re-	*/
/* gister; if a hex address is specified,	*/
/* display contents of memory at that address.	*/
/************************************************/

display( size, nargs, where, cnt )
int size;	/* BYTE, SHORT, INT, LONG, TRIPLE, or QUAD */
int nargs;	/* Number of the following args that are valid (1 or 2) */
char * where;	/* Register name or hex address (required)		*/
int cnt;	/* Number of items to display (optional, default 1	*/
{
unsigned char byte_data;
int i;
int r;
int n;
int addr;

	if ( nargs < 2 ){
		cnt = 1;	/* Set default */
	}

	r = get_regnum(where);
	if ( r != ERROR ){
		if ( size == INT ){
			/* Display contents of register and return --
			 * no count allowed.
			 */
			if ( nargs > 1 ){
				dprintf("Too many arguments\n" );
			} else {
				disp_register(where,r);
			}
			return;
		} else if ( r >= NUM_REGS ){
			/* FP register */
			badarg( where );
			return;
		} else {
			addr = register_set[r];
		}
	} else if ( !atoh(where,&addr) ){
		badarg( where );
		return;
	}

	{
	int i;

	while ( cnt-- ) {
		dprintf("\n%08X : ", addr );
		n = 0;

		switch (size) {
		case BYTE:
			for (i = 0; (i != 16); i++)
			{
				if(i == 8)
					dprintf(" ");

				byte_data = load_byte((int)addr);
				dprintf("%02x ", byte_data );
				addr++;
				if (cnt)
					--cnt;
			}

			addr -= 16;

			dprintf(" ");

			while (i--)
			{
				if(i == 8)
					dprintf(" ");

				byte_data = load_byte((int)addr);
				/* print in ASCII if a printable character */
				if ((byte_data > 0x20) && (byte_data < 0x7f))
					dprintf("%c", byte_data);
				else
					dprintf(".");
				addr++;
			}
			break;
		case SHORT:
			for (i = 0; (i != 8); i++)
			{
				if(i == 4)
					dprintf(" ");

				dprintf("%04x ",*(unsigned short *)addr );
				addr += sizeof(unsigned short);

				if (cnt)
					--cnt;
			}

			break;
		case INT:
			cnt++;
			for (i = 0, n = 0; ((i != 4) && cnt); i++, n++, cnt--)
				long_data[i] = *(unsigned int*)(addr + (i * sizeof(unsigned int)));

			break;
		case LONG:
			load_long(addr);
			n = 2;
			break;
		case TRIPLE:
			load_triple(addr);
			n = 3;
			break;
		case QUAD:
			load_quad(addr);
			n = 4;
			break;
		}

		for (i=0; i<n; i++) {
			dprintf("%08X ", long_data[i] );
			addr += sizeof(unsigned int);
		}
	}
	}

#ifdef XXX
	while ( cnt-- ) {
		dprintf("\n%08X : ", addr );
		n = 0;

		switch (size) {
		case BYTE:
			byte_data = load_byte((int)addr);
			dprintf("%02x", byte_data );

			/* print in ASCII if a printable character */
			if ((byte_data > 0x20) && (byte_data < 0x7f)) {
				dprintf("    %c", byte_data);
			}
			addr++;
			break;
		case SHORT:
			dprintf("%04x",*(unsigned short *)addr );
			addr += sizeof(unsigned short);
			break;
		case INT:
			long_data[0] = *(unsigned int*)addr,
			n = 1;
			break;
		case LONG:
			load_long(addr);
			n = 2;
			break;
		case TRIPLE:
			load_triple(addr);
			n = 3;
			break;
		case QUAD:
			load_quad(addr);
			n = 4;
			break;
		}

		for (i=0; i<n; i++) {
			dprintf("%08X ", long_data[i] );
			addr += sizeof(unsigned int);
		}
	}
#endif
}


/************************************************/
/* Modify Register                  	 	*/
/*                           			*/
/************************************************/
mod_register(reg, num)
char *reg;	/* ASCII name of register	*/
int num;	/* If < NUM_REGS, an index into the 'register_set' array.*/
{
unsigned int data;
	disp_register(reg, num);
	dprintf(" : ");
	if (num < NUM_REGS){
		read_data(&register_set[num]);
	} else {
		dprintf("not implemented");
	}
}

/************************************************/
/* Display Register                  	 	*/
/*                           			*/
/************************************************/
disp_register(reg, num)
char reg[];
int num;    /* If < NUM_REGS, an index into the 'register_set' array.*/
{
	dprintf("\n%s : ",reg);
	if (num < NUM_REGS){
		dprintf("%08X", register_set[num] );
	} 
}


/************************************************/
/* Display Registers                            */
/* 						*/
/* this routine will display the last stored    */
/* register values from the global register     */
/* storage area 				*/
/************************************************/

static const int
regtab[] = {
	REG_G0, REG_G1, REG_G2, REG_G3, ERROR,
	REG_G4, REG_G5, REG_G6, REG_G7, ERROR,
	REG_G8, REG_G9, REG_G10,REG_G11,ERROR,
	REG_G12,REG_G13,REG_G14,REG_FP, ERROR,
	ERROR,
	REG_PFP,REG_SP, REG_RIP,REG_R3, ERROR,
	REG_R4, REG_R5, REG_R6, REG_R7, ERROR,
	REG_R8, REG_R9, REG_R10,REG_R11,ERROR,
	REG_R12,REG_R13,REG_R14,REG_R15,ERROR,
	REG_PC, REG_AC, REG_TC, REG_IP, ERROR,
};

#define TABLEN (sizeof(regtab)/sizeof(regtab[0]))

void
display_regs()
{
int i;
char *p;
int r;

	for ( i = 0; i < TABLEN; i++ ){
		r = regtab[i];
		if ( r == ERROR ){
			dprintf("\n" );
		} else {
			p = get_regname(r);
			dprintf(" %s%s: %08X", p, strlen(p) == 2 ? " " : "",
							register_set[r] );
		}
	}

}

void
stack_history(dummy1, nargs, cnt)
int dummy1;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0 or 1) */
int cnt;
{
	int i = 0;
	word *prev_pfp;
	word *pfp = (word *)(register_set[REG_PFP] & 0xfffffff0);

	if (nargs == 0)
		cnt = 100;	/* some large value */

	dprintf(" frame         pfp           sp            rip\n\n");

	dprintf(" n - %2d      %08X      %08X      %08X\n", i, register_set[REG_PFP], register_set[REG_SP], register_set[REG_RIP]);

	do
	{
		i++;
		dprintf(" n - %2d      %08X      %08X      %08X\n", i, *pfp, *(pfp+1), *(pfp+2));
		prev_pfp = pfp;
		pfp = (word *)(*pfp & 0xfffffff0);
	} while((prev_pfp != pfp) && --cnt);
}

/************************************************/
/* Fill Memory 					*/
/*                           			*/
/************************************************/
fill( dummy1, dummy2, addr1, addr2, data )
int dummy1;	/* Ignored */
int dummy2;	/* Ignored */
int *addr1;	/* Starting address to be filled */
int *addr2;	/* Ending address to be filled	*/
int data;	/* Word of data to fill with	*/
{
	while (addr1 <= addr2) {
		*addr1++ = data;
	}
}

/*************************************************/
/* Display PRCB					 */
/*************************************************/

extern ram_prcb[];

display_prcb()
{
	int i;
	int *prcb_ptr = (int *)&ram_prcb;

	dprintf("     PROCESS CONTROL BLOCK(PRCB)\n\n");
	for ( i = 0; i != 10; prcb_ptr++, i++)
	{
		switch (i)
		{
		case 0:
			dprintf("FAULT TABLE BASE ADDRESS    :");
			break;
		case 1:
			dprintf("CONTROL TABLE BASE ADDRESS  :");
			break;
		case 2:
			dprintf("AC REGISTER INITIAL IMAGE   :");
			break;
		case 3:
			dprintf("FAULT CONFIGURATION WORD    :");
			break;
		case 4:
			dprintf("INT TABLE BASE ADDRESS      :");
			break;
		case 5:
			dprintf("SYS PROC TABLE BASE ADDRESS :");
			break;
		case 6:
			dprintf("RESERVED                    :");
			break;
		case 7:
			dprintf("INTERRUPT STACK POINTER     :");
			break;
		case 8:
			dprintf("INST CASHE CONFIG WORD      :");
			break;
		case 9:
			dprintf("REG CASHE CONFIG WORD       :");
			break;
		}
		dprintf("   %08X\n", *prcb_ptr);
	}
}

