/**
 *	Program Name:	nim960 program
 *
 *	Filename:	askyesno.c
 *
 *	$Log:   /b/gregs/i960/libutil/askyesno.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:30   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:25:04   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:32   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:30   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:30   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
extern	char	*EntryInvalidMsg;
extern	char	*SyntaxErrorMsg;

extern	int	AskCharacter(char *, int);

/*
 * name		AskYesNo	- prompt the user to enter y or n
 *
 * synopsis	AskYesNo(char *message)
 *		char	*message;<<	to prompt the user 
 *
 * description	It displays the "message" and wait for the user to enter
 *		'y'('Y') or 'n'('N').  If the user presses 'enter', 
 *		then the default answer is 'y'.
 *		If the user enters any other characters, the
 *		sequence will be repeated.
 *
 * returns	0		- user enter 'n'
 *		otherwise	- user enter 'y'
 */

AskYesNo(char *message)

	{
	char	answer = '\0';

	for (;;)
		{
		answer = AskCharacter(message, 'y');
		answer = tolower(answer);
		if (answer == 'y' || answer == 'n')
			break;
		printf(EntryInvalidMsg);
		}
	return answer == 'y' ? 1 : 0;
	}

