/**
 *	Program Name:	nim960 program
 *
 *	Filename:	asktimeoff.c
 *
 *	$Log:   /b/gregs/i960/libutil/asktimeoff.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:28   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:25:02   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:30   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:28   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:28   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
extern	char	*SyntaxErrorMsg;
extern	char	*EntryInvalidMsg;

/*
 *	Ask the user to enter the time offset..
 */
int AskTimeOffset(char *prompt, int seconds)

	{
	char	c; 	/* dummy for check user input	*/
	char	buffer[80];
	int	offset;
	int	argc;
	int	hour;
	int	minute;
	int	negative;	/* is it < 0 ?	*/
	char	*p;

	for (;;)
		{
		p = buffer;
		offset = seconds;
		printf("%s (", prompt);
		if (offset < 0)
			{
			offset = 0 - offset;
			putchar('-');
			}
		negative = 0;
		hour = offset / (60 * 60);
		minute = (offset % (60 * 60)) / 60;
		printf("%02d:%02d) ==>", hour, minute);
		gets(buffer);
		if (buffer[0] != '\0')
			{
			/*
			 *	We have to check for the '+' or '-' sign as
			 *	scanf cannot handle negative number or the '+' sign.
			 */
			if (buffer[0] == '-' || buffer[0] == '+')
				{
				p++;
				if (buffer[0] == '-')
					negative = 1;
				}
			}
		if ((argc = sscanf(p, "%d:%d%c", &hour, &minute, &c)) == 2)
			{
			if (hour > 12 || minute > 59 || (hour == 12 && minute != 0))
				{
				printf(EntryInvalidMsg);
				continue;
				}
			break;
			}
		else if (argc == 0 && buffer[0] == '\0');
			return seconds; /* enter has been pressed */
		printf(SyntaxErrorMsg);
		}
	seconds = hour * 60 * 60 + minute * 60;
	if (negative)
		seconds = 0 - seconds;
	return seconds;
	}
