/**
 *	Program Name:	nim960 program
 *
 *	Filename:	asklevel.c
 *
 *	$Log:   /b/gregs/i960/libutil/asklevel.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:26   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:25:00   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:28   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:26   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:26   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
extern	char	*EntryInvalidMsg;
extern	char	*SyntaxErrorMsg;
/*
 *	Ask the user for the software level
 *	major level is encoded in bit 8 to bit 15
 *	minor level is encoded in bit 0 to bit 7
 */
AskLevel(char *prompt, unsigned level)

	{
	char	c; 	/* dummy for check user input	*/
	int	major;	/* revision number	*/
	int	minor;	/* revision number	*/
	char	buffer[80];
	int	argc;

	for (;;)
		{
		major = (level >> 8) & 0xff;
		minor = level & 0xff;
		printf("%s (%d.%d) ==>", prompt, major, minor);
		gets(buffer);
		if ((argc = sscanf(buffer, "%d.%d%c", &major, &minor, &c)) == 2)
			{
			if (major < 255 && minor < 255)
				break;
			printf("Error: Entry invalid ");
			printf("(revision number cannot larger than 255)\n");
			printf("Please try again\n");
			continue;
			}
		else if (argc == 0 && buffer[0] == '\0')
			return level; /* enter has been pressed	*/
		printf(SyntaxErrorMsg);
		}
	return (major << 8) | minor;
	}

