/**
 *	Program Name:	nim960 program
 *
 *	Filename:	askburndate.c
 *
 *	$Log:   /b/gregs/i960/libutil/askburndate.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:20   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:24:54   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:22   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:22   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:20   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
extern	char	*EntryInvalidMsg;
extern	char	*SyntaxErrorMsg;


/*
 *	AskDate	- ask the user to enter the date in the form of MM-DD-YY
 */
AskBurnDate(char *prompt, char date[])

	{
	int	day;
	int	month;
	int	year;
	char	c; 	/* dummy for check user input	*/
	char	buffer[80];
	int	argc;

	for (;;)
		{
		printf("%s (%s) ==>", prompt, date); 
		gets(buffer);
		if ((argc = sscanf(buffer, "%d-%d-%d%c", &month, &day, &year, &c)) == 3)
			{
			if (1 <= month && month <= 12 && 1 <= day && day <= 31)
				break;
			else
				{
				printf(EntryInvalidMsg);
				continue;
				}
			}
		else if (argc == 0 && buffer[0] == '\0')
			return ;	/* enter has been pressed	*/
		printf(SyntaxErrorMsg);
		}
	strcpy(date, buffer);
	}



/*
 *	AskBurnTime	- ask the user to enter the time in the form of HH:MM:SS 
 */
AskBurnTime(char *prompt, char time[])

	{
	int	hour;
	int	minute;
	int	second;
	char	c; 	/* dummy for check user input	*/
	char	buffer[80];
	int	argc;

	for (;;)
		{
		printf("%s (%s) ==>", prompt, time); 
		gets(buffer);
		if ((argc = sscanf(buffer, "%d:%d:%d%c", &hour, &minute, &second, &c)) == 3)
			{
			if (0 <= hour && hour <= 23 && 0 <= minute && minute <= 59 && 
				0 <= second && second <= 59)
				break;
			else
				{
				printf(EntryInvalidMsg);
				continue;
				}
			}
		else if (argc == 0 && buffer[0] == '\0')
			return ;	/* enter has been pressed	*/
		printf(SyntaxErrorMsg);
		}
	strcpy(time, buffer);
	}


