

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	strncmp.c
*
*	$Log:   /b/gregs/i960/libc/strncmp.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:42   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:26   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:46   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:50   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:48:00   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:28   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:18   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include "types.h"
#include "inc.h"

/*
 * strncmp - compare at most n characters of string s1 to s2
 */

#undef strncmp

int				/* <0 for <, 0 for ==, >0 for > */
strncmp(s1, s2, n)
CONST char *s1;
CONST char *s2;
SIZET n;
  {
	CONST char *scan1;
	CONST char *scan2;
	int count;

	scan1 = s1;
	scan2 = s2;
	count = n;
	while (--count >= 0 && *scan1 != '\0' && *scan1 == *scan2) {
		scan1++;
		scan2++;
	}
	if (count < 0)
		return(0);

	/*
	 * The following case analysis is necessary so that characters
	 * which look negative collate low against normal characters but
	 * high against the end-of-string NUL.
	 */
	if (*scan1 == '\0' && *scan2 == '\0')
		return(0);
	else if (*scan1 == '\0')
		return(-1);
	else if (*scan2 == '\0')
		return(1);
	else
		return(*scan1 - *scan2);
  }
