

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	printf.c
*
*	$Log:   /b/gregs/i960/libc/printf.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:28   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:10   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:30   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:26   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:44   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:18   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:08   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/********************************************************
 *
 *	COPYRIGHT (c) 1986 by SYTEK Inc.   (unpublished)
 *		*** ALL RIGHTS RESERVED ***
 *
 *     printf, putchar, getchar, gets functionality
 *
 ********************************************************/

#include <types.h>

#define BUFSIZ 256			/* size of buffer */
struct tty_space
	{
	int   t_col;			/* column positioning */
	char *t_nxt;	 		/* pointer for reading next char */
	char  t_buf[BUFSIZ];	/* place for 256 chars */
	} tty_area;

extern int fault_cnt;
#define CTRL_S_DSA 1


printf(str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
char *str;	/* control string */
int  arg0;
int  arg1;
int  arg2;
int  arg3;
int  arg4;
int  arg5;
int  arg6;
int  arg7;
{
	return x_printf(0, str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

sprintf(buff, str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
char *buff;	/* buffer to hold formatted string output */
char *str;	/* control string */
int  arg0;
int  arg1;
int  arg2;
int  arg3;
int  arg4;
int  arg5;
int  arg6;
int  arg7;
{
	return x_printf(buff, str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

#define MAX_PRTF_ARGS	8 

/*
 * a hand coded printf.  uses putchar(c).
 * is called with control string and address of first argument
 */
x_printf(buff, str, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
char *buff;	/* buffer to hold formatted string output */
char *str;	/* control string */
int  arg0;
int  arg1;
int  arg2;
int  arg3;
int  arg4;
int  arg5;
int  arg6;
int  arg7;
	{
	int av[MAX_PRTF_ARGS];
	int i = 0;
	register char *s;
	char *oldbuff = buff;	/* start of buffer */
	int lenc;	/* number of characters width during prints */
	char adjs;	/* left (true) or right (false) adjustment */
	char argl;	/* arg is long flag */
	char padc;	/* padding character during prints */
	char base;	/* conversion base */

	av[0] = arg0;
	av[1] = arg1;
	av[2] = arg2;
	av[3] = arg3;
	av[4] = arg4;
	av[5] = arg5;
	av[6] = arg6;
	av[7] = arg7;
	/* printing */
	for (s = str; *s != 0; s++)
		{
		if (*s == '\\')
			{
			switch(*++s)
				{
			case 'n': chrout(&buff, '\n'); break;
			case 'r': chrout(&buff, '\r'); break;
			default:  chrout(&buff, *s);
				}
			continue;
			}
		if (*s != '%')
			{
			chrout(&buff, *s);	/* print the character */
			continue;	/* advance to next character */
			}

		padc = ' ';	/* padding is space */
		lenc = 0;	/* no padding yet */
		argl = 0;	/* arg is not long */
		adjs = 0;	/* right adjusted */
		base = 0;	/* no conversion base set yet */
		while (1)	/* until all of '%' cmd read */
			{
			switch(*++s)
				{
			case '-': adjs |= 1; continue;
			case '#': adjs |= 2; continue;
			case 'l': argl = 1;  continue;	/* long argument */

			case '0': if (lenc == 0) padc = '0';
			case '1': case '2': case '3': case '4':
			case '5': case '6': case '7': case '8': 
			case '9': lenc = lenc * 10 + *s - '0'; continue;

/*			case 'c': chrout(&buff, av[i++]); break;*/
			case 'c': cout(&buff, lenc, padc, av[i++], adjs); break;
			case 's': strout(&buff, lenc, padc, av[i++], adjs); break;

			case 'B': argl = 1;
			case 'b': base = 2;  break;
			case 'O': argl = 1;
			case 'o': base = 8;  break;
			case 'U':
			case 'D': argl = 1;
			case 'u':
			case 'd': base = 10; break;
			case 'X': argl = 1;
			case 'x': base = 16; break;

			default: chrout(&buff, *s); break;
				}

			if (base) 	/* need to convert */
				{
				if (argl)
					lnumout(&buff, base, padc, lenc, av[i++], adjs);
				else
					numout(&buff, base, padc, lenc, av[i++], adjs);
				}
			break;	/* out of while loop */
			} /* while loop */
		} /* for loop */

	if (buff != 0)	/* into buffer */
		*buff = 0;	/* string delimit */
	return buff - oldbuff;
	} /* end of procedure */



/*
 * numout - print a short number with specified field length, base, pad char
 */
numout(buff, base, padc, lenc, val, adjs)
char **buff;
unsigned int base;	/* representation base */
unsigned int padc;	/* padding character */
unsigned int lenc;	/* field width (0 = any) */
unsigned int val;	/* short value to print */
unsigned int adjs;	/* right or left adjustment */
	{
	char chars[17];	/* array of printable characters */
	register char *cp = &chars[16];
	int dig;	/* digit */

	/* start printing into buffer from rear */
	*cp = 0;	/* end of string marker */
	do
		{
		dig = val % base;	/* lowest digit value */
		val /= base;		/* new val 'shifted right' */
		if (0 <= dig && dig <= 9)
			*--cp = '0' + dig;
		else
			*--cp = 'a' + dig - 10;
		}
	while (val != 0);
	return strout(buff, lenc, padc, cp, adjs);	/* print the characters */
	}


/*
 * lnumout - print a long number with specified field length, base, pad char
 */
lnumout(buff, base, padc, lenc, lval, adjs)
char **buff;
unsigned int base;	/* representation base */
unsigned int padc;	/* padding character */
unsigned int lenc;	/* field width (0 = any) */
unsigned long lval;	/* long value to print */
unsigned int adjs;	/* right or left adjustment */
	{
	char chars[33];	/* array of printable characters */
	register char *cp = &chars[32];
	int dig;	/* digit */

	/* start printing into buffer from rear */
	*cp = 0;	/* end of string marker */
	do
		{
		dig = lval % base;	/* lowest digit value */
		lval /= base;		/* new lval 'shifted right' */
		if (0 <= dig && dig <= 9)
			*--cp = '0' + dig;
		else
			*--cp = 'a' + dig - 10;
		}
	while (lval != 0);
	return strout(buff, lenc, padc, cp, adjs);	/* print the characters */
	}

/*
 * cout - print the string (adding space pads if a length specified)
 */
cout(buff, length, padchar, c, adjs)
char **buff;
int length;
int padchar;
char c; 
int adjs;
	{
	register int padlen = 0;

	/* determine pad length */
	if (length)
		padlen = length - 1;

	/* right adjusted padding */
	if (!(adjs & 1))
		while (padlen-- > 0)
			chrout(buff, padchar);

	/* print the char */
	chrout(buff, c);

	/* left adjusted padding */
	if (adjs & 1)
		while (padlen-- > 0)
			chrout(buff, padchar);
	}



/*
 * strout - print the string (adding space pads if a length specified)
 */
strout(buff, length, padchar, str, adjs)
char **buff;
int length;
int padchar;
char *str; 
int adjs;
	{
	register char *s = str;
	register int padlen = 0;
	int l;

	/* determine pad length */
	if (length)
		{
		l = strlen(s);
		if (l <= length)
			padlen = length - l;
		else if (adjs & 2)
			{
			chrout(buff, '#');
			s += (1 + l - length);
			}
		}

	/* right adjusted padding */
	if (!(adjs & 1))
		while (padlen-- > 0)
			chrout(buff, padchar);

	/* print the string */
	while (*s != 0)
		chrout(buff, *s++);

	/* left adjusted padding */
	if (adjs & 1)
		while (padlen-- > 0)
			chrout(buff, padchar);
	}

chrout(b,c)
char **b;
char c;
{
	if (*b == 0)
		putchar(c);
	else
		*(*b)++ = c;
}


tty_in()
{
	int c;

	while ((c = getch()) == -1)
	{
		if (fault_cnt)
			;
		else
			ReSchedule();
	}
	return (char)c;
}

tty_out(c)
char c;
{
	while (putch(c) == -1)
	{
		if (fault_cnt)
			;
		else
			ReSchedule();
	}
}


/*
 * tty_ routines
 * 
 * ^H = erase     ^U = kill
 * input buffered for 254 chars , newline to terminate input
 */

ttyinit(baud)
int baud;
{
	setty(baud, CTRL_S_DSA);
	*(tty_area.t_nxt = tty_area.t_buf) = 0;
	tty_area.t_col = 0;
}


putchar(c)
register int c;
{
	/* character interpretation */
	switch(c &= 0x7f)
	{
	case '\n':
		tty_out('\n');
		/* fall through */
	case '\r':
		tty_out('\r');
		tty_area.t_col = 0;		/* at start of line */
		break;

	case '\t':
		do 
			tty_out(' ');	/* space til next tab stop */
		while (++tty_area.t_col & 0x03);
		break;

	default:
		if (c < 0x20)
		{
			tty_out('^');
			tty_out(c | 0x40);
			tty_area.t_col += 2;	/* took two characters */
		}
		else 
		{
			tty_out(c);
			tty_area.t_col += 1;	/* took one character */
		}
	} /* end of switch */
}

erase(c)
register int c;
{
	c &= 0x7f;
	if (c < 0x20)
	{
		tty_out(8);	/* backspace */
		tty_out(' ');	/* blank */
		tty_out(8);	/* backspace */
	}
	tty_out(8);	/* backspace */
	tty_out(' ');	/* blank */
	tty_out(8);	/* backspace */
}


getchar()
{
	if (*tty_area.t_nxt == 0)	/* empty buffer */
		_getline();
	return (*tty_area.t_nxt++ & 0x7f);	/* return next character */
}

_getline()
{
	register char *p = tty_area.t_nxt = tty_area.t_buf;
	static char lastchar = '\0';

	for (;;)
	{
		switch (*p = tty_in())
		{
		case 21:	/* CTRL-U */
			while (p != tty_area.t_buf)
				erase(*--p);
			break;
		case 8:  	/* CTRL-H */
		case 127:	/* DEL */
			if (p != tty_area.t_buf)
				erase(*--p);
			break;
		case  4:	/* CTRL-D */
			putchar(*p++);
			/* fall through to new line */
		case '\r':	/* Carriage Return */
			lastchar = *p;
			*p = '\n';	/* convert to line feed */
			putchar(*p++);
			*p = 0;		/* delimit input line */
			return;
		case '\n':	/* line feed */
			if (lastchar != '\r')
			{
				lastchar = '\0';
				putchar(*p++);
				*p = 0;		/* delimit input line */
				return;
			}
			break;
		default:	/* Character */
			if (p == &tty_area.t_buf[BUFSIZ-2])
				tty_out(7);	/* ring a bell */
			else
				putchar(*p++);
		} /* end of switch */
		lastchar = '\0';
	} /* end of for loop */
}

gets(char *string)
{
	while ((*string++ = getchar() & 0x7f) != '\n')
		continue;

	/*	replace the '\n' with '\0'.  */

	*(string - 1) = '\0';
}

puts(char *string)
{
	char c;

	while ((c = *string++) != '\0')
		putchar(c);
	putchar('\n');
}
