

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	memchr.c
*
*	$Log:   /b/gregs/i960/libc/memchr.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:22   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:02   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:24   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:16   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:40   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:14   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:02   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include "types.h"
#include "inc.h"

/*
 * memchr - search for a byte
 *
 * CHARBITS should be defined only if the compiler lacks "unsigned char".
 * It should be a mask, e.g. 0377 for an 8-bit machine.
 */

#ifdef NULL
#undef NULL
#endif

#define	NULL	0

#ifndef CHARBITS
#	define	UNSCHAR(c)	((unsigned char)(c))
#	define  uchar		unsigned char
#else
#	define	UNSCHAR(c)	((c)&CHARBITS)
#	define  uchar		char
#endif

#undef memchr 
VOIDSTAR
memchr(s, ucharwanted, size)
CONST VOIDSTAR s;
int ucharwanted;
SIZET size;
{
	register CONST uchar *scan;
	register SIZET n;
	register int uc;

	scan = s;
	uc = UNSCHAR(ucharwanted);
	for (n = size; n > 0; n--)
		if (UNSCHAR(*scan) == uc)
			return((VOIDSTAR)scan);
		else
			scan++;

	return(NULL);
}
