
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	krnl.c
*
*	$Log:   /b/gregs/i960/kernel/krnl.c_v  $
 * 
 *    Rev 1.6   12 Oct 1993 09:54:06   franks
 * 
 *    Rev 1.5   29 Sep 1993 10:23:12   franks
 * No change.
 * 
 *    Rev 1.4   10 Sep 1993 15:23:26   franks
 * No change.
 * 
 *    Rev 1.3   08 Sep 1993 11:22:00   franks
 * No change.
 * 
 *    Rev 1.2   13 Aug 1993 16:07:04   franks
 * Added some stuff to the 10ms timer routine.
 * 
 *    Rev 1.1   30 Jul 1993 13:45:54   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 11:11:20   franks
 * Initial revision.
 * 
 *    Rev 1.3   14 Apr 1993 17:12:42   kenb
 * Moved the application task to after the timer_task. There were timers that
 * were expiring in the application before the timer_task was allowed to run.
 * 
 *    Rev 1.2   03 Jun 1992 14:09:50   suresh
 * Removed the debug (enter_debug) code, and added #ifdef KRNLASM
 * to remove TimeSlice routine from being compiled.
 * 
 *    Rev 1.1   09 Apr 1992 11:28:10   pvcs
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 16:56:04   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include  <krnl.h>

KRNL krnl;

extern int(*pkt_proc_upcall)();
extern TimeTicksInt();
extern TimeSliceInt();
extern Nop();
extern word fault_cnt;
extern word EepromDirty;
extern void timer_task();

/* equates declaration */

#define	SWAP_WDT_NUM	8	/* reset WDT ecery eigth swap. */
#define STK_LEN		2048	/* length of stack for timer task */

/* 	init the OS system variables and create the first       */
/* 	task; schedule this task to run; also create timer task */

StartKernel(subr, stack_ofst, stack_len, max_tasks, slice_time)
register void (*subr)();		/* subroutine to call on expiration */
register word *stack_ofst;   	/* new task's stack end */
register int  stack_len;     	/* new task's stack length (bytes) */
register int max_tasks;        /* max number of tasks in this program */
register int slice_time;	/* time slice period */
{
	register TCB *tcb;
	register word *timer_stack;
	register int i;
	register KRNL *krnl_ptr;
/*
	register word saveMask;
*/

/*	MaskAllInts(saveMask); */
	Di();
	krnl_ptr = &krnl;
	/* allocate memory for the task control block's */
	if ((krnl_ptr->krnl_tcb_ptr = (TCB *)tcb_malloc((max_tasks + 2) * sizeof(TCB))) == NULL)
	{
		fault_cnt = 1;
		printf("Memory Limit Exceeded : StartKernel, tcb_malloc\n");
		fault_cnt = 0;
		reset();
	}
	krnl_ptr->krnl_max_tcb = max_tasks + 2;/* 2 = this task & timer task */
	for(tcb = krnl_ptr->krnl_tcb_ptr, i = 0; i != krnl_ptr->krnl_max_tcb; tcb++, i++)
	{
		tcb->tc_marker = NULL;
		tcb->tc_state = TCB_NOTINUSE;
	}

	krnl_ptr->krnl_rdy_head = NULL;
	krnl_ptr->krnl_run_task = NULL;


	krnl_ptr->krnl_swap_cnt = krnl_ptr->krnl_swap_maxcnt = SWAP_WDT_NUM;
	CreatMailbox(&krnl_ptr->krnl_tmr_list);
	krnl_ptr->krnl_ticks = 0;

	/* start the timer task */
	if ((timer_stack = (word *)stk_malloc(STK_LEN)) == NULL)
	{
		fault_cnt = 1;
		printf("Memory Limit Exceeded : StartKernel, stk_malloc\n");
		fault_cnt = 0;
		reset();
	}
	CreatTask(timer_task, timer_stack, STK_LEN, NULL);
	/* User task must run after timer_task */
	CreatTask(subr, stack_ofst, stack_len, NULL);
	krnl_ptr->krnl_run_task = NULL;
	krnl_ptr->krnl_slice_time = slice_time;
	(int)pkt_proc_upcall = Nop; /* set up by channel driver later */
	InitKrnlTimers();
	Ei();
	/* RestoreIntMask(saveMask); */
	task_switch();
}

InitKrnlTimers()
{
	Init_timers();
	prog_timers(1, TimeTicksInt, 1, 1);
	prog_timers(2, TimeSliceInt, 2, krnl.krnl_slice_time);
}

/* Function creates specified task, then put it on ready queue. */
/* initialize the new task TCB, fake out stack to get  */
/* the task IP in for task_switch to return to.        */

TCB *CreatTask(subr, stack_ofst, stack_len, arg)
register void	(*subr)();	/* subroutine to call on expiration */
register word *stack_ofst;	/* new task's stack end */
register int  stack_len;	/* new task's stack length (bytes) */
register int arg;		/* arg to pass to subr. */
{
	register TCB *tcb;           /* new task's TCB */
	register FRM *frm;
	register int i;
	register KRNL *krnl_ptr;

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	krnl_ptr = &krnl;
	for(tcb = krnl_ptr->krnl_tcb_ptr, i = 0; i != krnl_ptr->krnl_max_tcb; tcb++, i++)
	{
		if (tcb->tc_marker != TCB_MARKER)
			break;
	}

	if (i == krnl_ptr->krnl_max_tcb)
		reset();

	tcb->tc_flink = NULL;
	tcb->tc_marker = TCB_MARKER;
	tcb->tc_mode = USER_MODE;
	tcb->tc_ip = (char *)subr;
	tcb->tc_g0 = arg;
	tcb->tc_mbox = NULL;	/* pointer to mbox this tcb is blocked on */
	tcb->tc_pfp = (char *)(stack_ofst);
	tcb->tc_stk_marker_ptr = (char *)stack_ofst + stack_len - 4;
	*(int *)(tcb->tc_stk_marker_ptr) = STK_MARKER;
	frm = (FRM *)stack_ofst;
	frm->f_pfp = (word)(stack_ofst);
	frm->f_sp = (word)stack_ofst + 64;
	frm->f_rip = (word)subr;

	insert_rdy_task(tcb);	/* make task ready */
	modpc(0x001f0000, save_pc); /* restore the priority */
	return tcb;
}


/* reschedule the task, to let other tasks run. */

ReSchedule()
{
	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	/* remove current task off list, add task to the back of the list */
	insert_rdy_task((TCB *)desert_run_task());
	/* swap task */
	task_switch();/* do this always: WDT maintenance */
	modpc(0x001f0000, save_pc); /* restore the priority */
}


/* 	init an array of bytes as a mailbox */

CreatMailbox(mbox)
register MBOX   *mbox;      /* mailbox being created */
{
	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	mbox->mb_tflink = NULL;
	mbox->mb_marker = MBX_MARKER;
	mbox->mb_mflink = NULL;
	mbox->mb_mblink = NULL;
	mbox->mb_count = ZERO;
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* 	init an array of bytes as a message */

CreatMessage(msg)
register MSGHDR *msg;      /* message being created */
{
	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	msg->mh_link = NULL;
	msg->mh_marker = MSG_MARKER;
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* Send the message to the mailbox,           */
/* if there is a task waiting on the mailbox, */
/* unblock that task                          */

SendMessage(msg, mbox)
register MSGHDR *msg;       /* message being sent */
register MBOX   *mbox;      /* mailbox to receive message */
{
	register TCB *tcb;           /* new task's TCB */

	register word save_pc = modpc(0x001f0000, 0x001f0000);/* increase the priority */
	/* Put message in queue */
	enq_mb_msg(msg, mbox);

	if (mbox->mb_tflink != NULL)
	{
		insert_rdy_task(tcb = (TCB *)Dequeue(mbox));/*make task ready*/
		tcb->tc_mbox = NULL;
	}
	modpc(0x001f0000, save_pc); /* restore the priority */
}

/* Returns the first message on the specified */
/* mailbox to the calling task                */

MSGHDR *RcvMessage(mbox)
register MBOX   *mbox;      /* mailbox containing message */
{
	register TCB *tcb;           /* new task's TCB */
	register MSGHDR *msg;       /* message */

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	for (;;)
	{
		/* check if any message available */
		if (mbox->mb_count != ZERO)
			break;

		/* no message, put current task on queue */
		/* set task wait status */
		tcb = (TCB *)desert_run_task();
		tcb->tc_state = TCB_BLOCKED;
		tcb->tc_mbox = (char *)mbox;

		/* remove task from ready list, put task in mailbox task list */
		Enqueue((MSGHDR *)tcb , (MBOX *)mbox);
		task_switch();           /* swap task */

		/* get control back, check if message still there */
	}

	/* message available, get the first one and return */
	msg = (MSGHDR *)deq_mb_msg(mbox);	/* get first message of list */
	modpc(0x001f0000, save_pc); /* restore the priority */
	return msg;
}



/* Removes & returns the first message on mailbox */
/* return NULL if no message available            */

MSGHDR *AcptMessage(mbox)
register MBOX   *mbox;      /* mailbox containing message */
{
	register MSGHDR *msg;       /* message */

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	msg = (MSGHDR *)deq_mb_msg(mbox);	/* get first message of list */
	modpc(0x001f0000, save_pc); /* restore the priority */
	return msg;
}



/* returns the specified message on the mailbox */
/* if none return NULL                          */

MSGHDR *RmvMessage(msg, mbox)
register MSGHDR *msg;       /* message being removed */
register MBOX   *mbox;      /* mailbox containing message */
{
	register MSGHDR *mes;       /* message */

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	mes = (MSGHDR *)RMV_MB_MSG(msg, mbox); 	/* remove the message */
	modpc(0x001f0000, save_pc); /* restore the priority */
	return mes;
}



/* init the data structure of the specified semaphore */

CreatSemaphore(sem, signal_count)
register SEM  *sem;         /* semaphore being initialized */
int signal_count;  /* number signals on semaphore */
{
	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	sem->sm_tflink = NULL;
	sem->sm_marker = SEM_MARKER;
	sem->sm_count = signal_count;
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* cause the semaphore to be incremented; if count >0 */
/* and there is a task waiting, unblock that tasks;   */

SendSignal(sem)
register SEM  *sem;         /* semaphore being signaled */
{
	register TCB *tcb;           /* new task's TCB */

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	sem->sm_count++; 

	if (sem->sm_tflink != NULL)
	{
		insert_rdy_task(tcb = (TCB *)Dequeue((MBOX *)sem));/* make task ready */
		tcb->tc_mbox = NULL;
	}
	modpc(0x001f0000, save_pc); /* restore the priority */
}


/* removes a signal from the semaphore; if the semaphore */
/* count is 0, the calling task blocks on the semaphore */
/* until the sem is greater than 0                      */

RcvSignal(sem)
register SEM  *sem;         /* semaphore containing signal */
{
	register TCB *tcb;           /* new task's TCB */

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	for (;;)
	{
		/* check if any message available */
		if (sem->sm_count != ZERO)
			break;

		/* no message, put current task on queue */
		/* set task wait status */
		tcb = (TCB *)desert_run_task();
		tcb->tc_state = TCB_BLOCKED;
		tcb->tc_mbox = (char *)sem;

		/* remove task from ready list, put task in sem task list */
		Enqueue((MSGHDR *)tcb, (MBOX *)sem);
		task_switch();           /* swap task */

		/* get control back, check if message still there */
	}
	sem->sm_count--; 
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* removes a signal if one is available and returns 1; */
/* if none available, returns 0                        */

AcptSignal(sem)
register SEM  *sem;         /* semaphore containing signal */
{
	register int ret_value;

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	ret_value = 0;
	if (sem->sm_count != 0)
	{
		sem->sm_count--;
		ret_value = 1;
	}
	modpc(0x001f0000, save_pc); /* restore the priority */
	return ret_value;
}



/* init an array of bytes as a timer */

CreatTimer(timer)
register TIMER *timer;      /* timer being initialized */
{
	register KRNL *krnl_ptr;

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	krnl_ptr = &krnl;
	/* if already inited and running, stop it */
	if ((timer->tm_marker == TMR_MARKER) && (timer->tm_state != TM_IDLE))
		StopTimer(timer);

	timer->tm_flink = NULL;
	timer->tm_marker = TMR_MARKER;
	timer->tm_state = TM_IDLE;
	timer->tm_mbox = NULL;
	timer->tm_delay = ZERO;
	timer->tm_subr = NULL;
	timer->tm_arg = ZERO;
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* set timer to run for a specified number of clock ticks */
/* insert the timer message in the delay head; the task   */
/* has the responsibility to wait at the mailbox for the  */
/* message in case timer expires; when timer expires, it  */
/* is sent to the specified mailbox                       */

StartTimer(timer, ticks, t_o_mbox)
register TIMER *timer;      /* timer being started */
int    ticks;      /* 10ms ticks til expiration */
MBOX  *t_o_mbox;   /* mailbox to send expired timer */
{
	register MBOX  *mbox;
	register TIMER *tim;
	register TIMER *tmr;
	register KRNL *krnl_ptr;

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	krnl_ptr = &krnl;
	if (timer->tm_state != TM_IDLE)
		StopTimer(timer);

	/* init timer message status and mailbox */
	timer->tm_state = TM_RUNNING;
	timer->tm_mbox = t_o_mbox;

	/* insert timer in the delay head */
	mbox = (MBOX *)&krnl_ptr->krnl_tmr_list;
	for (tmr = (TIMER *)mbox->mb_mflink, tim = (TIMER *)&mbox->mb_mflink; tmr != NULL; tmr= tmr->tm_flink)
	{
		if (ticks <= tmr->tm_delay)
			break;
		ticks -= tmr->tm_delay;
		tim = tmr;
	}

	/* add the new entry after the tim entry and before the */
	/* tmr entry; the tmr entry count has to be decremented */
	/* by the new entry count */
	timer->tm_flink = tmr;
	tim->tm_flink = timer;
	timer->tm_delay = ticks;
	if (tmr != NULL)
		tmr->tm_delay -= ticks;
	mbox->mb_count++;
	modpc(0x001f0000, save_pc); /* restore the priority */
}



/* remove the timer message from the delay queue if it is */
/* running; if it is expired, remove the message from the */
/* expiration mailbox; make the timer idle                */

MSGHDR *StopTimer(timer)
register TIMER *timer;      /* timer being stopped */
{
	register TIMER *tmr;
	register KRNL *krnl_ptr;
	register MSGHDR *msg;

	register word save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	krnl_ptr = &krnl;
	msg = NULL;
	/* decide what timer is doing */
	if (timer->tm_state != TM_RUNNING)
	{
		if (timer->tm_state == TM_EXPIRED)
			/* timer expired, remove message from mailbox */
			msg = RMV_MB_MSG((MSGHDR *)timer, timer->tm_mbox);
	}
	else
	{
		if ((tmr = timer->tm_flink) != NULL)
			tmr->tm_delay += timer->tm_delay;
		/* timer running, take the message off delay list */
		msg = RMV_MB_MSG((MSGHDR *)timer, (MBOX *)&krnl_ptr->krnl_tmr_list);
	}
	timer->tm_state = TM_IDLE;
	modpc(0x001f0000, save_pc); /* restore the priority */
	return msg;
}



/*
* Set a timer.  store processing routine and argument for later.
*/
StartTimerCall(timer, ticks, subr, arg)
register TIMER 	*timer;      	/* timer being started */
register int	ticks;		/* timer expiration time */
register void	(*subr)();	/* subroutine to call on expiration */
register int	arg;		/* arg to pass to subr. */
{
	register KRNL *krnl_ptr;
	register word save_pc;

	if (ticks == 0)
		return;

	save_pc = modpc(0x001f0000, 0x001f0000); /* increase the priority */
	krnl_ptr = &krnl;
	timer->tm_subr = subr;		/* subroutine to call */
	timer->tm_arg = arg;		/* argument to pass */
	StartTimer(timer, ticks, &krnl_ptr->krnl_TmrMbox);
	modpc(0x001f0000, save_pc); /* restore the priority */
}


/* examine the ready list and schedule the first task   */
/* on this list; if the current running task is swapped */
/* out, save its context #####                          */

task_switch()
{
	register KRNL *krnl_ptr = &krnl;
	register TCB *tcb;

	if (!(--krnl_ptr->krnl_swap_cnt))
	{
		FlkActLed();
		krnl_ptr->krnl_swap_cnt = krnl_ptr->krnl_swap_maxcnt;
		RefreshWDT();
	}
	if (krnl_ptr->krnl_run_task != krnl_ptr->krnl_rdy_head)
	{
		if (tcb = krnl_ptr->krnl_run_task)
		{
			if ((*(int  *)(tcb->tc_stk_marker_ptr)) != STK_MARKER)
			{
				fault_cnt = 1;
				printf("%08X : %08X : %08X bad stack marker\n", tcb, tcb->tc_ip, tcb->tc_g0);
				fault_cnt = 0;
				reset();
			}

			if (tcb->tc_marker != TCB_MARKER)
			{
				fault_cnt = 1;
				printf("%08X : %08X : %08X bad tcb marker\n", tcb, tcb->tc_ip, tcb->tc_g0);
				fault_cnt = 1;
				reset();
			}

			/* swap out*/
			asm ("mov g0, %0" : "=b" (tcb->tc_g0));
			asm ("mov g8, %0" : "=b" (tcb->tc_960reg[0]));
			asm ("mov g9, %0" : "=b" (tcb->tc_960reg[1]));
			asm ("mov g10, %0" : "=b" (tcb->tc_960reg[2]));
			asm ("mov g11, %0" : "=b" (tcb->tc_960reg[3]));
			asm ("mov pfp,%0" : "=b" (tcb->tc_pfp));
			krnl_ptr->krnl_run_task = NULL;

			if (((int)tcb->tc_stk_marker_ptr - (int)tcb->tc_pfp) < 256)
			{
				fault_cnt = 1;
				printf("%08X : %08X : %08X stack overflow\n", tcb, tcb->tc_ip, tcb->tc_g0);
				fault_cnt = 0;
				reset();
			}
		}

		if (tcb = krnl_ptr->krnl_rdy_head)
		{
			/* swap in */
			if (tcb->tc_marker != TCB_MARKER)
			{
				fault_cnt = 1;
				printf("%08X : %08X : %08X bad tcb marker\n", tcb, tcb->tc_ip, tcb->tc_g0);
				fault_cnt = 0;
				reset();
			}
			krnl_ptr->krnl_run_task = tcb;
			tcb->tc_state = TCB_RUNNING;
			/* to start each task in lower priority */
			/* with interrupts enabled */
			if (!(tcb->tc_mode))
			{
				tcb->tc_mode = KRNL_MODE;
				modpc(0x001f0000, 0x00000000);
			}
			asm ("flushreg");
			asm ("mov %0,g0" : : "b" (tcb->tc_g0));
			asm ("mov %0,g8" : : "b" (tcb->tc_960reg[0]));
			asm ("mov %0,g9" : : "b" (tcb->tc_960reg[1]));
			asm ("mov %0,g10" : : "b" (tcb->tc_960reg[2]));
			asm ("mov %0,g11" : : "b" (tcb->tc_960reg[3]));
			asm ("mov %0,pfp" : : "b" (tcb->tc_pfp));
		}
		else
		{
			fault_cnt = 1;
			printf("NULL tcb\n");
			fault_cnt = 0;
			reset();
		}
	}
}

/* puts a specified object at the end of the specified list */
/* assume the first word of object is the link field        */

Enqueue(msg, mbox)
register MSGHDR *msg;       /* message being sent */
register MBOX   *mbox;      /* mailbox to receive message */
{
	register MSGHDR *mes;       /* message being sent */

	msg->mh_link = NULL;
	for(mes = (MSGHDR *)&mbox->mb_tflink; mes->mh_link != NULL; mes = mes->mh_link)
		;
	mes->mh_link = msg;
}



/* removes the first object of a linked list         */
/* assume the first word of object is the link field */

MSGHDR *Dequeue(mbox)
register MBOX   *mbox;
{
	register MSGHDR *msg;

	if ((msg = (MSGHDR *)mbox->mb_tflink) != NULL)
	{
		mbox->mb_tflink = (char *)msg->mh_link;
		msg->mh_link = NULL;
	}
	return msg;
}


/* remove the specified task from the given mailbox. */

Remove(tcb, mbox)
register TCB *tcb;           /* new task's TCB */
register MBOX   *mbox;      /* mailbox to receive message */
{
	register TCB *tc;
	register TCB *tb;

	tb = (TCB *)&mbox->mb_tflink;

	for(tc = tb->tc_flink; tc != NULL; tc = tc->tc_flink)
	{
		if (tc == tcb)
			break;
		tb = tc;
	}

	if (tc != NULL)
	{
		tb->tc_flink = tc->tc_flink;
		tc->tc_flink = NULL;
	}
}


/* puts a specified message at the end of the mailbox */
/* message list;                                      */

enq_mb_msg(msg, mbox)
register MSGHDR *msg;       /* message being sent */
register MBOX   *mbox;      /* mailbox to receive message */
{
	register MSGHDR *sag;       /* message being sent */

	msg->mh_link = NULL;
	sag = (MSGHDR *)mbox->mb_mblink;
	mbox->mb_mblink = (char *)msg;
	mbox->mb_count++;
	if (sag == NULL)
		mbox->mb_mflink = (char *)msg;
	else
		sag->mh_link = msg;
	return;
}



/* remove the first message from a queue */

MSGHDR *deq_mb_msg(mbox)
register MBOX   *mbox;      /* mailbox containing message */
{
	register MSGHDR *msg;

	if ((msg = (MSGHDR *)mbox->mb_mflink) != NULL)
	{
		mbox->mb_count--;
		mbox->mb_mflink = (char *)msg->mh_link;
		if (mbox->mb_mflink == NULL)
			mbox->mb_mblink = NULL;
		msg->mh_link = NULL;
	}
	return msg;
}



/* remove a particular message from the mailbox */

MSGHDR *RMV_MB_MSG(msg, mbox)
register MSGHDR *msg;       /* message being removed */
register MBOX   *mbox;      /* mailbox containing message */
{
	register MSGHDR *sag;       /* message being removed */

	for (sag = (MSGHDR *)&(mbox->mb_mflink); sag->mh_link != NULL; sag = sag->mh_link)
	{
		if (sag->mh_link == msg)
		{
			sag->mh_link = msg->mh_link;
			msg->mh_link = NULL;
			mbox->mb_count--;
			if (sag->mh_link == NULL)
			{
				mbox->mb_mblink = (char *)sag;
				if (sag == (MSGHDR *)&(mbox->mb_mflink))
					mbox->mb_mblink = NULL;
			}
			return msg;
		}
	}
	return (MSGHDR *)NULL;
}



/* append the specified task to the ready queue. */

insert_rdy_task(tcb)
register TCB *tcb;           /* new task's TCB */
{
	register TCB *tc;
	register KRNL *krnl_ptr = &krnl;

	tcb->tc_state = TCB_READY;
	for(tc = (TCB *)&krnl_ptr->krnl_rdy_head; tc->tc_flink != NULL; tc = tc->tc_flink)
		;
	tc->tc_flink = tcb;
	tcb->tc_flink = NULL;
}



/* remove the top task from the ready queue. */

TCB *desert_run_task()
{
	register TCB *tcb;           /* task's TCB */
	register KRNL *krnl_ptr = &krnl;

	tcb = (TCB *)krnl_ptr->krnl_rdy_head;
	if (tcb != NULL)
	{
		(TCB *)krnl_ptr->krnl_rdy_head = tcb->tc_flink; 
		tcb->tc_flink = NULL;
	}
	return tcb;
}

/* remove the specified task from the ready queue. */

remove_rdy_task(tcb)
register TCB *tcb;           /* new task's TCB */
{
	register TCB *tc;
	register TCB *tb;
	register KRNL *krnl_ptr = &krnl;

	if ((tb = (TCB *)krnl_ptr->krnl_rdy_head) == tcb)
	{
		fault_cnt = 1;
		printf("Cannot remove the current task\n");
		fault_cnt = 0;
		return NULL;
	}

	for(tc = tb->tc_flink; tc != NULL; tc = tc->tc_flink)
	{
		if (tc == tcb)
			break;
		tb = tc;
	}

	if (tc != NULL)
	{
		tb->tc_flink = tc->tc_flink;
		tc->tc_flink = NULL;
	}
}


/*
* This routine forms the body of the timer management task.
* on expired timer, it calls the processing routine with the arg.
*/
void timer_task()
{
	TIMER	*tm;		/* temp for holding timer */
	register KRNL *krnl_ptr = &krnl;

	CreatMailbox(&krnl_ptr->krnl_TmrMbox);

	for (;;) 
	{			/* never exit */
		tm = (TIMER *)RcvMessage(&krnl_ptr->krnl_TmrMbox);
		(*tm->tm_subr) (tm->tm_arg); /* call the routine */
	}
}	


TimeTicks()
{
	register TIMER *tmr;
	register KRNL *krnl_ptr = &krnl;
	extern unsigned int drv_init_flag;

	/* 10 msec processing */
	krnl_ptr->krnl_ticks++;

	/* this routine will process fddi smt frames */
	if( drv_init_flag ) {
		RxSMTFrameIsr(0);
		FDDITimerTicksInt();
	}

	/* routine which handles the ageing function of the bridge */
	prc_age();

	/* routine which gathers channel driver stats */
	snc_fpd_tmr(); 


	/* eeprom update */
	if (EepromDirty)
		ProgEeprom();

	/* kernel timer list handling */
	if ((tmr = (TIMER *)krnl_ptr->krnl_tmr_list.mb_mflink) != NULL)
	{
		if (tmr->tm_delay)
			tmr->tm_delay--;
		do
		{
			if (tmr->tm_delay)
				break;
			else
			{
				tmr = (TIMER *)deq_mb_msg(&krnl_ptr->krnl_tmr_list);
				tmr->tm_state = TM_EXPIRED;
				SendMessage((MSGHDR *)tmr, (MBOX *)tmr->tm_mbox);
			}
		} while ((tmr = (TIMER *)krnl_ptr->krnl_tmr_list.mb_mflink) != NULL);
	}

	/*update_tod_clock(); */

	/* flicker the led's */
	flk_leds();
}


#ifdef KRNLASM
/* 
 * Time Slice Int
 * duties: channel driver calls, calls set up by the application
 */


TimeSlice()
{
	modpc(1,1);

	enable_imsk(1);

	(int)((*pkt_proc_upcall)());

	snc_fpd_pkt();

	poll_uart();

	if (1 & get_ipnd())
	{
		TimeTicks();
		clear_ipnd(1);
	}

	RetriggerTimeSliceTimer();
}

#endif

/*
* exports to users
*/

/* add element to MBOX queue */

enqueue(msg, mbox)
MSGHDR *msg;       /* message being removed */
MBOX   *mbox;      /* mailbox containing message */
{

	enq_mb_msg(msg, mbox);
}



/* remove element from MBOX queue */

MSGHDR *dequeue(mbox)
MBOX   *mbox;      /* mailbox containing message */
{

	return deq_mb_msg(mbox);
}


TCB *CurrentTask()
{
	register KRNL *krnl_ptr = &krnl;

	return krnl_ptr->krnl_run_task;
}

RealTimeTicks()
{
	register KRNL *krnl_ptr = &krnl;

	return krnl_ptr->krnl_ticks;
}
