/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/
/*
 *	Kwok Kong	2.8.91
 *	replaced all unsigned, word, unsword with ushort for i960
 */
 
/*  Copyright 1983 by the Massachusetts Institute of Technology  */

/* UDP Header structure */

#ifndef	__UDP_H
#define	__UDP_H


struct udp
	{
	ushort	ud_srcp;	/* source port */
	ushort	ud_dstp;	/* dest port */
	ushort	ud_len;		/* length of UDP packet */
	ushort	ud_cksum;	/* UDP checksum */
	};

/* The UDP Connection structure */
struct udp_conn
	{
	struct udp_conn *u_next;
	uint	u_lport;	/* local port */
	uint	u_fport;	/* foreign port */
	in_name	u_fhost;	/* foreign host */
	int	(*u_rcv)();	/* incoming packet handler */
	uint	u_data;		/* fooish thing */
	int	u_fd;		/* network file descriptor */
	/* This is for making the size of UDPCON and TIMER diffrent */
	/* so that the malloc will return the right pointer. This will be */
	/* fixed properly later on........Ramki */
	int	dummy[2];	
	};

typedef	struct udp_conn *UDPCONN;

/*
 *	Added by K Kong
 */
struct udp_stat
	{
	ulong	indgrams;
	ulong	outdgrams;
	ulong	noport;
	ulong	inerror;
	ulong	chksum;
	};
typedef	struct udp_stat	UDP_STAT;

extern	UDP_STAT	UdpStat;

#define	udp_indgrams	UdpStat.indgrams
#define	udp_outdgrams	UdpStat.outdgrams
#define	udp_noport	UdpStat.noport
#define	udp_inerror	UdpStat.inerror

/* Some goodly constants, macros and an external */
#define	UDPPROT	17	/* UDP Internet protocol number */
#define	UDPLEN	8

#define udp_head(pip)	((struct udp *)in_data((pip)))
#define udp_data(pup)	(((char *)pup) + sizeof(struct udp))

extern UdpInit();
extern UDPCONN udp_open();
extern udp_close();
extern udp_send();
extern udp_send_to();
extern udp_socket();
#define udp_free(pkt)	in_free((pkt))

extern UDPCONN firstudp;

#endif
