/* tftp.h */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

/* EMACS_MODES: c !fill */
/*
 *	1.30.91		Kwok Kong
 *	add done and timeout flags in TFTPTBL.
 *	For 960, it's better to make the variables to be
 *	a multiples of 4 bytes for alignment problem.
 */

/*
 * This file contains the structure definitions for tftp packets.
 */

#ifndef	__TFTP_H
#define	__TFTP_H

#define	DATALEN	512		/* size of data portion of tftp pkt */
/*
 *	REQ or WEQ packet format
 */
typedef struct	tftp_req
	{
	ushort   opcode;
	byte	fname[1];	/* Remote file name */
	byte	null1;	/* Zero */
	byte	mode;	/* netascii or image */
	byte	null2;	/* Zero */
	}
	TREQ;
/*
 *	DATA packet format
 */
typedef struct	tftp_data
	{
	ushort	opcode;
	ushort	blkno;	/* Block number */
	byte	blk;	/* Data */
	}
	TDATA;
/*
 *	ERROR  packet format
 */
typedef struct tftp_error
	{
	ushort	opcode;
	ushort	errcode;	/* Error code */
	byte	errmsg;
	}
	TERROR;
/* 
 *	ACK packet format
 */
typedef struct tftp_ack
	{
	ushort opcode;
	ushort ackno;
	}
	TACK;

	/* values for f_opcode */
#define	RRQ	1	/* Read Request */
#define	WRQ	2	/* Write Request */
#define	DATA	3	/* Data block */
#define	DACK	4	/* Data Acknowledge */
#define	ERROR	5	/* Error */

#define	TFTPORT	69		/* tftp socket number */
#define TFTPSIZ		sizeof(struct tftp)

/* values for error codes in ERROR packets */

#define TEUNDEF	0	/* Not defined, see error message (if any) */
#define TEFNF	1	/* File not found */
#define TEACESS	2	/* Access violation */
#define TEFULL	3	/* Disc full or allocation exceeded */
#define TETFTP	4	/* Illegal TFTP operation */
#define TETID	5	/* Unknown transfer ID */
#define	TEEXIST	6	/* File already exists */
#define TENOUSR	7	/* Bad user id for mail */
#define	MAXECODE	TENOUSR

/* Random constants */

#define	READ	RRQ	/* read requested */
#define	WRITE	WRQ	/* write requested */

#define	NETASCII	0		/* netascii transfer mode */
#define	IMAGE		1		/* image transfer mode */
#define	MAIL		2		/* mail transfer mode */

#define	INPKT		0		/* input packet */
#define	OUTPKT		1		/* output packet */

#define	INETLEN		576		/* max inet packet size */

#define	TRUE		1
#define	FALSE		0

#define NOCON   0    /* tftp idle state */
#define REQ    1    /* tftp request state */
#define CON    2    /* Working state */

#define MAXRTXCNT	10	/*max no. of retransmission for READ */
#define MAXDTXCNT	10	/*max no. of retransmission for DATA */

extern int tftp_rrq(in_name ip, char *pathstr, char *mode);
extern int tftprcv(PACKET pkt, uint length, in_name fhost,
		uint sport, uint dport, void *tag, in_name lhost);
extern int send_ack(TFTPTBL *tftp);
extern int send_error(uint code, in_name ip, uint sport, uint dport);
#endif
