

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**         This file contains modules for SNMP stuff
**
*******************************************************/
#define syteksnm_inc

#ifndef	asn1_inc
#include <asn1.h>
#endif
/*   SYTEK SNMP modified version 1.0      2-22-89			*/

#define SNMP_VERSION        0x01
#define SNMP_SUB_VERSION    0x01
#define SNMP_MIB_VERSION    3

/*********************************************
** Define the operations in service routine 
**********************************************/
#define SNMP_GET    0
#define SNMP_SET    1
#define SNMP_GETNXT 2
#define SNMP_TEST   3


/*************************************************
** Define  the alarm enable types 
**************************************************/
#define  ALARM_ENABLE   0
#define  ALARM_DISABLE  0x02

/*************************************************
** Define  the  ALARM ID  for the alarm upcall
**************************************************/
#define  GENERIC_TRAP   0
#define  SPECIFIC_TRAP  1

/*************************************************
** Define  the ALARM ID  for the GENERIC TRAP
**************************************************/
/* see SNMP.H  */

/*************************************************
** Define  the ALARM ID  for the SPECIFIC TRAP
**   Remember to change this in inc\sytek.h
**************************************************/
#define  ASSOC_ATTEMPT		0
#define  ASSOC_DONE			1
#define  SESSION_ABORT      2
#define  NVRAM_ERR          3
#define  sessConnFail       5    /* connecting fail */
#define sessConnected       6    /* session has established */
#define sessClose           7    /* session close */
#define sessAbort           8    /* session abort */
#define  SPECIFIC_MAX       9	/* ### UPDATE IT, AFTER ADD NEW ALARM ID */

/*	
 *	Bit definitions for Specific traps
 */	
#define NVRAMERR	0x08
#define	SESCONFAIL 	0x20
#define SESCONNECTED 	0x40
#define SESCLOSE	0x80
#define SESABORT	0x100

long	get_newvalue();

#define CSIZE 32   /* community string size */
#define VBCOUNT 20  /* number of VarBInd is allocated */

#define    ERR_INSTANCE       NO_SUCH_NAME

/*****************************************
**  Define Error Return Code
******************************************/

#define    VALUE_IN_USED     1000   /* value in used */
#define    INVA_REQ          1001   /* invalid request, generally use*/
/*for no priv*/
#define    TABLE_FULL        1002   /* specific table is full */
#define    WRITE_ONLY        1003   /* WRite Only object */

#define    ERR_WRTCMOS       1004   /* unable to write NVRAM */

#define    ERR_INSTANCE       NO_SUCH_NAME

/*********************************************************************
**     Define the value to identify the SNMP ADM 
*********************************************************************/
#define    SNMP_TAG  			    100 

/**********************************************************************
**    Define Association State
**********************************************************************/
#define   	IDLE_STATE     			0
#define    	WAIT_SECURITY_RESPONSE	1
#define  	ASSOCIATED				2


/***********************************************************************
**     Define Association Response  code
***********************************************************************/
#define   	ASSOC_ACCEPT 	0
#define     ASSOC_REJECT    1
#define     ASSOC_BUSY	    2

/***********************************************************************
**     Define Idle Timer types    ( each unit is 10 ms )
***********************************************************************/
#define     ASSOC_IDLE      150    /* 1.5 sec. open association timeout */
#define     SNMP_IDLE       18000  /* 3 min. associatin idle timeout */

/***********************************************************************
**     Define SNMP Access control types   
***********************************************************************/
#define     SNMP_ACC_NONE		   1
#define     SNMP_ACC_PSWD		   2
#define     SNMP_ACC_PFX 		   3
#define     SNMP_ACC_COMMUNITY     	   4

/***********************************************************************
**     Define INTERFACE SPEED types   
***********************************************************************/
#define     PCNET2M          2000000
#define     ETHER10M         10000000

/***********************************************************************
**     Define STATUS types   
***********************************************************************/
#define     UP			1
#define     DOWN		2
#define     TESTING	    3


/***********************************************************************
**     Miscellaneous type defines for service routines
***********************************************************************/
#define     IFINDEX        1
#define     DEVICE_HOST    2
#define     TCP_MIL_STD_1778   3
#define     RTO_HI      60000           /*  1 min (in milliseconds)*/
#define     RTO_LO      333             /*  .3 sec (in milliseconds)*/

/***********************************************************************
**    Define values for sys_flag 
***********************************************************************/
#define	SYS_FLAG_IP_CHANGE	1
#define	SYS_FLAG_REBOOT		2
#define	SYS_FLAG_SW_UPDATE	3

extern	char		snmp_get_request_community[];
extern	char		snmp_set_request_community[];
extern	unsigned int	snmp_product_id[];
extern	int		snmp_product_id_count;
extern	OBJ_ID_T	snmp_system_object_id;
extern	OBJ_ID_T	charsessprotocol_id;
extern	char		snmp_system_description[];
extern  unsigned char   sys_flag;
