/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#if (!defined(snmp_inc))
#define snmp_inc

#ifndef	localio_inc
#include "localio.h"
#endif

#if (!defined(asn1_inc))
#include "asn1.h"
#endif

#if (!defined(buffer_inc))
#include "buffer.h"
#endif

/* Define the maximum packet size this implementation will accept.	*/
/* There is no hard upper limit.  SNMP_MAX_PACKET_SIZE should not be	*/
/* reduced below the value of SNMP_MIN_PACKET_SIZE.			*/
/*  #define	SNMP_MAX_PACKET_SIZE		1400   */
#define	SNMP_MAX_PACKET_SIZE	    484	

#define	SNMP_MIN_PACKET_SIZE		484

#define MAXOBJLEN    35 
#define	VERSION_RFC1067			0

/* Define the ports assigned to SNMP for the reception of various types	*/
/* of packets.								*/
#define	SNMP_REQUEST_PORT		161
#define	SNMP_TRAP_PORT			162

/* Define the buffer size and buffer number for OBJECT ID and OCTET STRING */
/*
 *	Kwok Kong	3.4.92
 *	Increase the BUFFER_POOL_SIZE from 2000 to 4000 such that
 *	I can handle 20 objects request.
 */

#define BUFFER_POOL_SIZE 4000 

/* Define the internal shape of a VarBind	*/
typedef 	struct VB_S
{
	struct VB_S  *next;
	ALENGTH_T	vb_seq_size;	  /* Overall length of the VarBind  */
	/* sequence when encoded.	    */
	OBJ_ID_T	vb_obj_id;	  /* Object id for this VarBind	    */
	ALENGTH_T	vb_data_flags_n_type;  /* Class form & type of data */
	ALENGTH_T	vb_data_length;	  /* Length of the data when encode */
	union	{
		INT_32_T	v_number;	/* Integer kinds of things  */
		UINT_32_T	v_counter;	/* Unsigned int things	    */
		EBUFFER_T	v_string;	/* Octetstring things	    */
		OBJ_ID_T	v_object;	/* Object id things	    */
		unsigned char	v_network_address[4];
	} value_u;
}VB_T ;

typedef VB_T  *VB_P;


#define	v_gauge		v_counter
#define	v_timeticks	v_counter
#define	v_opaque	v_string

/* Values for vb_type | vb_flags */
#define	VT_NUMBER	A_INTEGER
#define	VT_STRING	A_OCTETSTRING
#define	VT_OBJECT	A_OBJECTID
#define	VT_EMPTY	A_NULL
#define	VT_IPADDRESS	(A_APPLICATION | 0)
#define	VT_COUNTER	(A_APPLICATION | 1)
#define	VT_GAUGE	(A_APPLICATION | 2)
#define	VT_TIMETICKS	(A_APPLICATION | 3)
#define	VT_OPAQUE	(A_APPLICATION | 4)

/* Define the shape of the VarBindList */
typedef	struct VBL_S
{
	ALENGTH_T	vbl_length;	/* Length of the VarBindList seq */
	int		vbl_count;	/* Number of Var Bind items	 */
	VB_P		vblist;
	VB_P        vblast;  /* last VarBind available in the list */
} VBL_T;

typedef VBL_T  *VBL_P;

/* Define the internal representation of an SNMP packet */
typedef	struct SNMP_PKT_S
{
	ALENGTH_T	buffer_needed;		/* Size of buffer needed   */
	ALENGTH_T	overall_length;		/* Message Sequence length */
	INT_32_T	snmp_version;
	EBUFFER_T	community;
	ATVALUE_T	pdu_type;
	ALENGTH_T	pdu_length;
	union {
		/* For GetRequest, GetNextRequest,	*/
		/* GetResponse, and SetRequest PDUs.	*/
		struct {
			INT_32_T	request_id;
			INT_32_T	error_status;
			INT_32_T	error_index;
			VBL_T	std_vbl;
		} std_pdu;

		/* For Trap PDU	*/
		struct {
			OBJ_ID_T		enterprise_objid;
			unsigned char	net_address[4];
			INT_32_T		generic_trap;
			INT_32_T		specific_trap;
			INT_32_T		trap_time_ticks;
			VBL_T		trap_vbl;
		} trap_pdu;
	} pdu;
} SNMP_PKT_T;


typedef struct snmpgroup{
	long inpktcount;
	long outpktcount;
	long badversion;
	long badcommname;      /* bad community name count */
	long badcommuse;       /* bad community use */
	long badparse;         /* ASN.1 pasing error */
	long badtype;          /* bad PDU type */
	long inreqvar;         /* total get/get-next objects */
	long insetvar;         /* total set objects */
	long ingetreq;         /* total get request */
	long ingetnextreq;     /* total get next request */
	long insetreq;         /* input set request */
	long outtoobig;        /* output too big */
	long outnosuch;        /* output no such PDU */
	long outbadvalue;      /* output bad value packet */
	long outreadonly;      /* output read only PDU */
	long outgenerr;        /* output gen error PDU */
	long outgetresp;       /* output get response PDU */
	long outtraps;         /* output traps */
}SNMPGROUP;


typedef SNMPGROUP  *SNMP_GP_P;
typedef SNMP_PKT_T   *SNMP_PKT_P;

/* Values for pdu_type (class and form bits are not included) */
#define	GET_REQUEST_PDU			0
#define	GET_NEXT_REQUEST_PDU		1
#define	GET_RESPONSE_PDU		2
#define	SET_REQUEST_PDU			3
#define	TRAP_PDU			4
#define	NO_PDU				-1

/* Values for error_status	*/
#define	NO_ERROR		0
#define	TOO_BIG			1
#define	NO_SUCH_NAME		2
#define	BAD_VALUE		3
#define	READ_ONLY		4
#define	GEN_ERR			5

/* Values for generic_trap	*/
#define	COLD_START		0
#define	WARM_START		1
#define	LINK_DOWN		2
#define	LINK_UP			3
#define	AUTH_FAILURE		4
#define	EGP_NEIGHBOR_LOSS	5
#define	ENTERPRISE_SPECIFIC	6
#define GENERIC_MAX             6

#define	SNMP_ERROR_INDEX(I)	(I + 1)

#define	VALID			1
#define	INVALID			2

#define SNMPDISABLED	1
#define SNMPENABLED		2

extern  int	Process_Received_SNMP_Packet(POINTER, int,
unsigned char *, unsigned int,
unsigned char *, unsigned int,
EBUFFER_P );

extern	SNMP_PKT_P 	SNMP_Decode_Packet(POINTER, int, UINT_32_T, UINT_32_T, 
UINT_32_T,UINT_32_T);
extern	VB_P  		VarBindList_Allocate(int);
extern	SNMP_PKT_P 	SNMP_Allocate(int);

extern	unsigned int	SNMP_Bufsize_For_Packet(SNMP_PKT_P );
extern	int		SNMP_Encode_Packet(SNMP_PKT_P , EBUFFER_P );

extern	int		Process_SNMP_Get_PDU(SNMP_PKT_P, SNMP_PKT_P ,
EBUFFER_P , int);

extern	int		Process_SNMP_GetNext_PDU(SNMP_PKT_P , SNMP_PKT_P ,
EBUFFER_P , int);

extern	int		Process_SNMP_Set_PDU(SNMP_PKT_P , EBUFFER_P, int);

extern VB_P Get_VarBin();
extern Free_VarBin(VB_P);
extern SNMP_PKT_P rcv_snmp_pkt;
extern SNMP_PKT_P tx_snmp_pkt;
extern SNMP_PKT_P trap_snmp_pkt;
extern VB_P rcv_vbp;
extern VB_P tx_vbp;
extern VB_P trap_vbp;
extern POINTER tx_rebuffp;
extern POINTER trap_rebuffp;
extern SNMP_GP_P snmp_count;
extern POINTER pdu_typep;
extern POINTER err_statusp;
extern POINTER err_indxp;
extern POINTER alloc_mem();
extern int  Check_Alarm();
extern int  snmp_access();

extern  enable_timer();
extern  disable_timer();
extern  snmp_abort();

/*
 *	K Kong	3.4.93
 *	allocate our own buffer to store the community name.
 */
extern	POINTER	communityName;

#endif	/* snmp_inc */
