/**
 *	Program Name:	nim960 program
 *
 *	Filename:	sncvar.h
 *
 *	$Log:   /b/gregs/i960/include/sncvar.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:44:08   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:22:38   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:22:46   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:42:32   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:38:26   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:28:44   gregs
 * Initial revision.
 * 
 *    Rev 1.2   02 Jul 1992 12:15:28   ramki
 * Change SV_SIZE_LFRM from 5e0 to 1518
 * 
 *    Rev 1.1   16 Apr 1992 15:43:24   pvcs
 * add SV_NMBR_PORT 4
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
/******************************************************************
 * This file contains the structure definitions for
 * the SONIC driver control/status structure.
 *
 * This structure contains all counters, parameters, configuration 
 * variables, local workspace, etc.
 ******************************************************************/

#ifndef __SVAR_H
#define __SVAR_H	0x100a	/* V1.00a */
#include "sonic.h"
#include "pkt.h"


#define SV_NMBR_PORT 4
#define SHRAM        0x50000000       
#define SHRAM_HI        0x5000

/*
 * IMPORTANT SYSTEM SIZE AND LOCATION EQUATES
 */

/* total size of structure */
#define SV_TOTL_SHRM    0x40000  /*256k shared ram total */
#define SV_TOTL_PORT    0x10000  /*64k shared ram per port */
#define SV_TOTL_PBUF	0x08000	/* 32k buffer space per port  */
#define SV_TOTL_POOL	0x01000	/* 4k buffer space per pool  */
#define SV_NMBR_POOL	(SV_TOTL_PBUF/SV_TOTL_POOL)    /* num pools per port */
#define SV_NMBR_SNCP	(2*SV_NMBR_POOL)		/* 2x as many descs. */
#define SV_TOTL_LCTL    0x03000  /* 12k shared ram for SNCT descriptor*/
#define SV_TOTL_LCRL    0x03000  /* 12k shared ram for SNCR descriptor*/
#define SV_TOTL_SNCC    (sizeof(SNCC) * SNC_MAX_CAM)
#define SV_TOTL_SNCP    (sizeof(SNCP) * SV_NMBR_SNCP)
#define SV_TOTL_PCTL	(SV_TOTL_SNCC + SV_TOTL_SNCP + SV_TOTL_LCRL) /*SNCR+SNCC+SNCP */
#define SV_TOTL_LBUF	(SV_TOTL_PORT - SV_TOTL_PBUF - SV_TOTL_LCTL - SV_TOTL_PCTL)
#define SV_TOTL_OVERHEAD (SV_TOTL_PCTL +SV_TOTL_LCTL+SV_TOTL_LBUF)

/* SHRAM starting points */
#define SV_STRT_SHRM	(SHRAM+0x00000)	/* shared ram location  */
/* port structure starting address */
#define SV_STRT_PORT0   (SHRAM+SV_TOTL_PORT*0)
#define SV_STRT_PORT1   (SHRAM+SV_TOTL_PORT*1)
#define SV_STRT_PORT2   (SHRAM+SV_TOTL_PORT*2)
#define SV_STRT_PORT3   (SHRAM+SV_TOTL_PORT*3)
/* local pkt buffer starting address */
#define SV_STRT_DBUF0   (SV_STRT_PORT0 + SV_TOTL_PCTL +SV_TOTL_LCTL)
#define SV_STRT_DBUF1   (SV_STRT_PORT1 + SV_TOTL_PCTL +SV_TOTL_LCTL)
#define SV_STRT_DBUF2   (SV_STRT_PORT2 + SV_TOTL_PCTL +SV_TOTL_LCTL)
#define SV_STRT_DBUF3   (SV_STRT_PORT3 + SV_TOTL_PCTL +SV_TOTL_LCTL)
/* receiving buffer starting address (snct)*/
#define SV_STRT_SNCT0   (SV_STRT_PORT0 + SV_TOTL_PCTL)
#define SV_STRT_SNCT1   (SV_STRT_PORT1 + SV_TOTL_PCTL)
#define SV_STRT_SNCT2   (SV_STRT_PORT2 + SV_TOTL_PCTL)
#define SV_STRT_SNCT3   (SV_STRT_PORT3 + SV_TOTL_PCTL)
/* receiving buffer starting address (sncb)*/
#define SV_STRT_RBUF0   (SV_STRT_PORT0 + SV_TOTL_OVERHEAD)
#define SV_STRT_RBUF1   (SV_STRT_PORT1 + SV_TOTL_OVERHEAD)
#define SV_STRT_RBUF2   (SV_STRT_PORT2 + SV_TOTL_OVERHEAD)
#define SV_STRT_RBUF3   (SV_STRT_PORT3 + SV_TOTL_OVERHEAD)


/* packet size limits  */
#define SV_SIZE_LFRM	1518	/* size of a LOCAL STACK buffer  */
#define SV_SIZE_PBUF	2100	/* max size of a port frame  */

/* some defined counts  */
#define SV_NMBR_PFRM    (SV_TOTL_LCRL/ sizeof(SNCR) )   /* no of RDA */
#define SV_NMBR_SNCT    (SV_TOTL_LCTL/ sizeof(SNCT) )	/* no of TDA */
#define SV_NMBR_LFRM	(SV_TOTL_LBUF/SV_SIZE_LFRM)	/* no. local buffs */

/* some port definition equates */
#define SV_MAX_PORT 	(1 << ((SV_NMBR_PORT) - 1))	
#define SV_END_PORT 	(SV_MAX_PORT<<1)
#define SV_TBL_PORT 	(SV_MAX_PORT+1)
#define SV_VLD_PRTS 	(SV_END_PORT-1)

#define	SV_ALL_PORTS	0x0f
/* 
 * MACROS 
 */
#define INT_DSA Di()	
#define INT_ENA Ei()	
#define LO(x) (shrt) ((word)x)
#define HI(x) (shrt) ((word)(x)>>16)
/*#define SNCADDR(s) (SV_STRT_SHRM+(s)) */
#define SNCADDR(port,s) ( SV_STRT_SHRM + ((port) << 16) + (s))
#define SNC_ENA(port) (EnableSonic(port))
#define SNC_DSA(port) (DisableSonic(port))
#define POOL_INDX(b) (((b)&(SV_TOTL_PBUF-SV_TOTL_POOL)) /SV_TOTL_POOL)



/* 
 * Procedure Declarations
 */
	/* initialization  */
extern snc_config();		/* configure all ports */
extern snc_start();		/* start all ports */
extern snc_stop();		/* stop all ports */
extern snc_reset();		/* reset a specific port */
	/* CAM management  */
extern snc_cam_add();		/* add entry to CAM */
extern snc_cam_sub();		/* remove entry from CAM */
extern snc_cam_rot();		/* rotate in a CAM entry */
extern snc_cam_rst();		/* reinstall all CAM entries */
	/* utilities  */
extern snc_clr_count();		/* clear all event counters */
extern snc_reset_wdt();		/* reset-restart watchdog timers */
extern snc_flush_pkt();		/* flush all xmts & rcvs */
extern snc_flush_cnt();		/* flush all xmts & rcvs */
	/* buffer management  */
extern snc_put_frame();		/* put a snc frame back on rcv list */
	/* transmit and receive  */
extern void snc_transmit();	/* snc frm tx */
extern PKT *snc_receive();	/* get a rcvd snc frm */
	/* self test  */
extern shrt snc_test();		/* test a port */



/* 
 * SONIC CTRL STRUCT ENHANCEMENTS
 *  crammed into the holes of the sonic structures
*/
/* don't use sncr0 sncr1 sncr2 sncr3 sncr4 for receive (will be overwrite ) */
#define sncr_adr sncr2	/* high word of buffer address  */
#define sncr_cnt sncr4  /* forward cnt */
#define sncr_ind sncr_seq  /* emulation rda index */
/*#define sncr_ind sncr0*/  /* emulation rda index */

/* don't use snct0 it will be overwritten by sonic */ 
#define snct_hom snct1	/* home port number  */
#define snct_pri snct2	/* transmit priority  */
#define snct_prt snct3	/* transmit port list  */
#define snct_adr snct4	/* high word of buffer address  */
#define snct_sncr snct5 /* pointer to the sncr */
#define snct_txe snct6	/* transmit error flag */
#define SNCT_SNCR_HOME  0xffff
/*#define SNC_EOL	SNCADDR(SNCR_NXT_EOL) */

/*
 * This structure defines the command/status registers through
 * which the CPU and SONIC communicate.  
 */
typedef struct sonic_variables
	{
	/* resource pointers workspace  */
	SNCR 	*sv_rcvhd; 	/* pending receive descriptor list head  */
	SNCR 	*sv_rcvtl; 	/* pending receive descriptor list tail  */
	SNCT 	*sv_xmthd; 	/* pending transmit descriptor list head  */
	SNCT 	*sv_xmttl; 	/* pending transmit descriptor list tail  */
	SNCP	*sv_plcur; 	/* receive pool circ queue current  */
	SNCP	*sv_plnxt; 	/* receive pool circ queue next free  */
	SNCP	*sv_plend; 	/* receive pool circ queue end + 1  */
	shrt 	sv_plnus[SV_NMBR_POOL];
	word	sv_plind;	/* current pool index  */
	word    sv_freeind;     /* free pool index */
	word    sv_curseq;      /* current sequence number */
	word    sv_txcnt;       /* number of frame xmitted */
	word    sv_rxcnt;       /* number of frame received */
	word    sv_rxqlen;      /* number of frame in receive queue */
	/* CAM information  */
	shrt 	sv_camena;	/* bit map of active cams  */
	byte 	sv_camcnt;	/* number active cam entries  */
	byte 	sv_camnxt;	/* next cam entry to swap  */
	NID 	sv_camlst[SNC_MAX_CAM];		/* table of CAMs  */
	/* memory allocations from shram, first 3 from first 64k only  */
	SNC  	*sv_snc ; 	/* registers descriptor area  */
	SNCC 	*sv_sncc; 	/* cam descriptor area  */
	SNCR 	*sv_sncr; 	/* receive descriptor area  */
	SNCP	*sv_sncp; 	/* rotational receive pool pointer area  */
	byte 	*sv_sncb; 	/* the actual buffer space 	 */
	/* Configuration options  */
	shrt 	sv_rcvwdt;	/* receive lock-up deadman timer value  */
	shrt 	sv_xmtwdt;	/* transmit lock-up deadman timer value  */
	shrt 	sv_lpbkmd;	/* loopback mode  */
	shrt 	sv_rcvmd; 	/* receive mode  */
	shrt	sv_xmtmd; 	/* transmit mode  */
	shrt 	sv_maxsiz;	/* maximum segment size  */
	byte 	sv_rcvind;	/* receive indenting  */
	/* Status information  */
	byte 	sv_status;	/* operational status  */
	shrt 	sv_rdacnt;	/* current number of RDAs  */
	shrt 	sv_rplcnt;	/* current number of receive pools avail  */
	/* deadman counters  */
	shrt 	sv_rcvwdr;	/* rcv lock-up deadman timer rcvd counter  */
	shrt 	sv_rcvwdx;	/* rcv lock-up deadman timer xmtd counter  */
	shrt 	sv_xmtwdc;	/* transmit lock-up deadman timer counter  */
	/* transmit queue workspace  */
	SNCT 	*sv_outhd;	/* low priority xmt queue head  */
	SNCT 	*sv_outtl;	/* low priority xmt queue tail  */
	/* counter fields  for IF */
	word	sv_admin_status;/* 1 = up, 2 = down, 3 = testing */
	word	sv_oper_status; /* 1 = up, 2 = down, 3 = testing */
	word	sv_last_change; /* last if_oper_status change    */
	word 	sv_inb;		/* number bytes came in IF  */
	word 	sv_inu;		/* number unicast frames came in IF  */
	word 	sv_inm;		/* number multicast frames came in IF  */
	word 	sv_in_errors;   /* number of packets received with errors */
	word 	sv_in_unknown_proto; /* nuberof packet received with unknown protocol */
	word 	sv_outb;	/* number bytes sent out IF  */
	word 	sv_outu;	/* number unicast frames sent out IF  */
	word 	sv_outm;	/* number multicast frames sent out IF  */
	word	sv_out_discards;/* number of outgoing packets discard */
	word	sv_out_errors;  /* number of outgoing packets with error */
	word    sv_txqlen;      /* number of frame in xmitted queue */
	word	sv_specific;  	/* interface document specific */
	/* counters field for DOT3 */
	word    sv_init;        /* 1=initialsize , 2 uninitialize */
	word    sv_multi;       /* 1=enable , 2 disable */
	word    sv_txen;        /* 1=enable , 2 disable */
	word 	sv_aln;		/* number alignment errors  */
	word 	sv_crc;		/* number crc errors  */
	word    sv_tx_scol;     /* tx error: single collison */
	word    sv_tx_mcol;     /* tx error: multiple collison */
	word    sv_tx_def;      /* tx error: defered xmit */
	word    sv_tx_owc;      /* tx error: out of window collision */
	word	sv_tx_exc;	/* tx fail: excessive collisions */
	word 	sv_txfail;	/* number transmit failures */
	word    sv_tx_crs;      /* tx error: no crs or crs lost */
	word	sv_tx_exd;	/* tx fail: excessive deferals */
	word 	sv_txbcnt;	/* number byte count mismatches */
	word 	sv_rxfifo;	/* number rx fifo overruns */
	/* counters other */
	word    sv_rxen;        /* 1=enable , 2 disable */
	word	sv_tx_fu;	/* tx fail: excessive fifo underruns */
	word	sv_tx_bcm;	/* tx fail: excessive bad crc monitored */
	word 	sv_txxdef;	/* number excessive deferals */
	word 	sv_clsn;	/* number collisions  */
	word 	sv_lst;		/* number lost packets  */
	word 	sv_rcvlk;	/* number receive lock-ups  */
	word 	sv_xmtlk;	/* number transmit lock-ups  */
	word 	sv_tstrpt;	/* number self test report  */
	/* utilization histogram fields  */
	/*word 	sv_utlactv;
	word 	sv_utlsmpl;
	long 	sv_utlhist[11]; */
	word    sv_dummy;       /* reserve */
	SNCT    *sv_txlockhd;   /* transmit lock head if cr=2*/
	word    sv_txlockcnt;   /* transmit lock cnt */
	SNCR    *sv_rxlockhd;   /* receive lockup head (no resource) */
	word    sv_rxlockcnt;   /* receive lockup cnt */
	word    sv_rxlocknorsrc;/* receive lockup no resource cnt */
	} SV;


/* this 64 bytes structure we used to store in the 960 DATA RAM */ 
typedef struct sonic_dataram_variables
	{
	SNCR	*sv_rcvhd;
	SNCR 	*sv_rcvtl;
	SNCT 	*sv_xmthd;
	SNCT 	*sv_xmttl;
	SNC	*sv_snc;	
	word	sv_txcnt;
	word 	sv_rxcnt;
	word	sv_txqlen;
	word	sv_rxqlen;
	word	sv_plind;
	shrt    sv_freeind;
	shrt	sv_curseq;
	shrt	sv_plnus[SV_NMBR_POOL];  /* 8 buffer pool */
#ifdef sammy
	word 	sv_outb;
	word	sv_inb;
#endif
	SV      *sv_var_loc;             /*SV structure location */
	}SDV;
/*
 * This structure defines all variables used by the channel driver
 * except the port specific variables
 */
typedef struct sv_other
	{
	SV   *so_var_loc[SV_TBL_PORT];	/* table of SV pointers */
	byte *so_lcl_buff[SV_NMBR_PORT];/* buffers for local stack use  */
	SNCT *so_lcl_snct[SV_NMBR_PORT];/* location of TDA allocated memory  */
	PKT  *so_lcl_hd[SV_NMBR_PORT];	/* head of local free PKT list  */
	PKT  *so_lcl_tl[SV_NMBR_PORT];	/* tail of local free PKT list  */
	word  so_lcl_cr[SV_NMBR_PORT];	/* current number of buffers avail  */
	word  so_lcl_mx;		/* maximum number of buffers avail  */
	word  so_lcl_rcv;		/* number local frames received */
	word  so_lcl_xmt;		/* number local frames sent */
	word  so_lcl_lst;		/* number local frames lost at rcvr */
	word  so_prt_ena;		/* sonic enable bits  */
	int  (*so_rcv_upc)();		/* received packet upcall routine  */
	SNCR *so_rcv_hd; 	 	/* received descriptor list head  */
	SNCR *so_rcv_tl;  		/* received descriptor list tail  */
	PKT  *so_glb_hd[SV_NMBR_PORT];  /* head of queueing global PKT list */
	PKT  *so_glb_tl[SV_NMBR_PORT];  /* tail of queueing global PKT list */
	} SO;

/* sv_lpbkmd values  */
#define SV_LPBK_NONE	SNC_RCR_LB_NONE	/* normal mode  */
#define SV_LPBK_MAC 	SNC_RCR_LB_MAC	/* MAC loopback  */
#define SV_LPBK_ENDC	SNC_RCR_LB_ENDC	/* ENDEC loopback  */
#define SV_LPBK_XCVR	SNC_RCR_LB_XCVR	/* transceiver loopback  */

/* sv_rcvmd values  */
#define SV_RCVMD_ERR 	 SNC_RCR_ERR 	/* accept packet with errors  */
#define SV_RCVMD_RNT 	 SNC_RCR_RNT 	/* accept runt packets  */
#define SV_RCVMD_BRD 	 SNC_RCR_BRD 	/* accept broadcast packets  */
#define SV_RCVMD_PRO 	 SNC_RCR_PRO 	/* accept all packets (promiscuous)  */
#define SV_RCVMD_AMC 	 SNC_RCR_AMC 	/* accept all multicast packets  */
#define SV_RCVMD_IND	 0		/* accept individ pkts only */

/* sv_xmtmd values  */
#define SV_XMTMD_CRCI 	 SNC_TCR_CRCI	/* inhibit CRC  */
#define SV_XMTMD_EXDIS	 SNC_TCR_EXDIS	/* disable excessv deferal tmr  */

/* sv_status bit fields  */
#define SV_STATUS_ACTIVE	0x1	/* actively running  */
#define SV_STATUS_CAMREQ	0x2	/* CAM update request pending */


/* 
 * VARIABLES 
 */
extern SV   *sv_vars;
extern SV   sv_var[];
extern SO   *sv_so;
extern SDV  *sv_sdvs;



/* 
 * DRIVER SERVICE PARAMETER EQUATES
 */

/* driver error codes  */
#define SV_OK       0x00	/* no error return value  */
#define SV_ERR_NVLD	0x01	/* invalid parameter or state  */
#define SV_ERR_BAD	0x02	/* something went wrong */

/* transmit parameters  */
#define SV_XMT_PRI_HI	0
#define SV_XMT_PRI_LO	1

#define	SV_XMT_PORT_1	1
#define	SV_XMT_PORT_2	2
#define	SV_XMT_PORT_3	4
#define	SV_XMT_PORT_4	8

/* auxiliary ports */
#define	SV_LCL_PORT	0x40	/* indicates the local stack 'port' */
#define	SV_HSL_PORT	0x80	/* indicates the high speed lan 'port' */

/* self test options  */
#define SV_TEST_INTERNAL 0
#define SV_TEST_EXTERNAL 1

/* self test error codes  */
#define SV_TEST_FAIL_AOK 	0	/* test passed  */
#define SV_TEST_FAIL_NOSNC	SV_ERR_NVLD	/* no sonic present */
#define SV_TEST_FAIL_BADSNC	SV_ERR_BAD	/* bad sonic present */
#define SV_TEST_FAIL_NOBUF	0x3	/* no tx buffer avail  */
#define SV_TEST_FAIL_ABORT	0x4	/* test aborted  */

/* RDA index mask */
#define RDA_RBA_SEQ_MASK        0xff00 /* RBA sequence # mask */
#define RDA_PACKET_SEQ_MASK     0x00ff /* PACKET sequence # mask */
#define RDA_POOL_MASK           0x0007 /* mask for RRA pools */
#define RDA_POOL_SEQ_MASK	0x07ff /* mask for pli and sequence */

/* for SNMP purpose */
#define SNC_INIT           1
#define SNC_UNINIT         2
#define SNC_RECV_ENA       1
#define SNC_RECV_DISENA    2
#define SNC_XMIT_ENA       1
#define SNC_XMIT_DISENA    2

/* for static ram sonic RDA */
#define LEMU_RDA_SIZE      64
#define SEMU_RDA_SIZE      0x600

typedef struct{
  byte sncr_cnt;
  byte sncr_hom;
  byte sncr_pli;
  byte sncr_notused;
}SEMU;


typedef struct chnl_counters
{
  word     chnl_txcnt;                  /* number of transmit count */
  word     chnl_txqlen;                 /* number of frame in xmit queue */
  word     chnl_rxcnt;                  /* number of receive count */
  word     chnl_rxqlen;                 /* number of frame in receive queue */
  word     chnl_outb;                   /* number of bytes send out IF */
  word     chnl_outu;                   /* number of unicast frame send out */
  word     chnl_outm;                   /* number of multicast frame send out*/
  word     chnl_inb;                    /* number of bytes receive IF */
  word     chnl_inu;                    /* number of unicast frame receive */
  word     chnl_inm;                    /* number of multicast frame receive */
  word     chnl_txfail;                 /* number of transmit failures */
  word     chnl_tx_exc;                 /* tx fail exessive collison */
  word     chnl_tx_exd;                 /* tx fail exessive deferals */
  word     chnl_tx_fu;                  /* tx fail fifo underrun */
  word     chnl_tx_bcm;                 /* tx fail byte count mismatch */
  word     chnl_tx_clsn;                /* tx error collison */
  word     chnl_tx_def;                 /* tx error defered xmit */
  word     chnl_tx_owc;                 /* tx error out of window collision */
  word     chnl_tx_crs;                 /* tx error no crs or crs lost */
  word     chnl_rx_crc;                 /* rx crc error */
  word     chnl_rx_aln;                 /* rx align error */
  word     chnl_rx_lst;                 /* rx lost packets(no resource error */
  word     chnl_reserve1;
  word     chnl_reserve2;
}CHNLCNT;

/* for initmalloc() routine */
#define MALLOC_DRAM_SIZE	0x4000

#endif
