/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#if (!defined(mib_inc))
#define mib_inc

#if (!defined(asn1_inc))
#include "asn1.h"
#endif

#if (!defined(snmp_inc))
#include "snmp.h"
#endif

/* Definitions for "form" parameter to the "testproc" found in leaf nodes */
#define	TEST_GET	0
#define	TEST_SET	1

/* Definitions for node_type in MIBNODE_T and MIBLEAF_T */
#define	INNER_NODE	0x80

/* Define a MIB leaf node */
typedef	struct	MIBLEAF_S
{
	OCTET_T		expected_tag;	/* VT_xxx from snmp.h		    */
	OCTET_T		access_type;	/* See below			    */
	unsigned short windx;       /* cmd index to write privilege */
	int		( *svcproc)();	/* Routine to get,set, getnext     */
} MIBLEAF_T;

typedef MIBLEAF_T  *MIBLEAF_P;

/* Bit values for access_type */
#define	READ_ACCESS	0x01
#define	WRITE_ACCESS	0x02
#define	RO	READ_ACCESS			/* READ ONLY ACCESS	*/
#define	WO	WRITE_ACCESS			/* WRITE ONLY ACCESS	*/
#define	RW	(READ_ACCESS | WRITE_ACCESS)	/* READ/WRITE ACCESS	*/

/* Define a pointer from a node to subsidiary node or a leaf	*/
/* These structures are aggregated into an array.		*/
/* THE LAST ELEMENT IN SUCH AN ARRAY MUST HAVE A NULL POINTER.	*/
typedef	struct	MIBARC_S
{
	unsigned int	id;		/* Object identifier component	*/
	struct  MIBARC_S  *nodep;	/* The descendent node/leaf	*/
} MIBARC_T;
typedef MIBARC_T  *MIBARC_P;

/* Define an MIB internal (or root) node */
typedef	struct	MIBNODE_S
{
	int		node_type;	/* See above			    */
	MIBARC_P arcs;		/* Descendents from this node	    */
} MIBNODE_T;

typedef MIBNODE_T  *MIBNODE_P;

#define	ISO		1	/* Level 0 - ISO *IS* #1 by fiat (!!)	*/
#define	CCITT		2	/* Level 0				*/
#define	JOINT_ISO_CCITT	3	/* Level 0				*/
#define	ORG		3	/* Level 1 - {ISO 3}			*/
#define	DOD		6	/* Level 2 - {ORG 6}			*/
#define	INTERNET	1	/* Level 3 - {DOD 1}			*/


#define	DIRECTORY	1	/* Level 4 - {INTERNET 1}		*/
#define	MGMT		2	/* Level 4 - {INTERNET 2}		*/
#define	MIB1		1	/* Level 5 - {MGMT 1}			*/
#define	SYSTEM		1	/* Level 6 - {MIB 1}			*/
#define	INTERFACES      2	/* Level 6 - {MIB 2}			*/
#define	AT		3	/* Level 6 - {MIB 3}			*/
#define	IPTBL		4	/* Level 6 - {MIB 4}			*/
#define	ICMP		5	/* Level 6 - {MIB 5}			*/
#define	TCP		6	/* Level 6 - {MIB 6}			*/
#define	UDP		7	/* Level 6 - {MIB 7}			*/
#define	EGP		8	/* Level 6 - {MIB 8}			*/
/******** #define SNMP	11  /* mib-2 11 */

#define	EXPERIMENTAL	3	/* Level 4 - {INTERNET 3}		*/
#define	IETF		1	/* Level 5 - {EXPERIMENTAL 1}		*/ 
#define	PRIVATE		4	/* Level 4 - {INTERNET 4}		*/
#define	ENTERPRISE	1	/* Level 5 - {PRIVATE 1}		*/
#define SYTEK      26   /* Level 6 - {ENTERPRISE 26} */

#define TERMINALSERVER 1 /* LEVEL 7 - {SYTEK 1} */
#define BRIDGE       2   /* LEVEL 7 - {SYTEK 2} */
#define SYSACCESS    6   /* LEVEL 7 - {SYTEK 6} */
#define ASSOCREQUEST 8   /* LEVLE 7 - {SYTEK 8} */
#define SECURITYRESPONSE  9 /* LEVLE 7 - {SYTEK 9} */
#define ASSOCABORT   10  /* LEVLE 7 - {SYTEK 10} */
#define MYMANAGER    13  /* LEVLE 7 - {SYTEK 13} */
#define MANAGERLOGIN 15  /* LEVLE 7 - {SYTEK 15} */
#define HLSTSPLUS    22  /* LEVEL 7 - {SYTEK 22} */
#define HLSTRAP      23  /* LEVEL 7 - {SYTEK 23} */
#define ARC(ID,NODE)		{ID, (MIBARC_P )&NODE}
#define END_OF_ARC_LIST		{0, (MIBARC_P )0}
#define NODE(ARCLIST)	{INNER_NODE, ARCLIST}
#define NULLPROC		(int (*)())0

#define	LEAF( VT, ACCESS, WINDX,SVCP)	\
				{VT, ACCESS,WINDX,SVCP }


typedef	struct	MIBLOC_S
{
	unsigned int		ml_flags;
	unsigned int		ml_last_match;
	OBJ_ID_T		ml_remaining_objid;
	union {
		MIBLEAF_P		mlleaf_u;
		MIBNODE_P		mlnode_u;
	} mbl_u;
} MIBLOC_T;

typedef MIBLOC_T  *MIBLOC_P;
#define	ml_leaf		mbl_u.mlleaf_u
#define	ml_node		mbl_u.mlnode_u

/* Values for ml_flags */
#define	ML_IS_LEAF	0x01

extern	MIBNODE_T	 mib_root;

extern	int		find_object_node(OBJ_ID_T  *, MIBLOC_T * );
extern	int		find_next_object( VB_P, int);

#endif	/* mib_inc */
