/****************************************************************/
/*								*/
/*	KRNL DECLARATIONS					*/
/*	COPYRIGHT (C) 1985/1986 by SYTEK Inc.   (unpublished)	*/
/*	** ALL RIGHTS RESERVED **				*/
/*								*/
/****************************************************************/

#ifndef __KRNL_H
#define __KRNL_H

#ifndef TYPES
#include "types.h"
#endif

#define TCB_MARKER 0x62616261
#define SEM_MARKER 0x64636463
#define MSG_MARKER 0x66656665
#define TMR_MARKER 0x68676867
#define MBX_MARKER 0x6A696A69

#define STK_MARKER 0x5aa55aa5

#define MaskAllInts(saveMask) \
        asm volatile ("mov sf1, %0" : "=b" (saveMask)); \
        asm volatile ("mov g14, sf1");
 
#define RestoreIntMask(saveMask) \
        asm volatile ("mov %0, sf1" : : "b" (saveMask));



/*
 * KENREL INFORMATION 
 */

typedef struct tcb {
	struct tcb *tc_flink;   /* forward link (when impaled on semaphores) */
	word tc_marker;		/* tcb marker */
	word tc_state; 		/* tcb state */
	word tc_mode;		/* tcb mode, 0 - user mode, 1,2.. krnl mode */
	char *tc_pfp;		/* previous frame pointer save area */
	char *tc_stk_marker_ptr;/* pointer to stack marker(stack end - 4) */
	char *tc_ip;		/* start address of this task for debugging */
	word tc_g0;		/* for storing arg for CreatTask */
	word tc_960reg[4];	/* for storing g8 to g11 regs */
	char *tc_mbox;		/* pointer to mbox this tcb is blocked on */
} TCB;

#define USER_MODE	0
#define KRNL_MODE	1

#define TCB_NOTINUSE	0	/* tcb not in use state */
#define	TCB_READY	1	/* task in ready to run state */
#define	TCB_BLOCKED	2	/* task in waiting for message state */
#define TCB_RUNNING	3	/* task in running state */


typedef struct semaphore {
	char *sm_tflink;	/* task forward link */
	word sm_marker;		/* semaphore marker */
	word sm_count;		/* >0 => number signals here, <0 => -number tasks */
} SEM;

typedef struct mailbox {
	char *mb_tflink;        /* task forward link */
	word mb_marker;		/* mailbox marker */
	word mb_count;          /* >0=number messages here,<0-number tasks */
	char *mb_mflink;        /* message forward link */
	char *mb_mblink;        /* message backward link */
} MBOX;

typedef struct msghdr {       /* header of mail message */
	struct msghdr *mh_link; /* forward link */
	word mh_marker;	/* message marker */
} MSGHDR;


typedef struct timer {
	struct timer *tm_flink; /* forward link */
	word tm_marker;	/* timer marker */
	word tm_state;        /* state of timer(running, stopped, expired) */
	MBOX *tm_mbox;          /* mailbox to mail this timer on expiration */
	word tm_delay;          /* ticks til expiration(from preceding timer) */
	void  (*tm_subr)();	/* subroutine to call on timeout */
	int tm_arg;     	/* arg to pass to subr */
} TIMER;

#define	TM_IDLE		0	/* timer idle flag */
#define	TM_RUNNING	1	/* timer running flag */
#define	TM_EXPIRED	2	/* timer expired flag */

typedef struct frame {
	word  f_pfp;
	word  f_sp;
	word  f_rip;
} FRM;

/* variables in krnl_area */
typedef struct krnl_area
{
	TCB *krnl_run_task;
	TCB *krnl_rdy_head;
	TCB *krnl_tcb_ptr;
	word krnl_max_tcb;

	word krnl_swap_maxcnt;
	word krnl_swap_cnt;

	MBOX krnl_tmr_list;
	MBOX krnl_TmrMbox;
	word krnl_ticks;

	word krnl_flk_req;
	word krnl_flk_cnt;
	word krnl_flk_cur;
	int  krnl_slice_time;
} KRNL;

extern KRNL krnl;


extern StartKernel(void (*subr)(), word *stack_ofst, int  stack_len, int max_tasks, int slice_time);
extern TCB *CreatTask(void (*subr)(), word *stack_ofst, int  stack_len, int arg);
extern ReSchedule();
extern CreatMailbox(MBOX *mbox);
extern CreatMessage(MSGHDR *msg);
extern SendMessage(MSGHDR *msg, MBOX  *mbox);
extern MSGHDR *RcvMessage(MBOX *mbox);
extern MSGHDR *AcptMessage(MBOX *mbox);
extern MSGHDR *RmvMessage(MSGHDR *msg, MBOX *mbox);
extern CreatSemaphore(SEM *sem, int);
extern SendSignal(SEM  *sem);
extern RcvSignal(SEM  *sem);
extern AcptSignal(SEM  *sem);
extern CreatTimer(TIMER *timer);
extern StartTimer(TIMER *timer, int ticks, MBOX *t_o_mbox);
extern MSGHDR *StopTimer(TIMER *timer);
extern StartTimerCall(TIMER *timer, int	ticks, void (*subr)(), int arg);
extern Enqueue(MSGHDR *msg, MBOX *mbox);
extern MSGHDR *Dequeue(MBOX *mbox);
extern Remove(TCB *tcb, MBOX *mbox);
extern enq_mb_msg(MSGHDR *msg, MBOX *mbox);
extern MSGHDR *deq_mb_msg(MBOX *mbox);
extern MSGHDR *RMV_MB_MSG(MSGHDR *msg, MBOX *mbox);
extern insert_rdy_task(TCB *tcb);
extern TCB *desert_run_task();
extern remove_rdy_task(TCB *tcb);
extern TimeTicks();
extern TimeSlice();
extern enqueue(MSGHDR *msg, MBOX *mbox);
extern MSGHDR *dequeue(MBOX *mbox);
extern TCB *CurrentTask();
extern RealTimeTicks();

#endif
