/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/
/*
 *	Kwok Kong	2.8.91
 *	replaced all unsigned, word, unsword with ushort for i960
 */
#ifndef	__IP_H
#define	__IP_H

union _ipname
	{
	ulong	in_lname;
	struct
		{
		byte in_net;
		byte in_nets;
		byte in_netss;
		byte in_host;
		} in_lst;
	};

struct ip
	{
	/*
 	 * 	K Kong, 8.22.91
	 *	cannot use bit field as the 960 will read an int (4 bytes)
	 *	from memory, shift left 28, shift right 24 to get the
	 *	ip_ver.  This will cause a fault as "ip_ver" is not
	 *	aligned on a 4 bytes boundry.
	 */
	/*************
	byte	ip_ihl:4;
	byte	ip_ver:4;
	******/
	byte	ip_ver_ihl; 	/* version and header length in 32 bit words */
	byte	ip_tsrv;	/* Type of service */
	ushort	ip_len;		/* Total packet length including header */
	ushort	ip_id;		/* ID for fragmentation */
	/*
 	 *	K Kong	8.22.91, see ip_ver above.
	 */
	/******
	ushort	ip_foff: 13;
	ushort	ip_flgs: 3;
	**************/
	ushort	ip_flgs_foff;	/* flags and Fragment offset */
	byte	ip_time;	/* Time to live (secs) */
	byte	ip_prot;	/* protocol */
	ushort	ip_chksum;	/* Header checksum */
	in_name ip_src;		/* Source name */
	in_name ip_dest;	/* Destination name */
	};

/* Internet connection information */
struct ip_iob
	{
	uint	c_prot;		/* protocol */
	int	(*c_handle)();	/* upcalling packet handler */
	int	c_fd;		/* file descriptor */
	};

typedef union ip_Addr {
	in_name ip_adr;
	u_char	ip[4];
	} AIP;

typedef struct ip_iob *IPCONN;	/* The IP connection type */

/* Some useful definitions */
#define INETLEN	576		/* maximum size of internet packet (bytes) */
/** for 960 alignment, sizeof (struct ip) = 32 rather than 20
#define IPHSIZ	sizeof(struct ip)
***//* internet header size */
#define IPHSIZ	20 /* internet header size */
#define IP_VER	4		/* internet version */
#define IP_IHL	5		/* IN header length in longwords */
#define IP_TSRV	0		/* default type of service */
#define IP_ID	0		/* kernel fills in IN id */
#define IP_FLGS	0		/* no fragmentation yet */
#define	IP_FOFF	0		/* " " " */
#define IP_MF	1		/* The "More Fragments" flag bit */
#define IP_DF	2		/* The "Don't Fragment" flag bit */
#define	IP_TIME	255		/* maximum time to live */
#define IPXSUM	0		/* initial checksum */
#define	IPLEN	IPHSIZ	/* internet header length */

/* Some goodly macros */

#define in_head(ppkt)	((struct ip *)(ppkt)->nb_prot)
#define in_data(pip)	((char *)(pip) + (GetIpHeaderLength(pip) << 2))
#define in_options(pip)	((char *)(pip) + (IP_IHL << 2))
#define in_optlen(pip)	(((pip)->ip_ihl - IP_IHL) << 2)


#define min(x,y)	((x) < (y) ? (x) : (y))
#define max(x,y)	((x) > (y) ? (x) : (y))

/* some externals for internet et al */
extern PACKET in_alloc(int, int);
extern in_free(PACKET);
extern IPCONN in_open(unsigned, int (*)());
extern in_write(IPCONN, PACKET, int, in_name, in_name, NID *, in_name *);
extern inroute(in_name, in_name, in_name *);
extern in_name in_mymach(in_name,in_name);
extern icmp_destun(in_name, in_name, struct ip *, unsigned);



#endif
