/*
 * FRAG.H - Definitions related to IP fragment reassembly.
 *
 * Copyright (C) 1987 by FTP Software, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by FTP Software, Inc.
 *
 * Edit History
 * 27-Jul-87	jbvb	Put into use, although we aren't using Philip's
 *			 fancy, multi-fragment approach.
 * 03-Aug-87	jbvb	Changed fragment timeout to 4 seconds, based on
 *			 HGM's experience with high incoming loss rates.
 */
#ifndef	__FRAG_H
#define	__FRAG_H

struct frag {
	struct frag	*fr_link;
	PACKET		fr_pkt;
	TIMER		*fr_tmr;
	long		fr_hole;
	uint		fr_len;
};

#define	FIRST_FRAG(x)	(GetIpFragmentOffset((x)) == 0)
#define	LAST_FRAG(x)	((GetIpFlags((x)) & IP_MF) == 0)
#define	DONT_FRAG(x)	((GetIpFlags((x)) & IP_DF) != 0)

#define	getfrag()	((struct frag *) malloc(sizeof(struct frag)))
#define	putfrag(x)	free(x)

#define	FRAGCHNK	8
#define	FRAGEND		(~0)
#define	FRAGTIME	4

/*
 *	Status for fragmentation
 */
struct infrag_stat
	{
	ulong	reasmtmo;
	ulong	reasmreq;
	ulong	reasmok;
	ulong	reasmfail;
	};
typedef struct infrag_stat	INFRAG_STAT;
extern INFRAG_STAT	InfragStat;
	
#define	ip_reasmtmo	InfragStat.reasmtmo
#define	ip_reasmreq	InfragStat.reasmreq
#define	ip_reasmok	InfragStat.reasmok
#define	ip_reasmfail	InfragStat.reasmfail


#endif
