/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/

/*  Copyright 1983, 1985 by the Massachusetts Institute of Technology  */
/*
 *	Kwok Kong	2.8.91
 *	replaced all unsigned, word, unsword with ushort for i960
 */

/* information common to all ethernet drivers
*/
#ifndef	__ETHER_H
#define	__ETHER_H

/* initialization modes: 0 = rcv normal + broadcast packets */
#define	LOOPBACK	0x01	/* send packets in loopback mode */
#define	ALLPACK		0x02	/* receive all packets: promiscuous */
#define	MULTI		0x04	/* receive multicast packets */

/* ethernet packet header */
struct ethhdr
	{
	ushort	e_dst[3];
	ushort	e_src[3];
	ushort	e_type;
	};
/*
 *	Do not use sizeof (struct ethhdr) to get the size as 
 *	the 960 C compiler may add padding in the structure
 */
#define ETHRSIZ		14 

/* ethernet packet types: not all are used.   Already byte swappeed */
#define	ET_IP		0x0008	/* really 0x0800 */
#define	ET_ARP		0x0608	/* really 0x0806 */
#define	ET_CHAOS	0x0408	/* really 0x0804 */
#define	ET_TRAILER0	0x0010	/* really 0x1000 */
#define	ET_TRAILER1	0x0110	/* really 0x1001 */
#define	ET_TRAILER2	0x0210	/* really 0x1002 */

/* IEE packet header */
struct ieeehdr
	{
	ushort	i_dst[3];
	ushort	i_src[3];
	ushort	i_size;
	ushort	i_snp0;
	byte	i_snp2;
	byte	i_dod0;
	ushort	i_dod1;
	ushort	i_type;
	};
/*
 *	The unpadded size of struct ieeehdr
 */
#define IEEESIZ		22 
/* special values for SNAP */
#define IEEESNP0  0xaaaa
#define IEEESNP2  0x03
#define IEEEDOD0  0x00
#define IEEEDOD1  0x0000



#define	ET_MINLEN	60 /* minimum length legal ethernet packet */
#define MAXLNH IEEESIZ

extern u_short ETBROADCAST[];

#endif
