#include <types.h>
#include <krnl.h>
#include <defines.h>
#include <uart.h>
#include <memory.h>
#include "scc_buff.h"
#include "scc_defs.h"

extern word ram_control_table[];
extern word ram_int_table[];

extern byte get_xmt_line();
extern SccInt();
extern int TxByteCount;
extern byte *TxDMASrcPtr;
extern byte *RxDMADstPtr;
extern byte *rcv_dma_ptr;
extern byte *last_dma_ptr;
extern SCC_BD_QUEUE scc_bd_q;
extern SCC_BD scc_bd[];
int NoOfTx;
extern int TxByteCount;
extern int fault_cnt;

int scc_in_xmt =0;
int scc_in_rcv =0;
int scc_rcv_count =0;
int scc_frame_count =0;
int rcv_buff_wrapped = 0;
int rcv_overrun_error = 0;
int rcv_buff_gap = 0;
int backplane_p2_missing = 0;

/*
* for debug
*/
int	d_scc_xmt_done = 0;
int	d_scc_xmt_req = 0;
int d_scc_0_miss = 0;
int d_scc_1_miss = 0;
int d_scc_2_miss = 0;
int d_scc_no_coll = 0;
int d_scc_coll = 0;
int d_scc_dcd = 0;

SCC_INFO SccInfo;

static TIMER SccTimer;
MBOX	SccRcvMbox;
MBOX	SccFreeMbox;

static TIMER ReXmtTimer;

void scc_send();


volatile struct SCCport *scc_port_b = (struct SCCport *)SCC_PORTB;
volatile struct SCCport *scc_port_a = (struct SCCport *)SCC_PORTA;
volatile DMA_INFO *rx_chnl_dma = ( DMA_INFO *) DMA_CHANNEL_0; 
volatile byte *led_status = (byte *)0x80000034;

unsigned int 	scc_collision=0;

/*--------------------------------------------------------------------------
 * init_scc_info()
 * 	Initialize the scc statistics counters.
 *--------------------------------------------------------------------------
 */
init_scc_info()
{
	SccInfo.xmt_byte_count		= 0;
	SccInfo.xmt_collisions		= 0;
	SccInfo.xmt_no_bd_error		= 0;
	SccInfo.rcv_byte_count		= 0;
	SccInfo.rcv_crc_error		= 0;
	SccInfo.rcv_residue_error	= 0;
	SccInfo.rcv_overrun_error	= 0;
	SccInfo.rcv_status_fifo_overrun	= 0;
	SccInfo.rcv_no_bd_error		= 0;
}


/*--------------------------------------------------------------------------
 * SccInt_c()
 * 	ISR for INT 2 (scc interrupt). Handles scc external status interrupt
 *	for transmit end of frame. Turns off the transmitter and enables 
 *	receiver.
 *--------------------------------------------------------------------------
 */
SccInt_c()
{

byte dummy, rr0, vec_intr;
	int i, prevalue;

	dummy = *(volatile byte *)0x900000c0;

	/*---------------------------------------- 
	 * Read R2 of port B to find out INT type.
	 *---------------------------------------- 
	 */
        prevalue = crit_on();
/*	Di(); */
	scc_port_b->control = RR2;
	vec_intr = scc_port_b->control;

	/*---------------------------------------- 
	 * Check for external status int.
	 *---------------------------------------- 
	 */
	if ( (vec_intr & 0x0e) == 0x0a )
	{
		scc_port_a->control = 0x10;
		scc_port_a->control = 0x10;
		rr0 = scc_port_a->control;

		if ( rr0 & TX_EOM )
		{
			/*------------------------
			 * Disable Tx_EOM Int and
			 * keep status FIFO enabled. 
			 *------------------------
			 */
			scc_port_a->control = WR15;
			scc_port_a->control = 0x04;	
			for (i=0; i< 5; i++)
				dummy = scc_port_a->control;

			/*---------------------------------------- 
			 * Disable REQ_FUNC on TxBE
		 	 *---------------------------------------- 
		 	 */
			scc_port_a->control = WR14;
			scc_port_a->control = 0x00;

			/*-------------------
			 * Disable Tx
			 *-------------------
			 */
			scc_port_a->control = WR5;
			scc_port_a->control = 0x60; 

			/*-------------------
			 * Enable Rx DMA Req 
			 *-------------------
			 */
                        scc_port_a->control = WR1;
			scc_port_a->control = DMA_REQ_ENB|DMA_REQ_FUNC|								DMA_REQ_RCV;
                        /*-------------------
                         * Enable Rx
                         *-------------------
                         */
                        scc_port_a->control = WR3;
                        scc_port_a->control = RX_8BIT | HUNT_MODE |
                                              RX_CRC | SRCH_MODE | RX_ENABLE;
 
			scc_in_xmt =0;
			d_scc_xmt_done++;
		}
	}
	scc_port_a->control = 0x38; /* clr int */
        crit_off(prevalue);
/*	Ei(); */
}


/*--------------------------------------------------------------------------
 * scc_init_chnl_a()
 * Performs the following:-
 *      initialize 85C30 SCC channel a for sdlc address search mode,
 *      install the interrupt handler (vector 50),
 *      set up the receive DMA,
 *	initialize the buffer descriptors,
 *	create the SccRcvMbox for brip_rcv_task().
 *--------------------------------------------------------------------------
 */
scc_init_chnl_a()
{
int i, j, prevalue;
static unsigned char SccCmdData[]=
{
        0x09,   0x89,   /* reset channel A, MIE, STATUS LOW, VIS	*/
        0x01,   0x00,   /* interrupts all off                           */
        0x02,   0x00,   /* vector 0	                          	*/
        0x04,   0x20,   /* 1 clk, SDLC mode, SYNC mode enable, no parity*/
        0x0a,   0x80,   /* CRC preset to 1, NRZ, flag, 8 bit SYNC       */
        0x07,   0x7e,   /* flag 01111110                                */
        0x06,   0x00,   /* sdlc address 2                               */
        0x0b,   0x08,   /* external clock                               */
        0x0e,   0x00,   /* null cmd, DTR follows WR5, baud from RTxC    */
        0x0f,   0x04,   /* ext int sources disabled, status FIFO enable	*/
        0x0c,   0x00,   /* timer constants not used, baud generator is  */
        0x0d,   0x00,   /* disabled                                     */
        0x03,   0xcc,   /* Rx 8 bit, Rx CRC enable, addr search mode    */
        0x05,   0x60,   /* Tx 8 bit, tx disabled                        */
        0x00,   0x30,
                0xc0,
                0x10,
                0x10 
};


		  

        /*----------------------------------------
         * Install the SCC interrupt handler (INT2)
         * at vector 50.
         *----------------------------------------
         */
	init_hw_int(2, 50, (char *) SccInt );

        /*----------------------------------------
         * Initialize SCC according to SccCmdData.
         *----------------------------------------
         */

	SccCmdData[13] = get_xmt_line();

        prevalue = crit_on();
/*	Di(); */
        for(i = 0; i < sizeof(SccCmdData); i++)
        {
                scc_port_a->control = SccCmdData[i];
        }

        /*----------------------------------------
         * Enable the DMA Req function for receive.
         *----------------------------------------
         */
        scc_port_a->control = WR1;
        scc_port_a->control = DMA_REQ_ENB|DMA_REQ_FUNC|DMA_REQ_RCV;
        crit_off(prevalue);
/*	Ei(); */

        /*----------------------------------------
         * Set up receive dma. Receiver will be
         * enabled in the SCC Ext Status ISR after
         * we have sent the first frame.
         *----------------------------------------
         */
        set_rcv_dma();

	/*---------------------------------------- 
	 * Initialize receive buffer descriptors. 
	 *---------------------------------------- 
	 */
	init_scc_bd();

	/*---------------------------------------- 
	 * Initialize scc statistics counters. 
	 *---------------------------------------- 
	 */
	init_scc_info();

	/*---------------------------------------- 
	 * Create SccRcvMbox for brip_rcv_task().
	 * Create SccFreeMbox for brip_free_task().
	 *---------------------------------------- 
	 */
	CreatMailbox(&SccRcvMbox);
	CreatMailbox(&SccFreeMbox);

	/*---------------------------------------- 
	 * Create Retransmission Timer for scc_send().
	 *---------------------------------------- 
	 */
	CreatTimer( &ReXmtTimer );
}

/*--------------------------------------------------------------------------
 * scc_send()
 * sends a frame on the tx line. 
 *--------------------------------------------------------------------------
 */
void scc_send( SCC_BD *tx_bd )
{

volatile byte *collision_reg = (byte *)SCC_COLLISION_REG;
volatile int loop_count;
int	backoff_interval, prevalue;
byte	dummy;

	/*
	* intercept all xmt frames for SCC monitor
	*/
	PrintSccFrame(tx_bd->buff_ptr);

	/*---------------------------------------- 
	 * Check for missing P2 backplane. If so,
	 * return right away. 
	 *---------------------------------------- 
	 */
	if ( backplane_p2_missing )
	{
#ifdef SCC_DEBUG
		printf("\tP2 backplane missing!\t");
#endif
		d_scc_0_miss++;

		SendMessage( (MSGHDR *)tx_bd, &SccFreeMbox );
		return;
	}

	/*---------------------------------------- 
	 * Check DCD, see if scc xmt line is busy.
	 * Or scc_receive() has not finished yet.
	 *---------------------------------------- 
	 */
	loop_count = 0;
	while( (scc_port_a->control & DCD) || scc_in_rcv )
	{
		/*---------------------------------------- 
		 * If loop_count exceeds max value, than P2
		 * is missing. Set the backplane missing 
		 * flag so that we return right away in future 
		 * calls to us.
		 *---------------------------------------- 
		 */
		if ( loop_count++ >= 100 )
		{
			printf("Error: P2 Backplane missing!\n");
			d_scc_1_miss++;
			backplane_p2_missing = 1;
			SendMessage( (MSGHDR *)tx_bd, &SccFreeMbox );
			return;
		}
		ReSchedule();
#ifdef SCC_DEBUG
		printf("\tDCD\t");
#endif
		d_scc_dcd++;
	}

	/*---------------------------------------- 
	 * Reset the latched collision register to
	 * clear any previous collisions.
	 *---------------------------------------- 
	 */
	*collision_reg = 0x00;

	/*---------------------------------------- 
	 * Disable interrupts to prevent scc regs.
	 * being modified by scc_receive() when
	 * called in TimeSliceInt().
	 *---------------------------------------- 
	 */
        prevalue = crit_on();
	/*Di();*/

	dummy = *(volatile byte *)0x900000c0;

	scc_in_xmt = 1;
	/*---------------------------------------- 
	 * Set RTS to secure xmt channel.(0x63) 
	 *---------------------------------------- 
	 */
	scc_port_a->control = WR5;
	scc_port_a->control = TX_8BIT | RTS | TX_CRC ;

	/*---------------------------------------- 
	 * Disable receiver by setting bit 0 of WR3
	 * to 0. Other bits remain the same (0xdc).
	 * Receiver will be enabled in SCC ISR when
	 * transmission completes, indicated by the
	 * TxEOM external status interrupt.
	 *---------------------------------------- 
	 */
	scc_port_a->control = WR3;
	scc_port_a->control = RX_8BIT | HUNT_MODE | RX_CRC | SRCH_MODE;

	/*---------------------------------------- 
	 * Read the collision register to detect
	 * collision (non-zero) while setting RTS.
	 *---------------------------------------- 
	 */
	if ( (*collision_reg & 0x01) == 0 )
	{
		/*printf("+");*/
		d_scc_no_coll++;
		/*---------------------------------------------------------
		 * The status fifo in Zilog 85c30 may not indicate frame
		 * available even if there is. As a result, the "gap"
		 * between rcv_dma_ptr and last_dma_ptr increases. In theory
		 * this should not happen since scc_receive() is called 200 
		 * times per second. rcv_dma_ptr should always be the same
		 * as last_dma_ptr as confirmed by AMD 85c30 chip.
		 * To handle this problem, we reset the status fifo if the 
		 * gap is bigger than 2 keep alive frame. 
		 *---------------------------------------------------------
		 */
		if ( rcv_overrun_error || (rcv_buff_gap > MAX_SCC_RX_GAP ))
		{
			if (rcv_buff_gap > MAX_SCC_RX_GAP)
			{
				/*---------------------------------
				 * Reset status fifo by disabling
				 * and enabling the status fifo.
				 *---------------------------------
				 */
				scc_port_a->control = WR15;
				scc_port_a->control = 0x00;	

				scc_port_a->control = WR15;
				scc_port_a->control = 0x04;	
				rcv_buff_gap = 0;
			}
			set_rcv_dma();
			rcv_overrun_error = 0;
			rcv_buff_wrapped = 0;
			rcv_dma_ptr = RxDMADstPtr;
#ifdef SCC_DEBUG
			fault_cnt = 1;
			printf("\nRxOVR ERR: DMA Reset\n");
			fault_cnt = 0;
#endif
			/**printf("o");**/
		}
		/*----------------------------------------
		 * Since the receiver is stopped during 
		 * transmission, receive dma transfer must
		 * be completed. 
		 * Check the receive dma (channel 0) for
		 * the current destination address. If
		 * destination is close to the end of the
		 * receive buffer, reset the rx dma to
		 * start at the beginning of rx buffer. 
		 *----------------------------------------
		 */


		asm( "udma" );
		if ( (rx_chnl_dma->dst_addr - RxDMADstPtr ) > 
		     (MAX_SCC_RX_BUFFER - SCC_RX_SAFETY_MARGIN))
		{
			/*------------------------------------------
			 * save the value of the last receive buffer
			 * address before we wrap the receive buffer
			 *------------------------------------------
			 */
			last_dma_ptr = rx_chnl_dma->dst_addr;
			rcv_buff_wrapped = 1;
			rcv_buff_gap = last_dma_ptr - rcv_dma_ptr;

			if ( rcv_dma_ptr >= last_dma_ptr ) 
			{
				rcv_dma_ptr = RxDMADstPtr;
				rcv_buff_wrapped = 0;
			}
			set_rcv_dma();
#ifdef SCC_DEBUG
			fault_cnt = 1;
			printf("\nRstDMA last_dma_ptr= %x rcv_dma_ptr= %x\n", 
			last_dma_ptr, rcv_dma_ptr);
			fault_cnt = 0;
#endif
		}

		/*---------------------------------------- 
		 * Reset the Tx CRC generator.
		 *---------------------------------------- 
		 */
		scc_port_a->control = RST_TXCRC;

#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
		/*---------------------------------------- 
		 * Set up the i960 DMA.
		 *---------------------------------------- 
		 */
		TxByteCount = tx_bd->length;
        	TxDMASrcPtr = tx_bd->buff_ptr;
		set_xmt_dma();
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/

	dummy = *(volatile byte *)0x900000c0;
		/*---------------------------------------- 
		 * Set RTS and enable Tx (0x6b).
		 *---------------------------------------- 
		 */
		scc_port_a->control = WR5;
		scc_port_a->control = TX_8BIT | TX_ENABLE | RTS | TX_CRC ;

		/*---------------------------------------- 
		 * No collision, enable Tx DMA by setting
		 * REQ_FUNC on tx buffer empty.
		 *---------------------------------------- 
		 */
		scc_port_a->control = WR14;
		scc_port_a->control = REQ_FUNC;

	dummy = *(volatile byte *)0x900000c0;

#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/
		/*---------------------------------------- 
		 * Set up the i960 DMA.
		 *---------------------------------------- 
		 */
		TxByteCount = tx_bd->length;
        	TxDMASrcPtr = tx_bd->buff_ptr;
		set_xmt_dma();

		/*---------------------------------------- 
		 * Need to reset TxEOM after 1st char has
		 * been loaded, so that CRC will be sent
		 * at the end of frame. 
		 * Reset the loop_count variable to make
		 * that we will not hang if P2 backplane
		 * is missing, or the SCC has problem 
		 * loading from DMA.
		 *---------------------------------------- 
		 */
		loop_count = 0;
     		while ( (scc_port_a->control & TX_BE) &&
			(loop_count++ < 100) ) ;

		/*---------------------------------------- 
		 * If loop terminates because of loop_count
		 * exceeds max value, than P2 is missing.
		 * set the backplane missing flag so that
		 * we return right away in future calls to
		 * us. Free the tx_bd and re-enable interrupts.
		 *---------------------------------------- 
		 */
		if ( loop_count >= 100 )
		{
#ifdef SCC_DEBUG
			printf("Backplane missing\n");
#endif
			/**printf("-");**/
			d_scc_2_miss++;

			backplane_p2_missing = 1;
			SendMessage( (MSGHDR *)tx_bd, &SccFreeMbox );
			crit_off(prevalue);
			/*Ei();*/
			return;
		}

		scc_port_a->control = RST_TXEOM;

		/*----------------------------------------
		 * Enable external status interrupt and
		 * disable the DMA Request.
		 * May cause glitches in the 85c30 chip to
		 * generate a DMA transfer to rcv buffer.
		 *----------------------------------------
		 */

		scc_port_a->control = WR1;
		scc_port_a->control = DMA_REQ_FUNC|DMA_REQ_RCV|EXT_INT_ENB;

		/*----------------------------------------
		 * Enable TxUR or EOM for ext int source
		 * and keep status FIFO enabled.
		 *----------------------------------------
		 */
		scc_port_a->control = WR15;
		scc_port_a->control = 0x44; 
		 /*
		*(byte *)80000014 = WR15;
		*(byte *)80000014 = 0x44;
		*/

		crit_off(prevalue);
		/*Ei();*/
		SccInfo.xmt_byte_count += TxByteCount;
		d_scc_xmt_req++;

		SendMessage( (MSGHDR *)tx_bd, &SccFreeMbox );
	}
	else
	{
#ifdef SCC_DEBUG
			fault_cnt = 1;
		printf("\tCollision\t");
			fault_cnt = 0;
#endif
		/**printf("C");**/
		d_scc_coll++;

		SccInfo.xmt_collisions++;

		/*----------------------------------
		 * Collision Occurred, disable Tx,
		 * re-enable Rx and perform backoff. 
		 *----------------------------------
		 */
		scc_port_a->control = WR5;
		scc_port_a->control = 0x60;
 
		/*-------------------
		 * Enable Rx DMA Req 
		 *-------------------
		 */
                scc_port_a->control = WR1;
		scc_port_a->control = DMA_REQ_ENB|DMA_REQ_FUNC|DMA_REQ_RCV;

		/*-------------------
		 * Re-enable Rx
		 *-------------------
		 */
		scc_port_a->control = WR3;
		scc_port_a->control = RX_8BIT | HUNT_MODE |
					RX_CRC | SRCH_MODE | RX_ENABLE;
                crit_off(prevalue);
		/*Ei();*/
		/*--------------------------------------------
		 * Use the collision count to randomly backoff
		 * 0 or up to the no. of collisions.
		 *--------------------------------------------
		 */
		backoff_interval= (rand() % (SccInfo.xmt_collisions +1 )) * 1;
		StartTimerCall(&ReXmtTimer,backoff_interval, scc_send, (int) tx_bd);
	}
}

/*--------------------------------------------------------------------------
 * scc_receive()
 * Gets a frame from the receive dma memory area. Called from TimerSliceInt.
 *--------------------------------------------------------------------------
 */
void scc_receive()
{

byte	rr1, rr6, rr7, dummy;
int	byte_count, prevalue;
SCC_BD *bd_ptr;

	/*---------------------------------------- 
	 * Check status FIFO for availability of 
	 * frame by reading RR7 bit 6.(0x40)
	 *---------------------------------------- 
	 */

	if (scc_in_xmt)
		return;
        prevalue = crit_on();
/*	Di(); */
	scc_in_rcv = 1;
#ifdef SCC_DEBUG
	scc_rcv_count++;
#endif

	scc_port_a->control = RR7;
	rr7 = scc_port_a->control;

	if ( rr7 & FIFO_OVRUN )
	{
		/*---------------------------------------- 
		 * Reset the Status FIFO overrun bit by
		 * disabling and re-enabling the FIFO control
		 * bit on WR15. 
		 *---------------------------------------- 
		 */
#ifdef SCC_DEBUG
			fault_cnt = 1;
		printf("\n FIFO Overrun\n");
			fault_cnt = 0;
#endif
		SccInfo.rcv_status_fifo_overrun++;
		scc_port_a->control = WR15;
		scc_port_a->control = 0x00;	

		scc_port_a->control = WR15;
		scc_port_a->control = 0x04;	
	}
	else if ( rr7 & FRAME_AVAIL )
	{
		/*---------------------------------------- 
		 * Get byte counts from RR6 and receive
		 * status from RR1. 
		 * ***NOTE: RR1 must be read last, after
		 * RR7 & RR6, because reading RR1 will pop
		 * the top of status FIFO.
		 *---------------------------------------- 
		 */

		scc_port_a->control = RR6;
		rr6 = scc_port_a->control;

		scc_port_a->control = RR1;
		rr1 = scc_port_a->control;

		/*---------------------------------------- 
		 * Get the no. of bytes received.
		 *---------------------------------------- 
		 */
		byte_count = ((rr7 & 0x3F) << 8) | rr6;
		SccInfo.rcv_byte_count += byte_count;

#ifdef SCC_DEBUG
		scc_frame_count++;
		*( (byte *) 0x80000040) = 1;
#endif
		/*---------------------------------------- 
		 * Check for any recevie errors.
		 *---------------------------------------- 
		 */

		if ( (rr1 & CRC_ERR ) || (rr1 & RX_OVR) || ((rr1 & RESIDUE) != 0x06))
		{
			/*---------------------------------------- 
			 * Update specific error counters.
			 *---------------------------------------- 
			 */
			if ( rr1 & CRC_ERR )
				SccInfo.rcv_crc_error++;

			if ( rr1 & RX_OVR )
			{
				rcv_overrun_error = 1;
				SccInfo.rcv_overrun_error++;
			}

			if ( rr1 & RESIDUE )
				SccInfo.rcv_residue_error++;

			/*---------------------------------------- 
			 * Discard the error frame by incrementing
			 * the rcv_dma_ptr to the next frame. 
			 *---------------------------------------- 
			 */
#ifdef SCC_DEBUG
			fault_cnt = 1;
			printf("\nERR, rr1=%x bc=%d\n",rr1, byte_count);
			fault_cnt = 0;
#endif
			
			/*---------------------------------------- 
			 * Compare with the last_dma_ptr to check
			 * if we have wrap around. If so, reset the
			 * rcv_dma_ptr to top of receive buffer.
			 *---------------------------------------- 
			 */
			if ( (rcv_buff_wrapped) &&
			     (rcv_dma_ptr >= last_dma_ptr ))
			{
				rcv_dma_ptr = RxDMADstPtr;
				rcv_buff_wrapped = 0;
			}

			rcv_dma_ptr += byte_count;
		}
		else
		{
			/*---------------------------------------- 
			 * Compare with the last_dma_ptr to check
			 * if we have wrap around. If so, reset the
			 * rcv_dma_ptr to top of receive buffer.
			 *---------------------------------------- 
			 */
			if ( (rcv_buff_wrapped) &&
			     (rcv_dma_ptr >= last_dma_ptr ))
			{
				rcv_dma_ptr = RxDMADstPtr;
				rcv_buff_wrapped = 0;
			}

			if ( (bd_ptr = get_scc_bd( BD_RCV )) != NULL )
			{

				/*---------------------------------------- 
				 * Get receive buffer descriptor and mail
				 * it to the SccRcvMbox for brip_rcv_task.
				 * Don't increment rcv_dma_ptr if no buffer 
				 * descriptor is available. Mail to SccRcvMbox
				 * when we have a descriptor.
				 *---------------------------------------- 
				 */
				bd_ptr->buff_ptr = rcv_dma_ptr;
				bd_ptr->length	= byte_count;
				bd_ptr->bd_type	= BD_RCV;
	
				rcv_dma_ptr += byte_count;
				SendMessage( (MSGHDR *)bd_ptr, &SccRcvMbox );
			}
			else
			{
				SccInfo.rcv_no_bd_error++;

				/*------------------------
				 * Disgard frame.
				 *------------------------
				 */
				rcv_dma_ptr += byte_count;
#ifdef SCC_DEBUG
			fault_cnt = 1;
				printf("\n***NO DBD");
			fault_cnt = 0;
#endif
			}
		}

	}
        crit_off(prevalue);
/*	Ei(); */
	scc_in_rcv = 0;
}

/*--------------------------------------------------------------------------
 * scc_stop()
 * 	Stops the scc channel a from transmitting and receiving.
 *--------------------------------------------------------------------------
 */
scc_stop()
{
        int prevalue;
	
	/*-------------------
	 * Disable Rx & Tx
	 *-------------------
	 */
	prevalue = crit_on();
/*	Di(); */
	scc_port_a->control = WR3;
	scc_port_a->control = RX_8BIT | HUNT_MODE | RX_CRC | SRCH_MODE;

	scc_port_a->control = WR5;
	scc_port_a->control = 0x60; 
	crit_off(prevalue);
/*	Ei(); */
}
