/******************************************************************
 *	Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   Token Ring Concentrator application
 *
 *      Filename:       uierror.h
 *
 *      Description:    contains error messages. 
 *
 *	$Log:   /user/pvcs/trc/ui/include/uierror.h_v  
 * 
 *    Rev 1.13   02 Mar 1993 12:58:56   nayan
 * added error code ERR_MIB_NAME.
 * 
 *    Rev 1.12   02 Mar 1993 11:46:48   nayan
 * major changes.
 * Using Error Codes that are required.
 * 
 *    Rev 1.11   01 Feb 1993 09:08:08   nayan
 * 
 *    Rev 1.10   25 Jan 1993 10:42:20   nayan
 * 
 *    Rev 1.9   28 Dec 1992 15:33:26   jang
 * added more error code for port locking
 * 
 *    Rev 1.8   04 Dec 1992 12:42:10   nayan
 * added error messages  for trigger commands.

 *      Revision:
 *      1-000           Jul-10-92      Szewei Ju
 *              	- Original, adapted from the 'stanley' bridge code.
 *
 *******************************************************************
 */
 
#ifndef	__ERROR_H
#define	__ERROR_H

/* definitions of error codes */

#define CMD_SYNTAX_ERR		1	
#define	KW_UN_AMB          	2
#define	KW_UNKNOWN			KW_UN_AMB		
#define OUT_OF_RANGE		3
#define LOGIN_FAIL			4 
#define INVAL_PWD			5 
#define ERR_PASSWORD		INVAL_PWD
#define PWD_VER_FAIL		6 
#define	ERR_STR_TOO_LONG	7 
#define ERR_NET_ADDR		8	
#define	ERR_IP_ADDRESS		9 
#define	INV_PHY_ADDR		10 
#define	ERR_NET_UNREACHABLE	11	

#define ERR_TRIG_TAB_FULL	12
#define ERR_TRIG_PORT_EXCL	13
#define ERR_TRIG_NO_MATCH	14
#define ERR_TRIG_TAB_EMPTY	15

#define	ERR_STOP_BIT_1_5	16	
#define	ERR_STOP_BIT_2		17	

#define FATAL_ERROR			18 

#define LOCK_ADDR_DUPLICATE	19
#define LOCK_ADDR_NOT_FOUND	20
#define LOCK_ADDR_FULL		21
#define LOCK_ADDR_EMPTY		22

#define CAN_NOT_SET			23 

#define ERR_MIB_NAME		24 




#ifdef REM

#define	INV_PORT		OUT_OF_RANGE 	
#define	REQ_PRIV		4
#define NO_SUCH_ENTRY           5
#define USER_NOT_LOGIN          6
#define	INV_SPEC_CHAR	        8	

#define NO_SESSION              11
#define ERR_NOTCONN             NO_SESSION
#define EX_ENTRY_LIMIT          12
#define ERR_TBL_FULL	        EX_ENTRY_LIMIT	
#define NO_PREFER               13

#define EX_LIMIT                15
#define NO_RESOURCE             16
#define ERR_NORSRC              NO_RESOURCE 
#define UNKNOWN_DNAME           17 
#define	PFX_REQUIRE	        18	
#define INV_NAME	        19 

#define CAN_NOT_MODIFY         	21 
#define	ERR_REMOTEBUSY	 	22
#define	ERR_NOREMOTERESOURCE	ERR_REMOTEBUSY	
#define	ERR_UNKNOWN 		UNKNOWN_DNAME		
#define	ERR_NETFAIL		23
#define	ERR_BADSERVICE		24	
#define	ERR_TIMEOUT    		25	

#define	ERR_REMOTEREJECT	27  
#define	NO_SUCH_USER		29	
#define	NO_RMV_MASTER		30	
#define	MASTER_NOSET		NO_RMV_MASTER	
#define ERR_KEY			31	
#define	USER_LOGGED_IN		32	
#define CAN_NOT_DEFINE          33 
#define	DUP_ALIAS_CMD		34	
#define DUP_USER_NAME		DUP_ALIAS_CMD 
#define	LINE_TOO_LONG		35	

#define ERR_F_ABORT             36 
#define	ADM_INVALID_CMD		37	
#define CAN_NOT_SENT            38 
#define	ERR_NOTNEGOT	   	CAN_NOT_SENT	
#define CMD_PRIV_ERR		39	
#define	INV_MSG_SLOT		40
#define NON_PRINT_CHAR          41
#define	NO_PURGE_MASTER		42
#define	NO_HOST_NAME		43
#define	NO_HOST_ADDR		44
#define	CAN_NOT_REMOTE		45
#define	SNMP_MGR_SET		46 /* SNMP mgr already set */
#define	NO_MORE_MASTERS		47 /* No more master users */

#define INTER_HUB_LINK_NOT_EXIST    55
#define INTER_HUB_INV_PORT          56

/* definitions of error codes that were added for v2 support */
#define	ERR_NORMALCLOSE				0

#endif


#endif
