
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	nvrecs.h
*
*	$Log:   /usr/shasta/pvcs/trc/include/nvrecs.h_v  $
 * 
 *    Rev 2.0   01 Dec 1993 13:55:22   jlin
 * 
 * 
 * Add new port lock record and a new field port type in the port record.
 * 
 *    Rev 1.24   08 Feb 1993 15:43:22   shaun
 * lsh Feb/08/93 Replaced unused nvr_LocalConfig (int) by nvr_oldslotid &
 * nvr_oldhubid (ushort) to handle location change.
 * 
 *    Rev 1.23   08 Feb 1993 11:21:20   jlin
 * Get the fddi record out of the boot record.
 * 
 *    Rev 1.22   05 Feb 1993 14:38:28   jlin
 * Add new attributes in NVR_FDDI
 * 
 *    Rev 1.21   03 Feb 1993 10:12:52   jang
 * added port_state to fddi_port. It will be used to decided whether or not
 * the port should be connected after reset
 * 
 *    Rev 1.20   04 Jan 1993 09:49:08   jang
 * moved trigger.h inside of #ifdef __FDDI_CON
 * 
 *    Rev 1.19   29 Dec 1992 15:39:58   jang
 * added block for trigger
 * 
 *    Rev 1.18   30 Nov 1992 14:39:26   holeman
 * add commands for setting maximum reset level and bootp media
 * 
 *    Rev 1.17   12 Nov 1992 12:44:54   holeman
 * 
 *    Rev 1.17   11 Nov 1992 15:45:28   holeman
 * 
 *    Rev 1.16   11 Nov 1992 15:42:38   holeman
 * 
 *    Rev 1.15   06 Nov 1992 12:21:58   shaun
 * lsh Nov/05/92 Added nvr_save_mode_type.
 * 
 *    Rev 1.14   03 Nov 1992 17:25:38   holeman
 * 
 *    Rev 1.13   27 Oct 1992 16:02:42   holeman
 * 
 *    Rev 1.12   26 Oct 1992 12:15:28   holeman
 * 
 *    Rev 1.11   15 Oct 1992 14:46:16   holeman
 * 
 *    Rev 1.10   06 Oct 1992 09:13:22   markv
 * Added Port level non-volatile memory records.
 * 
 *    Rev 1.9   05 Oct 1992 16:38:48   holeman
 * 
 *    Rev 1.8   03 Oct 1992 14:28:10   shaun
 * lsh Oct/03/92 Added tty config info into nvr record.
 * 
 *    Rev 1.7   25 Sep 1992 10:01:06   holeman
 * 
 *    Rev 1.6   09 Sep 1992 18:03:12   jlin
 * Change FDDI Data Structures
 * 
 *    Rev 1.5   08 Sep 1992 11:56:44   shaun
 * lsh Sep/08/92 Added sysAdmAccess and systemPassword[] into NVR_BOOT. Also 
 * removed leftover comments from previous revision.
 * 
 *    Rev 1.4   07 Sep 1992 15:06:34   shaun
 * lsh Sep/07/92 Moved NVR_SYS info. into NVR_BOOT as part of the boot record.
 * Removed NVR_SYS and related #defines.
 * 
 *    Rev 1.3   02 Sep 1992 09:46:20   markv
 * Added stuff to nvr_sys to cover SNMP stuff, mostly. Still need to add more, but
 * for now, it's OK.
 * 
 *    Rev 1.2   25 Aug 1992 09:24:02   holeman
 * 
 *    Rev 1.1   13 Aug 1992 16:52:08   holeman
 * 
 *    Rev 1.0   01 Jul 1992 11:10:06   holeman
 * initial release
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


#ifndef __NVRECS_H
#define __NVRECS_H v100


#ifndef __NVRAM_H
#include <nvram.h>
#endif

#ifndef __MEMORY_H
#include <memory.h>
#endif

#include <bitmask.h>
#include <log.h>



typedef struct nvr_boot
	{
	int	nvr_boot_marker;
	in_name	nvr_IP;
	in_name nvr_ServerIP;
	in_name	nvr_NetMask;
	in_name nvr_RouterIP[2];
	ushort	nvr_hubid;
	ushort	nvr_slotid;
	ushort	nvr_oldhubid;
	ushort	nvr_oldslotid;
	char	nvr_request_file[64];
	char	nvr_image_file[64];
	char	nvr_config_file[64];
	int	nvr_OffsetGMT;			/* offset(seconds) of local  */
						/* time to GMT */
	in_name	nvr_TimeServer;
	in_name	nvr_BootpServer;
	char	nvr_BurnDate[8];		/* the date and time of last */
	char	nvr_BurnTime[8];		/* software was updated and */
						/* burned into the flash */
	ushort	nvr_BurnCycles;			/* how many times the flash */
						/* has been programmed */

	/*
	* the following values override the DIP switch if they are set
	* a -1 == value has not been set, use the DIP switch setting
	*/
	short	nvr_tty_baud;			/* tty baud rate */
	short	nvr_ring_number;		/* hub ring number */
#define MAX_RING_NUMBER	0xf
	short	nvr_ring_rate;			/* hub ring speed */
						/* 0 = 16 megabit */
						/* 1 = 4 megabit */
	short	nvr_save_mode_type;		/* previous value of mode type*/
	short	nvr_mode_type;			/* automatic startup type */
						/* 0 = load and exec flash */
						/* 1 = load and exec network */
						/* 3 = load from network */
						/*     burn flash */
						/*     load and exec flash */
	short	nvr_bootp_request;		/* 0 = send bootp at startup */
	short	nvr_bootp_error;
	short	nvr_debug;

	word	nvr_reset_cause;		/* reset type, 0-pwrup, */
						/* 1 - single, 2 - extended */
						/* ff - software */
	short	nvr_max_reset_level;		/* 1 .. 4 as demanded by init
						/* command */
	short	nvr_reset_level;		/* count times reset pushed */

	ushort	SNMPAuthentication;		/* none (1) community (4) */
	short	sysAdmAccess;
#define TRAP_MANAGER_NO 4
	in_name	SnmpMgr[TRAP_MANAGER_NO];
	uint	GenericTrap[TRAP_MANAGER_NO];
	uint	SpecificTrap[TRAP_MANAGER_NO];
	char	sysDescription[64];
	char	sysLocation[64];
	char	sysName[64];
	char	sysContact[64];
	char	systemPassword[16];

	char	nvr_flash_file[64];
	short	nvr_tty_parity;			/* tty parity	 */
	short	nvr_tty_data_length;		/* tty char size */
	short	nvr_tty_stop_bits;		/* tty stop bits */
	short	nvr_last_reset_cause;
	short	nvr_last_reset_level;
	short	nvr_reset_processed;
	short	nvr_bootp_media;
	short	nvr_spare_1;

	char	nvr_tty_prompt[32];		/* console prompt*/
	short	nvr_spare[240];			/* Need to keep this *accurate* or
						   the NVR_PORT stuff breaks... */
	/*
	* the last 16 bits is the checksum of the whole structure
	*/
	ushort	nvr_checksum;			/* nvram record ends here */
	} NVR_BOOT;

typedef struct nvr_Port_Rec {
	ushort	portOperation;
	ushort	portLockReset;
	ushort	portLinkTest;
	ushort	portOnEvent;
	ushort	portOffEvent;
	ushort	portBeaconRate;
	ushort 	portBeaconInterval;
	ushort  portType;                      /* jlin: Lobe or RI/RO fillerl[32]*/
                #define PORT_LOBE    0
	        #define PORT_RI      0x01
	        #define PORT_RO      0x02
                #define PORT_RIRO    (PORT_RI | PORT_RO)
	ushort	fillerl[31];		       /* Adjust this as stuff is added, or
						   the NVR_PORT stuff breaks ... */
} NVR_PORT_REC;

#define MAX_TOTAL_PORT 	(32)

typedef struct nvr_Port {
	int	nvr_port_marker;
	NVR_PORT_REC	port_rec[MAX_TOTAL_PORT+1];
	ushort	ringBeaconRate;
	ushort	ringBeaconInterval;
	ushort	ringBeaconRisingEvent;
	ushort	ringBeaconFallingEvent;
	ushort  rioPosition;                    /* used by 508 : jlin 10/20/93 */
                #define RIO_NONE  0
                #define RIO_POS12 1
                #define RIO_POS34 2
                #define RIO_POS56 4
                #define RIO_POS78 8
	ushort	fillerl[27];			/* Space for TRC Global stuff */ 
	ushort	nvr_port_checksum;		/* nvram record ends here */
} NVR_PORT ;




extern	NVR_PORT	nvr_port;
extern	NVR_BOOT	nvr_boot_rec;


#define BOOT_MARKER	0x544F4F42
#define PORT_MARKER	~BOOT_MARKER

#define NVR_BOOT_ADDR	(NVRAM_HDR_ADDR + NVRAM_HDR_SIZE)
#define NVR_BOOT_SIZE	ALIGN(sizeof(NVR_BOOT), 2)

#define NVR_PORT_ADDR	(NVR_BOOT_ADDR + NVR_BOOT_SIZE)
#define NVR_PORT_SIZE	ALIGN(sizeof(NVR_PORT), 2) 

#ifdef __FDDI_CON
#   include "nvrfddi.h"   /* FDDI NVR Records */
#else  
/* for TRC */

#define PORT_NOT_LOCK                 0
#define PORT_LOCK_BY_TRIG             1
#define PORT_LOCK_BY_ADDR             2

/*
 *---------------------------------------------------------------------
      the port is numbering as:
        physical port position -  B  M5  M4  M3  M2  A
        indexing               -  0  5   4   3   2   1

      All the fields in the structure are pointers that point to smt mibs
      or rmon mibs. All the pointers should be initialized at PHY_Init().
  *---------------------------------------------------------------------
  */
#define LOCK_ADDR_MAX      6   /* # of addresses monitored per port */
#define LOCK_ADDR_LEN      6   /* address bytes - long address */
#define LOCK_SRC_ADDR      0
#define LOCK_DEST_ADDR     1

typedef struct _port_info_ {
      uint   src_addr_num;
      byte   src_addr[LOCK_ADDR_MAX][LOCK_ADDR_LEN]; /* address locking */
      uint   dest_addr_num;
      byte   dest_addr[LOCK_ADDR_MAX][LOCK_ADDR_LEN];

#if 0
      FDDI_PSTATS *pstats;   /* point to promiscuous statistics table */
#endif
} PORT_INFO;


/* Definitions of PORT ACTIONS */
#define PORT_ACT_VALID          2
#define PORT_ACT_INVALID        1

typedef struct _nvr_port_lock_ {
    int nvr_port_lock_marker;
      PORT_INFO port_lock[MAX_TOTAL_PORT+1];
      PORT_INFO res_plock[4];
      int  res[512];
      ushort nvr_checksum;
  } NVR_PORT_LOCK;

/* define for port locking */
#define NVR_PORT_LOCK_MARKER  0x4c4f434b
#define NVR_PORT_LOCK_ADDR    (NVR_PORT_ADDR + NVR_PORT_SIZE)
#define NVR_PORT_LOCK_SIZE    ALIGN(sizeof(NVR_PORT_LOCK), 2)

#endif   /* __FDDI_CON */

#endif
