
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	led.h
*
*	$Log:   /shasta/pvcs/trc/include/led.h_v  $
 * 
 *    Rev 1.4   04 Dec 1992 13:54:16   holeman
 * 
 *    Rev 1.3   26 Oct 1992 12:15:22   holeman
 * 
 *    Rev 1.2   06 Oct 1992 14:17:26   holeman
 * 
 *    Rev 1.1   15 Jul 1992 10:22:30   holeman
 * 
 *    Rev 1.0   01 Jul 1992 11:10:00   holeman
 * initial release
 * 
 *    Rev 1.0   31 Mar 1992 18:08:30   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __LED_H
#define __LED_H

#define LED_BI		0
#define LED_MONO	1

#define LED_ACT 0x0003
#define LED_RDY 0x000c

#define LED_MONO_COLOR 	0xffff

#define LED_OFF   0x00
#define LED_RED   0x01
#define LED_GREEN 0x02

#define LED_ACT_OFF	LED_OFF
#define LED_ACT_RED	LED_RED
#define LED_ACT_GRN	LED_GREEN

#define LED_RDY_OFF	(LED_OFF << 2)
#define LED_RDY_RED	(LED_RED << 2)
#define LED_RDY_GRN	(LED_GREEN << 2)

#define LED_LEFT_DECIMAL_POINT	0x80
#define LED_LEFT_DECIMAL_OFF	0x80
#define LED_LEFT_DECIMAL_ON	0x00

#define LED_RIRO_OFF   0
#define LED_RIRO_GREEN 1
#define LED_RIRO_RED   2

#define	SRAM_TEST	0x0010
#define	DRAM_TEST	0x0020
#define	FPROM_TEST	0x0030
#define	SHRAM_TEST	0x0040
#define	NVRAM_TEST	0x0050
#define	TMR_TEST	0x0060
#define	FLASH_TEST	0x0070
#define	EEPROM_TEST	0x0080
#define	UART_TEST	0x0090
#define	ETHERNET_TEST	0x00a0

/*
 *	BOOTER power on self test
 */
#define	LED_BPOST	(LED_RDY_OFF | LED_ACT_RED)
/*
 * 	KERNEL power on self test
 */
#define	LED_KPOST	(LED_RDY_RED | LED_ACT_RED)
/*
 *	ERROR on self test
 */
#define	LED_ERROR	(LED_RDY_RED | LED_ACT_RED)
/*
 *	BRIDGE initializing
 */
#define	LED_BRINI	(LED_RDY_GRN | LED_ACT_GRN)
/*
 *	BRIDGE bridging (normal operation)
 */
#define	LED_BRIDGE	(LED_RDY_GRN | LED_ACT_GRN)
/*
 *	TESTER program
 */
#define	LED_TESTER	(LED_RDY_RED | LED_ACT_GRN)
/*
 *	packet generator/monitor
 */
#define	LED_TPACKET	(LED_RDY_RED | LED_ACT_OFF)
/*
 *	BOOTER - tftp
 */
#define	LED_BTFTP	(LED_RDY_GRN | LED_ACT_RED)
/*
 *	TFTP loader 
 */
#define	LED_TTFTP	(LED_RDY_GRN | LED_ACT_RED)

#endif
