#ifndef EXCEPT_H
#define EXCEPT_H
/*      A general purpose exception handeling system for 'c'
        Based on an idea by Jonathan Amsterdam, published in
        BYTE August 1991.
*/
#include <types.h>
#include <setjmp.h>

typedef unsigned int exception;

typedef struct jbr {
                jmp_buf jb;
                struct jbr FAR * next;
                struct jbr FAR * self;
        } jmp_buf_rec;

#define WITH_HANDLING   {jmp_buf_rec _jbr; \
                         push_jbr(&_jbr); \
                         if(setjmp(_jbr.jb) == 0) \
                         {      theException=0;

#define ON_EXCEPTION pop_jbr();} else {
#define END_HANDLING }}
                                    /* Declared in EXHANDLE.C */
extern exception theException;
void error(exception,...);
void reraise(void);
void push_jbr(jmp_buf_rec FAR *);
void pop_jbr(void);
void logerror(unsigned int,exception);
#endif
