
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	eeprecs.h
*
*	$Log:   /h/pvcs/bridge/include/eeprecs.h_v  $
 * 
 *    Rev 1.0   09 Apr 1992 14:47:36   pvcs
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:26   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __EEPRECS_H
#define __EEPRECS_H

#ifndef __TYPES_H
#include <types.h>
#endif

#ifndef __MEMORY_H
#include <memory.h>
#endif

#ifndef __EEPROM_H
#include <eeprom.h>
#endif

#ifndef	__DBD_H
#include <dbd.h>
#endif

#define MAX_PORTS	8
#define NO_OF_PORTS	4
#define	EEPROM_SIZE	8192
#define	MIN_FLASH_SIZE	(512 * 1024) /* 512 k of flash is the min.	*/

/* Note: All eeprom records should be 32 byte aligned.  */
/*       All eeprom records end with the checksum field.*/
/*       eep_dirty and eep_bitmap are present only in   */
/*       the dram copies of the eeprom records.         */

#ifdef notdef
#include	"/b/gregs/fddi/fddicon/smt/headers/fddihdr.h"
#include	"/b/gregs/fddi/fddicon/smt/dp83200if/headers/smtdefs.h"
#endif


/* This data structure is used by FDDI Concentrator only */
/**************************************************\
   FDDI EEPROM Data Structure
\**************************************************/
   typedef struct EEP_FDDI
   {
        /*
         *  FDDI SMT
         */
	byte     smtMac_Ct;
	byte     smtNonmaster_Ct;
	byte     smtMaster_Ct;
	byte     smtPathAvailable;
	u_short  smtConfigCapabilities;
	byte     smtStatusReporting;
	byte     xdiBothWrapCapability;

        /*
         * FDDI MAC                 
	 */
	u_short  macFrameStatusCapabilities[MAX_MAC_RESERVED];
	byte     macBridgeFunction[MAX_MAC_RESERVED];    /* use 8 bits instead of 16 bits */
	byte     macPathAvailable[MAX_MAC_RESERVED];

        /*
         * FDDI PATH                  
	 */
	byte     pathPortOrder[MAX_PATH_RESERVED];/* use 8 bits instead of 16 bits */
	byte     pathType[MAX_PATH_RESERVED];

        /*
         * FDDI PORT                  
	 */
	byte     portAvailPath[MAX_PORT_RESERVED];
	byte     portFotxClass[MAX_PORT_RESERVED];/* could be multi-mode,
						  single-mode1,
						  single-mode2,
						  sonet, or STP(not defined by
						  MIB yet) */

        /*
         * FDDI ATTACHMENT            
	 */
        byte     attachClass[MAX_ATTACH_RESERVED];

   } EEP_FDDI;



typedef struct eep_mfg
	{
	u_short	eep_marker;
	byte	eep_mfgdt;	/* manufacturing date */
	byte	eep_altdt;	/* last alteration date */
	u_int	eep_srlno;	/* serial number  */
	u_short	eep_level;	/* revision level  */
	u_short	eep_flags;	/* flag bits */
	byte	eep_ports;
	byte	eep_spare3;
	u_short	eep_spare4;
	u_int	eep_sram_size;
	u_int	eep_dram_size;
	u_int	eep_shram_size;
	u_int	eep_nvram_size;
	u_int	eep_eeprom_size;
	u_int	eep_fprom_size;
	u_int	eep_spare1;
	NID	eep_nid[MAX_PORTS];
	u_short	eep_spare2;
    EEP_FDDI eep_fddi;
	u_int	eep_spare[4];	/* spares for future use */
	u_short	eep_checksum;	/* eeprom record ends here */
	} EEP_MFG;

#define EEP_MFG_ADDR ALIGN(EEP_HDR_ADDR + EEP_HDR_SIZE, EEP_PAGE_SIZE)
#define EEP_MFG_SIZE ALIGN(sizeof(EEP_MFG), EEP_PAGE_SIZE)

/*	eep_flags values	*/
#define PROGRAM_FLASH	0x01


typedef struct eep_boot
	{
	ushort	eep_marker;
	ushort	eep_BurnCycles;	/* how many times the flash has been programmed */
	in_name	eep_IP;
	in_name eep_ServerIP;
	in_name	eep_NetMask;
	in_name eep_RouterIP[2];
	ushort	eep_hubid;
	ushort	eep_slotid;
	int	eep_LocalConfig;
	char	eep_request_file[64];
	char	eep_image_file[64];
	char	eep_config_file[64];
	int	eep_OffsetGMT;	/* offset(seconds) of local time to GMT */
	in_name	eep_TimeServer;
	in_name	eep_BootpServer;
	char	eep_BurnDate[8]; /* the date and time of last software */
	char	eep_BurnTime[8]; /* was updated and burned into the flash */
	int	reserved[16];	/* future usage	*/
	ushort	eep_ThinNet;	/* port 4 selection: 0 = AUI, 1 = ThinNet */
	ushort	eep_checksum;	/* eeprom record ends here */
	} EEP_BOOT;


#define EEP_BOOT_ADDR ALIGN(EEP_MFG_ADDR + EEP_MFG_SIZE, EEP_PAGE_SIZE)
#define EEP_BOOT_SIZE ALIGN(sizeof(EEP_BOOT), EEP_PAGE_SIZE)


extern	EEP_MFG		eep_mfg_rec;
extern	EEP_BOOT	eep_boot_rec;
#endif /* __EEPRECS_H */
