
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	dips.h
*
*	$Log:   /shasta/pvcs/trc/include/dips.h_v  $
 * 
 *    Rev 1.3   04 Feb 1993 16:17:40   holeman
 * 
 *    Rev 1.2   26 Aug 1992 15:50:54   holeman
 * 
 *    Rev 1.1   29 Jul 1992 09:36:38   holeman
 * 
 *    Rev 1.0   01 Jul 1992 11:09:50   holeman
 * initial release
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __DIP_H
#define __DIP_H

#define DIP1	0x01
#define DIP2	0x02
#define DIP3	0x04
#define DIP4	0x08
#define DIP5	0x10
#define DIP6	0x20
#define DIP7	0x40
#define DIP8	0x80

/*
* needed for snmp
*/
#define LAST_DIP_SWITCH         0x8000
#define DIP_SWITCH_COUNT        16

/*
* dip switch 1 definitions
*/
#define DIP1_TESTER		DIP1
#define TESTER_MODE 		1
#define AUTOMATIC_MODE 		0

#define DIP1_AUTOMATIC_MASK	(DIP2 | DIP3)
#define DIP1_LOAD_FLASH		0
#define DIP1_LOAD_NETWORK	DIP2
#define DIP1_LOAD_AND_BURN	(DIP2 | DIP3)
#define LOAD_FROM_FLASH		0
#define LOAD_FROM_NETWORK	2
#define LOAD_AND_BURN		3

#define	DIP1_BOOTP_REQUEST	DIP4
#define SEND_BOOTP		0

#define	DIP1_BOOTP_ERROR	DIP5
#define STOP_ON_BOOTP_ERROR	1

#define	DIP1_BAUD_MASK		(DIP6 | DIP7)
#define DIP1_BAUD_1200		0
#define DIP1_BAUD_2400		DIP7
#define DIP1_BAUD_4800		DIP6
#define DIP1_BAUD_9600		(DIP6 | DIP7)

#define DIP1_DEBUG		DIP8
#define DEBUG_ON		1

/*
* dip switch 2 definitions
*/
#define DIP2_TR_SPEED		DIP1
#define SIXTEEN_MEGABIT		1
#define DIP2_ADMIN_BUS		DIP4

#define DIP2_RING_NUMBER	(DIP5 | DIP6 | DIP7 | DIP8)

#endif /* __DIP_H */
