.include vcs.cfg

__FDDI_CON= 		#the flag which indicate this is FDDI code
			# used by the makefile in loader/system
# %echo Starting global in $(INPUTFILE)

# %echo $[d,$(VCSDIR)] $[r,$(VCSDIR)]

%if "$[r,$(VCSDIR)]"=""
SOURCEDIR = $[d,$(VCSDIR)]
%else
SOURCEDIR = $(VCSDIR)
%endif

%if !%defined(ROOT)
ROOT = ../..
%endif

FDDILIBDIR = $(ROOT)/fddicon/lib
TRCINCLUDE = $(ROOT)/trc/include

%if !%defined(IDIR1)
IDIR1	= $(ROOT)/trc/include
%endif
%if !%defined(IDIR2)
IDIR2	= $(ROOT)/i960/include
#IDIR2	= /b/gregs/i960/include
%endif
%if !%defined(IDIR3)
IDIR3	= $(IDIR2)
%endif
IDIR4	= /b/gregs/bridge/include
%if !%defined(ISMTHDR)
ISMTHDR	= $(ROOT)/fddicon/smt/headers
%endif
%if !%defined(ISMTIFHDR)
ISMTIFHDR= $(ROOT)/fddicon/smt/dp83200if/headers
%endif
%if !%defined(IFDDIHDR)
IFDDIHDR	= $(ROOT)/fddicon/include
%endif
%if !%defined(IDRVHDR)
IDRVHDR	= $(ROOT)/fddicon/drv/include
%endif
%if !%defined(IFUIHDR)
IFUIHDR	= $(ROOT)/fddicon/ui/include
%endif
%if !%defined(IUIHDR)
IUIHDR	= $(ROOT)/trc/ui/include
%endif
%if !%defined(ISNMPHDR)
ISNMPHDR= $(ROOT)/trc/snmp/include
%endif
%if !%defined(ISUPPHDR)
ISUPPHDR= $(ROOT)/include
%endif
%if !%defined(IMACHDR)
IMACHDR= $(ROOT)/trc/mac
%endif
%if !%defined(ITRCUIHDR)
ITRCUIHDR= $(ROOT)/trc/ui/include
%endif


%if !%defined(PIDIR1)
PIDIR1	= ${SOURCEDIR}/$(IDIR1)# where are the .h_v files
%endif
%if !%defined(PIDIR2)
PIDIR2	= ${SOURCEDIR}/${IDIR2}	# where are the .h_v files
%endif
%if !%defined(PIDIR3)
PIDIR3	= ${SOURCEDIR}/${IDIR3}	# where are the .h_v files
%endif
%if !%defined(PISMTHDR)
PISMTHDR= ${SOURCEDIR}/${ISMTHDR}# where are the .h_v files
%endif
%if !%defined(PISMTIFHDR)
PISMTIFHDR= ${SOURCEDIR}/${ISMTIFHDR}	# where are the .h_v files
%endif
%if !%defined(PIFDDIHDR)
PIFDDIHDR	= ${SOURCEDIR}/${IFDDIHDR}	# where are the .h_v files
%endif
%if !%defined(PIDRVHDR)
PIDRVHDR	= ${SOURCEDIR}/${IDRVHDR}	# where are the .h_v files
%endif
%if !%defined(PIFUIHDR)
PIFUIHDR= ${SOURCEDIR}/${IFUIHDR}	# where are the .h_v files
%endif
%if !%defined(PIUIHDR)
PIUIHDR	= ${SOURCEDIR}/${IUIHDR}	# where are the .h_v files
%endif
%if !%defined(PISNMPHDR)
PISNMPHDR	= ${SOURCEDIR}/${ISNMPHDR}	# where are the .h_v files
%endif
%if !%defined(PISUPPHDR)
PISUPPHDR	= ${SOURCEDIR}/${ISUPPHDR}	# where are the .h_v files
%endif
%if !%defined(PIMACHDR)
PIMACHDR	= ${SOURCEDIR}/${IMACHDR}	# where are the .h_v files
%endif
%if !%defined(PITRCUIHDR)
PITRCUIHDR	= ${SOURCEDIR}/${ITRCUIHDR}	# where are the .h_v files
%endif

ALLINCDIR = ${PIFDDIHDR} ${PIDIR1} ${PIDIR2} ${PIDIR3} ${PISMTHDR} ${PISMTIFHDR} ${PIDRVHDR} $(PIFUIHDR) ${PIUIHDR} ${PISNMPHDR} $(PISUPPHDR) $(PIMACHDR) $(PITRCUIHDR)
.LOGFILE .s_v(.s ${REV})
.LOGFILE .h_v(.h ${REV})
.LOGFILE .c_v(.c ${REV})
.LOGFILE .awv(.awk ${REV})
.LOGFILE .mav(.mak ${REV})
.LOGFILE .fdvi(.fddi ${REV})
.LOGFILE .__v(.$() ${REV})
.LIBRARY CASE .a

.SOURCE.h_v: ${PIFDDIHDR} ${PIDIR1} ${PIDIR2} ${PIDIR3} ${PISMTHDR} ${PISMTIFHDR} ${PIDRVHDR} $(PISNMPHDR) $(PIFUIHDR) $(PIUIHDR) ${SOURCEDIR} $(PISUPPHDR) $(PIMACHDR) $(PITRCUIHDR)
.SOURCE.c_v: ${SOURCEDIR}
.SOURCE.s_v: ${SOURCEDIR}
.SOURCE.awv: ${SOURCEDIR}
.SOURCE.mav: ${SOURCEDIR}/$[d,$(INPUTFILE)] ${SOURCEDIR}
.SOURCE.fdvi: ${SOURCEDIR}
.SOURCE.__v: ${SOURCEDIR}

%if ("$[d,$(INPUTFILE)]"=="")
.SOURCE = . global.mak
%else
.SOURCE = $[d,$(INPUTFILE)] global.mak
%endif

#
# Defaults to GNU/960 tool set:
#
CC	= gcc960			# gnu960 cross C compiler 
ARCH	= -ACA				# This is CA architecture
#MIBOPT  = -DRMONALARM -DRMONEVENT -DRMONHOST
MIBOPT  = -D__FEBRIDGE
OPT	= -O2 -c $(MIBOPT)  -D__FDDI_CON -DDRV_DEBUG -DSVC #-DCMT_ONLY#-DCMT_TEST -D__PCM_DEBUG #-D__MIB_DEBUG -D__CSP_DEBUG  -D__ECM_DEBUG  -D__CFM_DEBUG -D__SMT_DEBUG 
					# O3 - optimization level 3
#OPT	= -O3 -c 			# O3 - optimization level 3
					# c  - compile only
CFLAGS	= ${ARCH} -I${IFDDIHDR} -I${IDIR1} -I${IDIR2} -I${IDIR3} -I${ISMTHDR} -I${ISMTIFHDR} -I${IDRVHDR} -I$(IFUIHDR) -I$(IUIHDR) -I$(ISNMPHDR) -I$(ISUPPHDR) -I$(IMACHDR) -I$(ITRCUIHDR) -I${IDIR4} ${OPT} -I$(G960BASE)/include ${LOPT} -mstrict-align #-mic-compat 

					#
					# I - 	specify the search path for
					# 	any include files
					# mstrict-align
					#	Sequences of smaller memory
					#	reference are used instead
					#	of larger ones which might
					#	not be correctly aligned.

AS	= gas960			# gnu960 assembler
ASFLAGS	= ${ARCH}

LD	= gld960			# gnu960 loader
LFLAGS	= ${ARCH} -o ${TARG} -r 

AR	= gar960			# gnu960 archiever
ARFLAGS	= rs

#
# Essential under System V, harmless elsewhere
#
SHELL = /bin/sh

#
# Standard source code retrieval rules
#
.c_v.c:
	get ${REV} $<\($@\)`

!if !%defined(MAKEDEPENDENCY)

.h_v.h:
	get ${REV} $<\($@\)`

!else
.h_v.h:
        %foreach loop in $**
           @%set TARG_DIR = $[r, $(loop)].h
           @%set SRC_DIR = $[d, $(loop)]
           %foreach dirloop in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24
              %if "$(PVCS_ROOT)" != "$(SRC_DIR)"
                 @%set TARG_DIR = $[r, $(SRC_DIR)]/$(TARG_DIR)
                 @%set SRC_DIR  = $[d, $(SRC_DIR)]
              %endif
           %endfor
   	   get ${REV} $(loop)\($(ROOT)/$(TARG_DIR)\)
#           %do REALMAKE
        %endfor
        %do REALMAKE

!endif

.s_v.s:
	get ${REV} $<\($@\)

.awv.awk:
	get ${REV} $<\($@\)

.$().awk:
	get ${REV} $<\($@\)

.cfv.cfg:
  get $(REV) $?\($*.cfg\)
  @%echo  The makefile $*.mak has changed. Please restart MAKE to
  @%echo  ensure that the new file is used for the make.
  @make
  @%abort 0

.mav.mak:
  get $(REV) $?\($*.mak\)
  @%echo  The makefile $*.mak has changed. Please restart MAKE to
  @%echo  ensure that the new file is used for the make.
  @make
  @%abort 0

.__v.$():
  get $(REV) $?\($*\)
  @%echo  The makefile $* has changed. Please restart MAKE to
  @%echo  ensure that the new file is used for the make.
  @make
  @%abort 0

.fdvi.fddi:
  %if "$[f, "", $@, ""]"=="makefile"
     get $(REV) $?\($(ROOT)/makefile\)
     get $(REV) $?\($@\)
  %elseif "$[f, "", $@, ""]"=="global"
     get $(REV) $?\($(ROOT)/global.mak\)
     get $(REV) $?\($@\)
  %else
     get $(REV) $?\($@\)
  %endif
  @%echo  The makefile $@ has changed. Please restart MAKE to
  @%echo  ensure that the new file is used for the make.
  @make 
  @%abort 0

#
# Standard compilation and assembly rules
#

.s.o:
	${AS} ${ASFLAGS} -o $*.o $*.s

.h.o:
	get ${REV} $<\($@\)

.c.o:
	${CC} ${CFLAGS} ${LDEFS} ${SYMDBG} $*.c



