/**			       
*
*	Program Name:	telnet module
*
*	Filename:	telnet.h
*
*	$Log:   /usr/shasta/hub/trx/i960/include/telnet.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:27:44   holeman
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		4.30.90
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	The include file for telnet. 
*			Ported to nim960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


#ifndef __TELNET_H
#define	__TELNET_H
/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/
/* MOD: BLL - fields to telnet struct */

/* the telnet control structure, passed around by applications using
	the telnet library
*/


#define SBBFMAX 128
extern uint	tn_bufs;

typedef	struct telnet {
	void	*tn_tcp;	/* the telnet's TCP connection */
	void	*tn_tag;	/* user's tag */
	int	tn_nus;		/* in use status */
/* tn_nus values */
#define TN_NUS_FREE	0x01	/* no session */
#define TN_NUS_OPEN	0x02	/* session being opened */
#define TN_NUS_ACTV	0x04	/* session active */
#define TN_NUS_CLOS	0x08	/* session being closed */
#define TN_NUS_FAKE 	0x10    /* fake for closing */
#define TN_NUS_FCLOSE	0x20	/* Foreign host has indicated close */
#define TN_NUS_FCLOSED	0x40	/* Foreign host is closed */

	uint	tn_do;		/* do status flags */
	uint	tn_will;	/* will status flags */
	uint	tn_do_req;	/* negotiating do flags */
	uint	tn_will_req;	/* negotiating will flags */
	uint	tn_do_set;	/* negotiated do flags */
	uint	tn_will_set;	/* negotiated will flags */
	int	tn_mode;	/* char processing mode */
/* tn_mode flags */
#define M_IAC	1
#define M_SB	2
#define M_NEG	4
#define M_URG	8
#define M_RAW	0x10	/* raw mode- no embedded IACs */
#define M_CR	0x20  /* CR is received i as last char of the packet*/

	uint	tn_negc;	/* negotiating status */
	MBOX	tn_mbox;	/* linked list for rx packets */
	int	tn_fill;	/* next character fill index */
	int	tn_take;	/* next character take index */
	int	tn_gchrs;	/* # of valid characters in get buffer */
	byte	*tn_gbuf;	/* get buffer */
	uint	tn_sbln;	/* sub-negotiation buffer contents size */
	byte	*tn_sbbf;	/* sub-negotiation buffer */
	in_name	tn_fhst;	/* foreign host */
	int	tn_fskt;	/* foreign socket */
	int	tn_lskt;	/* local socket */
	uint	tn_pktptr;	/* packet currently being sucked */
	uint	tn_tmouts;	/* timeout counter */
	uint	tn_psid;	/* no activity countdown */
	TIMER	tn_tmr;		/* for timing opens and closes */
	uint	tn_tm2[3];	/* it is reqd to make a TIMER a timer */
	int	tn_chk;		/* for checking that this is a real telnet struct */
/* tn_chk value */
#define TN_CHECK  	0x5432	/* chk telnet marker		*/
	uint	tn_bufs;	/* size of receive buffer	*/
	byte	tn_eol;		/* end of line character	*/
	byte	tn_expand;	/* include this as part of the eof	*/
	ulong	tn_inbytes;	/* no. of bytes in for this session	*/
	ulong	tn_outbytes;	/* no. of bytes out for this session	*/
	} telnet;

/* negotiables (aka options) */
#define TN_BINARY  	0
#define TN_ECHO  	1
#define TN_SGA  	3
#define TN_STATUS  	5
#define TN_TMARK	6
#define TN_TERMTYPE	24
#define TN_SYTEK  	222

/* negotiation values */
#define TN_IAC 		255
#define TN_DONT		254	
#define TN_DO  		253	
#define TN_WONT		252	
#define TN_WILL		251	
#define TN_SB   	250
#define TN_GA  		249
#define TN_EL   	248
#define TN_EC   	247
#define TN_AYT  	246	
#define TN_AO  		245	
#define TN_INTP	    	244	
#define TN_BREAK	243	
#define TN_DM  	    	242
#define TN_SE       	240
#define TN_SYNC 	0

/* status values */
#define STA_IS  0
#define STA_SEND 1


/* tn_*_req flags */
#define F_BINARY  	0x01
#define F_ECHO  	0x02
#define F_SGA   	0x04
#define F_STATUS  	0x08
#define F_TMARK 	0x10
#define F_SYTEK  	0x20
#define F_4208		0x40
#define F_TERMTYPE	0x80
#define F_SERVER	0x8000
/* indication confirmation request response */
#define REQ 		1
#define IND 		2
#define RSP 		3
#define CNF 		4

/* protocol stack IDs */
#define PS_TCP_DIRECT 	0 
#define PS_TCPIP	1
#define PS_LAT		2
#define PS_V2       	3
#define PS_RLOGIN   	4
#define PS_SNMP     	5
#define PS_ALL		16	/* This is just to specify all the protocols */	

extern	uint	ltnsz;
extern	telnet	*tne,*tns;
extern	void tn_up_timer();

/* telnet entry points */
int tn_listen(telnet **, in_name, uint, uint);
int tn_close(telnet *, int);
int tn_abort(telnet *);
int tn_getc(telnet *);
int tn_event(telnet *, int, int);
int tn_option(telnet *, uint, uint, uint);
#endif
