/**
 *	Program Name:	nim960 program
 *
 *	Filename:	tcpip.h
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/tcpip.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:27:42   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include "lme.h"

#ifndef	__TCPIP_H
#define	__TCPIP_H

/*
 *	Transmit and receive buffer sizes
 */
/*#define	TRANSMIT_BUF_LEN	576	/* for ethernet	*/
/*#define	TRANSMIT_BUF_LEN1	1024	/* for slip	*/
#define	RECEIVE_BUF_LEN		1518

/* structure for initializing telnet, tcp, ip */
typedef struct tcpip
	{
	/* set by user, may not be changed after init */
	int	numtcps;	/* number telnet connections to support */
	int	numudps;	/* number UDPs to support */
	int	tn_bufs;	/* telnet buffer size */
	int	tn_maxw;	/* telnet max window */
	int	tn_minw;	/* telnet min window */

	/* set by user, may be changed at any time */
	in_name	fltr_mask;	/* bits to be matched */
	in_name fltr_val;	/* value on above bits */
	char	*dm_myname;  	/* my domain name */
	in_name	dm_server;  	/* my domain server's IP address */
	in_name dm_2nd_srv;	/* Secondary Domain name Server */
	in_name in_me;  	/* myself.  me.  I. */
	in_name net_mask;	/* mask defining 'this net' */
	in_name net_gway;  	/* default router gateway */
	in_name net_gway2;	/* secondary router */

	/* set by tcp/ip telnet */
	int	inited;	/* is done */
	NID	whoami;	/* ethernet ID */
	int	numfree;	/* number free packets */
	int	tlenfree;	/* Transmit Buffer length */
	int	rlenfree;	/* Receive buffer length */
	int	version;	/* version number */
	int	ssspare;	/* spare 	*/

	/*	Admin bus support	*/
	int	relayer;	/* am I the relayer	*/
	in_name	syscard;	/* ip of syscard	*/

	/* set by tcp/ip: LME structures */
	int	ifNumber;	/* how many network interfaces are there */
	IF_ENTRY	*ifcntr;	/* LME for TCP/IP: IF cntrs */
	IP_STAT		*ipcntr;	/* LME for TCP/IP: IP cntrs */
	IP_THRESHOLD	*ipalrm;	/* LME for TCP/IP: IP alarms */
	IP_ENTRY	*ipstat;	/* LME for TCP/IP: IP stats */
	TCP_STAT	*tcpcntr;	/* LME for TCP/IP: TCP cntrs */
	TCP_THRESHOLD	*tcpalrm;	/* LME for TCP/IP: TCP alarms */
	TCP_CON_ENTRY	*tcpstat;	/* LME for TCP/IP: TCP con stats */
	} tcpip;

typedef struct rttable{
        in_name	host;
	long	metric;
	int	timeout;
	}RTTBL;

extern tcpip *_initp;
extern RTTBL rttbl[];

/* other tcp/ip entry points */
int resolve_name();
int prs_ip_addr();
int icmp_ping();
int icmp_ping_abort();
int icmp_destun();
int udp_send();

#endif
