/**			       
*
*	Program Name:	makebm		- make a bridge module file
*
*	Filename:	nim960h.h
*
*	$Log:   /usr/shasta/pvcs/i960/include/nim960h.h_v  $
 * 
 *    Rev 1.3   25 Sep 1992 09:56:30   holeman
 * 
 *    Rev 1.2   10 Sep 1992 10:58:38   holeman
 * 
 *    Rev 1.1   09 Sep 1992 16:30:12   holeman
 * 
 *    Rev 1.0   01 Jul 1992 14:27:26   holeman
 * Initial revision.
*
*	Creation Date:	2.4.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	The Bridge moudle header information.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#define	NIM960_MAGIC	0x5566		/* signature for the bridge	*/

#define	TRC_PROGRAM_ID	0x3		/* program identifer for the trc */
#define	FDDI_PROGRAM_ID	0x4		/* program identifer for the fddi */


/*
 *	This header must be the first data in 
 *	text.  A utility will be provided to fill in the
 *	signature, calculate the CheckSum and copy information
 *	from the b.out header to this header.
 */
struct nim960_header
	{
	unsigned short	signature;	/* Header marker	*/
	unsigned short	CheckSum;	/* for the whole file	*/
	unsigned long	FileLength; 	/* this header + image	*/
	unsigned long	time;		/* time of creation (unix style) */
	unsigned long	TextLength;	/* length of text	*/
	unsigned long	DataLength;	/* length of data	*/
	unsigned long	BssLength;	/* bss length		*/
	unsigned long	Entry;		/* run time start address	*/
	unsigned long	TextLoadAddress;/* text run time load address	*/
	unsigned long	DataLoadAddress;/* data run time load address	*/
	unsigned long	ProgramId;
	unsigned char	version[8];	/* i.e.	"1.00A"		*/
	char	name[32];		/* Program name		*/
	char	CopyRightMessage[256];	/* notice		*/
	};
	
typedef	struct nim960_header	NIM960_HDR;

#define	NIM960_HDR_SIZE	sizeof(NIM960_HDR)
