/**
 *	Program Name:	nim960 program
 *
 *	Filename:	mtcp.h
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/mtcp.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:27:20   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
/*
Copyright (C) 1986 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.

Edit history
11-Jan-87	jbvb	Fixed a missing parenthesis in the SEQ_GE macro
*/

/*  Copyright 1983 by the Massachusetts Institute of Technology  */

#ifndef	__MTCP_H
#define	__MTCP_H

typedef	unsigned long	seq_t;			/* sequence numbers */

union	seq_no
		{
		seq_t	a;
		struct	
			{
			ushort   l;
			ushort   h;
			} p;
		};

struct	tcp
	{				/* a tcp header */
	ushort	tc_srcp;		/* source port */
	ushort	tc_dstp;		/* dest port */
	seq_t	tc_seq;			/* sequence number */
	seq_t	tc_ack;			/* acknowledgement number */
	byte	tc_thl;			/* thl bits */
	byte	tc_flags;		/* All the flags */
/********************************
	ushort	tc_uu1 : 4;		* unused *
	ushort	tc_thl : 4;		* tcp header length *
	ushort	tc_fin : 1;		* fin bit *
	ushort	tc_syn : 1;		* syn bit *
	ushort	tc_rst : 1;		* reset bit *
	ushort	tc_psh : 1;		* push bit *
	ushort	tc_fack : 1;		* ack valid *
	ushort	tc_furg : 1;		* urgent ptr. valid *
	ushort	tc_uu2 : 2;		* unused *
********************/
	ushort	tc_win;			/* window */
	ushort	tc_cksum;		/* checksum */
	ushort	tc_urg;			/* urgent pointer */
	};

#define	THL_SHIFT	4
#define THL_BIT		0xf0
#define SYN_BIT		0x02
#define FIN_BIT		0x01
#define RST_BIT		0x04
#define PSH_BIT		0x08
#define ACK_BIT		0x10
#define URG_BIT		0x20

/*
 *	TCP header size (UNPADDED).
 *	Note: sizeof (stuct tcp) may not be 20 due to the
 *	alignment in i960.
 */
#define	TCP_SIZE	20

/* TCP psuedo-header structure, used for checksumming */
struct	tcpph	{			/* psuedo-header */
	in_name	tp_src;			/* source addr */
	in_name	tp_dst;			/* dest addr */
	char	tp_zero;		/* always 0 */
	char	tp_pro;			/* protocol */
	ushort	tp_len;			/* length */
	};
/*
 *	The tcp pseudo header size.
 *	Note: sizeof (struct tcpph) will give 16 by default
 *	for proper alignment in i960 environment.
 */
#define	TCPPH_SIZE	12

#define	SEQ_GT(a, b)	((((long) a) - ((long) b)) > 0L)
#define	SEQ_GE(a, b)	((((long) a) - ((long) b)) >= 0L)
#define	SEQ_EQ(a, b)	((a) == (b))
#define	SEQ_NE(a, b)	((a) != (b))
#define	SEQ_LE(a, b)	((((long) a) - ((long) b)) <= 0L)
#define	SEQ_LT(a, b)	((((long) a) - ((long) b)) < 0L)


#define	TCPPROT		6		/* tcp protocol number */
#define TCPMAXWIND	4096		/* maximum tcp window that this 
					   implemnetation supports */
#define NOT_YET(a, b)	((a) < (b))

#endif
