#ifndef __EEPROM_H
#define __EEPROM_H

#ifndef __TYPES_H
#include <types.h>
#endif

#define	EEPROM_SIZE	8192

#define MAX_EEPROM_RECS	14
#define EEP_PAGE_SIZE	32
#define EEP_MAX_PAGES	32
#define EEP_MARKER	0x6C6B

/* Note: All eeprom records should be 32 byte aligned.  */
/*       All eeprom records end with the checksum field.*/
/*       eep_dirty and eep_bitmap are present only in   */
/*       the dram copies of the eeprom records.         */

/* eep_hdr structure contains information about the     */
/* number of Eeprom records and the size of each record */
/* as a multiple of pages                               */

typedef struct eep_hdr
	{
		u_short	eep_marker;
		struct	eep_recs
		{
			u_short	offset;
			u_short	size;
		} eep_recs[MAX_EEPROM_RECS];
		u_short	eep_checksum;	/* eeprom record ends here */
	} EEP_HDR;


#define EEP_HDR_ADDR	0 
#define EEP_HDR_SIZE ALIGN(sizeof(EEP_HDR), EEP_PAGE_SIZE)

/*	EEPROM error definitions 	*/

#define EEP_OK	0	/* No error */
#define EEPROM_AOK	0	/* No error */
#define EEPROM_ALNERR	1	/* the offset or the size is odd */
#define EEPROM_NOSUCH	2	/* The block is not defined in the header */
#define EEPROM_CSERR	3	/* Checksum error */
#define EEPROM_NOSPACE	4
#define EEPROM_BADSIZE	5
#define	EEPROM_BADMARKER	6	/* bad marker error	*/

extern	EEP_HDR	Eeprom_header;

#endif /* __EEPROM_H */
