/*--------- Media Type --------*/
#define MEDIA_TYPE_TRC          1
#define MEDIA_TYPE_FDDICON      2

/*--------- Device Type -------*/
#define DEVICE_TYPE_TRC         1
#define DEVICE_TYPE_FDDICON     2

/*--------- Media Speed -------*/
#define MEDIA_SPEED_TRC_4M      0
#define MEDIA_SPEED_TRC_16M     1
#define MEDIA_SPEED_FDDICON     2

/*--------- others ------------*/
#define BRIP_INIT_STATE		1
#define BRIP_INSERTED_STATE	2
#define BRIP_MAJOR_VER		1
#define BRIP_MINOR_VER		0
#define	MAX_MAC_CHANNEL		1
#define	MAX_XMT_LINE		22	
#define MAX_INS_TIMEOUT		1000	/* 10 seconds	*/
#define MAX_RSP_TIMEOUT		500	/*  5 seconds	*/
#define MAX_KA_TIMEOUT		200	/*  2 seconds	*/
#define MAX_RETRY_TIMEOUT	100	/*  1 second	*/
#define MAX_REQ_RETRY		3	
#define MAX_KA_COUNT		3	
#define MAX_NEIGHBOR_ERR	5

#define REQ_FRAME_SIZE		17
#define RSP_FRAME_SIZE		16
#define RMV_FRAME_SIZE		16
#define INS_FRAME_SIZE		16
#define KA_FRAME_SIZE		16

#define BRIP_FRAME_TYPE		1
#define REQ_RING_MEMBER		11
#define RSP_RING_MEMBER		12
#define RMV_RING_MEMBER		13
#define INS_RING_MEMBER		14
#define KEEP_ALIVE		15

#define TR_16M			1

#ifdef __FDDI_CON
/* Events for the State Machine */
#define EVENT_INSERT_A      1
#define EVENT_ISOLATE_A     2
#define EVENT_INSERT_B      3
#define EVENT_ISOLATE_B     4
#define EVENT_ISOLATE_AB    5
#define XMT_QUIET_LINE		24
#endif
/*----------------------------------------------------------------------------
 * type definition for common fields of all BRIP frames.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;	/* destination slot	*/
        byte            crtl;		/* used by SCC only	*/
        byte            src_slot;	/* source slot		*/
        byte            frame_type_hi;	/* frame type hi byte 	*/
        byte            frame_type_lo;  /* frame type lo byte	*/
        byte            version_major;	/* major version no.	*/
        byte            version_minor;	/* minor version no.	*/
        byte            dst_line;	/* dest. tramsmit line	*/
        byte            src_line;	/* src. transmit line	*/
        byte            hub_ring;	/* hub ring no.		*/
        byte            media_type;	/* media type (TR/FDDI)	*/
        byte            media_speed;	/* media speed (4/16)	*/
        byte            hw_type;	/* hw type (brg/conc)	*/

} BRIP_FRAME;

/*----------------------------------------------------------------------------
 * type definition for fields of REQ_MEMBER_FRAME frame.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;
        byte            crtl;
        byte            src_slot;
        byte            frame_type_hi;
        byte            frame_type_lo;
        byte            version_major;
        byte            version_minor;
        byte            dst_line;
        byte            src_line;
        byte            hub_ring;
        byte            media_type;
        byte            media_speed;
        byte            hw_type;
	byte		rsp_bmap[4];	/* response bit map	*/

} REQ_FRAME;

/*----------------------------------------------------------------------------
 * type definition for fields of RSP_MEMBER_FRAME frame.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;
        byte            crtl;
        byte            src_slot;
        byte            frame_type_hi;
        byte            frame_type_lo;
        byte            version_major;
        byte            version_minor;
        byte            dst_line;
        byte            src_line;
        byte            hub_ring;
        byte            media_type;
        byte            media_speed;
        byte            hw_type;
	byte		state;		/* BRIP state of sender	*/

} RSP_FRAME;

/*----------------------------------------------------------------------------
 * type definition for fields of INS_MEMBER_FRAME frame.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;
        byte            crtl;
        byte            src_slot;
        byte            frame_type_hi;
        byte            frame_type_lo;
        byte            version_major;
        byte            version_minor;
        byte            dst_line;
        byte            src_line;
        byte            hub_ring;
        byte            media_type;
        byte            media_speed;
        byte            hw_type;
	byte		usn_line;	/* up stream tx line	*/
	byte		dsn_line;	/* down stream tx line	*/

} INS_FRAME;

/*----------------------------------------------------------------------------
 * type definition for fields of KEEP_ALIVE_FRAME frame.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;
        byte            crtl;
        byte            src_slot;
        byte            frame_type_hi;
        byte            frame_type_lo;
        byte            version_major;
        byte            version_minor;
        byte            dst_line;
        byte            src_line;
        byte            hub_ring;
        byte            media_type;
        byte            media_speed;
        byte            hw_type;
	byte		usn_line;	/* up stream tx line	*/
	byte		dsn_line;	/* down stream tx line	*/

} KA_FRAME;

/*----------------------------------------------------------------------------
 * type definition for fields of RMV_MEMBER_FRAME frame.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte            dst_slot;
        byte            crtl;
        byte            src_slot;
        byte            frame_type_hi;
        byte            frame_type_lo;
        byte            version_major;
        byte            version_minor;
        byte            dst_line;
        byte            src_line;
        byte            hub_ring;
        byte            media_type;
        byte            media_speed;
        byte            hw_type;
	byte		usn_line;	/* up stream tx line	*/
	byte		dsn_line;	/* down stream tx line	*/

} RMV_FRAME;


/*----------------------------------------------------------------------------
 * type definition for BRIP_INFO.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        byte	state;			/* BRIP protocol state	*/
        byte	device_type;		/* hardware type	*/
        byte	media_type;		/* media type		*/
        byte	media_speed;		/* media speed		*/
        byte    hub_ring_nbr;		/* hub ring no.		*/
        byte    xmt_line_nbr;		/* xmt line no.		*/
        byte    usn_line_nbr;		/* up stream line no.	*/
        byte    dsn_line_nbr;		/* down stream line no.	*/
        word    rcv_req_count;		/* count REQ frames seen*/
        word    rcv_rsp_count;		/* count RSP frames seen*/
        word    rcv_rmv_count;		/* count RMV frames seen*/
        word    rcv_ins_count;		/* count INS frames seen*/
        word    rcv_ka_count;		/* count KA  frames seen*/
        word    rcv_unknown_count;	/* count unknown frames */
        word    rcv_byte_count;		/* count bytes received */
        word    xmt_req_count;		/* count REQ frames sent*/
        word    xmt_rsp_count;		/* count RSP frames sent*/
        word    xmt_rmv_count;		/* count RMV frames sent*/
        word    xmt_ins_count;		/* count INS frames sent*/
        word    xmt_ka_count;		/* count KA  frames sent*/
        word    xmt_byte_count;		/* count bytes sent	*/
        word    xmt_req_retries;	/* count xmt retries	*/
        word    xmt_failure;		/* count xmt failures	*/
        word	send_ka_flag;
} BRIP_INFO;

/*----------------------------------------------------------------------------
 * type definition for BRIP_TIMER_INFO.
 *----------------------------------------------------------------------------
 */
typedef struct
{
        TIMER   tmr;
        short   channel;
        byte    line;
} BRIP_TIMER_INFO;

void	init_brip( short );
void	init_brip_timer( void );
void	init_ka_timer( void );
void	insert_hub_ring( short, byte );
void	brip_rcv_task( void );
void	receive_req_frame( short, REQ_FRAME *);
void	receive_rsp_frame( short, RSP_FRAME *);
void	receive_rmv_frame( short, RMV_FRAME *);
void	receive_ins_frame( short, INS_FRAME *);
void	receive_ka_frame( short, KA_FRAME *);
void	send_req_frame( short, byte, byte );
void	send_rsp_frame( short, byte, byte );
void	send_rmv_frame( short, byte, byte );
void	send_ins_frame( short, byte, byte );
void	send_ka_frame( short, byte, byte );
void	send_test_frame( short, byte, byte );
void	switch_rcv_line( short, byte );

void	receive_ins_timeout( BRIP_TIMER_INFO *);
void	receive_rsp_timeout( int );
void	ka_monitor( int );
void	send_req_retry( int );

int	IsRspNeeded( short, word *);
byte	get_xmt_line( void );
