#include <memory.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include "fddihdr.h"
#include "smtmacro.h"
#include "mibtypes.h"
#include "mibdefs.h"
#include "mibglbl.h"
#include "edfddinvr.h"

NVR_FDDI nvr_fddi_rec;
NVR_ALARM   nvr_alarms;
NVR_EVENT   nvr_events;
NVR_PORT_LOCK nvr_plock;
NVR_PORT_INIT nvr_port_init;

char *FDDIPath[CT_PATH]
             = { "Primary", "Secondary", "Local", "Isolated" };

char *FDDIPathAvail[CT_PATH_AVAIL]
             = { "Primary", "Secondary", "Primary-Secondary", "Local",
		 "Primary-Local", "Secondary-Local", 
		 "Primary-Secondary-Local" };

char *SMTConfigCapability[CT_SMTCONFIG_CAPABILITY]
             = { "None", "Hold Available", "CF-Wrap-AB",
		 "Hold Available & CF-Wrap-AB" };

char *PortFotx[CT_PORT_FOTX]
             = { "MultiMode", "Single-Mode1", "Single-Mode2",
		 "SONET" };


extern int NumberOfPorts;
extern SetMyNids();
byte nvr_fddi_dirty;
char config_buffer[TEMP_BUF_SIZE];



InitPortRec(nvrPort)
NVR_PORT *nvrPort;
{
}

byte tr_broadcast[]={0xc0, 0x00, 0xff, 0xff, 0xff, 0xff};

int IsConsolePort()
{
}

GetPortRec(PortRec)
NVR_PORT *PortRec;
{
}

#include "smttypes.h"
#include "smtmsg.h"

print_tms_counts()
{
}

print_tms_info()
{
}


/* end of Dummy Functions and Variables */

/************************************************************/

int QueryMenuItem(char* prompt, int MinItem, int MaxItem)

	{
	int	item;		/* which item has been chosen	*/
	int	argc;		/* how many arguments have the user entered */
	char	c;		/* dummy for syntax checking	*/

        if ((MinItem | MaxItem))
	{
	   if (MinItem != MaxItem)
	   {
	      printf("%s (%d - %d) ===>", prompt, MinItem, MaxItem);
           }
           else
           {
              printf("%s (only %d) ===>", prompt, MinItem);
           }
        }
	else
	{
           printf("\n\t\tPlease press <CR> to continue or 1 to quit.");
	   gets(config_buffer);
	   argc = sscanf(config_buffer, "%d%c", &item, &c);
	   if ((argc!=0) && (item==1))
	   {
	      printf("\n");
	      return item;
	   }
	   return -1;
	}

	gets(config_buffer);
	argc = sscanf(config_buffer, "%d%c", &item, &c);
	if ((argc == 0) || (!item))
	{
	   printf("\n");
	   return 0;
	}

	if ((argc !=1) || (item > MaxItem) || (item < MinItem))
		{
		/*
		 *	syntax error
		 */
		printf("\nItem number entered is out of range.\n");
		return -1;
		}
	return item;
	}

int QueryMenu(uChar totalMenu, char**displayMenu, char *prompt)
{
   uChar i, ChoiceNotUsed[sizeof(uChar)];
   int item;

   for (i=0; i < totalMenu; i++)
   {
      if (*displayMenu[i])
      {
	 ChoiceNotUsed[i] = FALSE;
	 printf("%2d) %s.\n", (i+1), displayMenu[i]);
      }
      else
      {
	 ChoiceNotUsed[i] = TRUE;
      }
   }

   item=QueryMenuItem(prompt, 1, totalMenu);

   if ((item > 0) && (ChoiceNotUsed[item-1]))
   {
      printf("The number entered is not correct.\n");
      return -1;
   }

   return item;
}

unsigned QueryUnsigned(char *prompt, unsigned DefaultValue,
		     unsigned MinValue, unsigned MaxValue)

	{
	char	c; 	/* dummy for check user input	*/
	unsigned	value;
	char	buffer[80];
	int	argc;

        if ( !MaxValue )
	{
	   MaxValue = 0xffffffff;
	}

	if (MinValue < MaxValue)
	{
	   printf("%s (%d - %d)\n(%d) ===>", prompt, MinValue, MaxValue,
		  DefaultValue);
	}
        else
        {
           printf("Range Given Error.\n");
	   return DefaultValue;
        }

	for (;;)
	{
	   gets(buffer);
	   if ((argc = sscanf(buffer, "%d%c", &value, &c)) == 1)
	   {
	      if ((buffer[0] != '-') 
		  && (value <= MaxValue) 
		  && (value >= MinValue))
	      {
		 nvr_fddi_dirty = TRUE;
		 break;
	      }
	      else
	      {
		 printf("\nThe value you input is out of range.\n"
			"Please input the value again.\n\n");
		 printf("%s (%d - %d)\n(%d) ===>", prompt, MinValue, MaxValue,
		        DefaultValue);
		 continue;
	      }
	   }
	   else if ((argc == 0) || (buffer[0] == '\0'))
	   {
/*	      printf("Value is not changed.\n"); */
	      value = DefaultValue;
              break;
	   }
	 }
	 return value;
      }


unsigned QueryUnsignedHex(char *prompt, unsigned DefaultValue,
			  unsigned MinValue, unsigned MaxValue)

	{
	char	c; 	/* dummy for check user input	*/
	unsigned	value;
	char	buffer[80];
	int	argc;

        if ( !MaxValue )
	{
	   MaxValue = 0xffffffff;
	}

	if (MinValue < MaxValue)
	{
	   printf("%s (0x%x - 0x%x)\n(0x%x) ===>", prompt, MinValue, MaxValue,
		  DefaultValue);
	}
        else
        {
           printf("Range Given Error.\n");
	   return DefaultValue;
        }

	for (;;)
	{
	   gets(buffer);
	   if ((argc = sscanf(buffer, "%x%c", &value, &c)) == 1)
	   {
	      if ((buffer[0] != '-') 
		  && (value <= MaxValue) 
		  && (value >= MinValue))
	      {
		 nvr_fddi_dirty = TRUE;
		 break;
	      }
	      else
	      {
		 printf("\nThe value you input is out of range.\n"
			"Please input the value again.\n\n");
		 printf("%s (0x%x - 0x%x)\n(0x%x) ===>", prompt, MinValue, MaxValue,
		        DefaultValue);
		 continue;
	      }
	   }
	   else if ((argc == 0) || (buffer[0] == '\0'))
	   {
/*	      printf("Value is not changed.\n"); */
	      value = DefaultValue;
              break;
	   }
	 }
	 return value;
      }


void setNVRAM_FDDIDefaults ( FddiRec )
NVR_FDDI *FddiRec;
{
   uByte i, j, mask, nonMaster_Ct, master_Ct, mac_Ct;

   nonMaster_Ct = eep_mfg_rec.eep_fddi.smtNonmaster_Ct;
   master_Ct    = eep_mfg_rec.eep_fddi.smtMaster_Ct;
   mac_Ct       = eep_mfg_rec.eep_fddi.smtMac_Ct;

   /*
    *  FDDI SMT
    *
    *    fddiSMTStationIdGrp
    */

   NVR_FDDI_SMT.opVersionID = SMTOPVERSION;			/* mibdefs.h */
   NVR_FDDI_SMT.hiVersionID = SMTHIVERSION;			/* mibdefs.h */
#if 0
   MEMCOPY(NVR_FDDI_SMT.stationID.IEEEAddress, MYMANUFOUI,
	   sizeof(MYMANUFOUI)-1);                               /* mibconf.h */
   NVR_FDDI_SMT.stationID.IEEEAddress[3] = 0;
   NVR_FDDI_SMT.stationID.IEEEAddress[4] = 0;
   NVR_FDDI_SMT.stationID.IEEEAddress[5] = 0;
#else
   MCopyAddress(NVR_FDDI_SMT.stationID.IEEEAddress, MyNid(2));
   swap_bits(NVR_FDDI_SMT.stationID.IEEEAddress, 
	     sizeof(NVR_FDDI_SMT.stationID.IEEEAddress));
#endif   
   MEMCOPY(NVR_FDDI_SMT.manufacturerData.OUI, MYMANUFOUI, 
	   sizeof(MYMANUFOUI)-1);			        /* mibconf.h */

   memset(NVR_FDDI_SMT.manufacturerData.data, '.',
	   sizeof(NVR_FDDI_SMT.manufacturerData.data));
   MEMCOPY(NVR_FDDI_SMT.manufacturerData.data, MYMANUFDATA,
	   sizeof(MYMANUFDATA)-1);    	/* mibconf.h */

   memset(NVR_FDDI_SMT.userData, '.', sizeof(NVR_FDDI_SMT.userData));
   MEMCOPY(NVR_FDDI_SMT.userData, MYUSERDATA,
	   sizeof(MYUSERDATA)-1);			/* mibconf.h */

   /*
        fddiSMTStationConfigGrp
   */
   NVR_FDDI_SMT.configPolicy = Config_None;		/* fddihdr.h */
   NVR_FDDI_SMT.connectionPolicy = SMT_CONNECTION_POLICY;
   NVR_FDDI_SMT.reportLimit = DEFAULT_REPORT_LIMIT;	/* SMT default value */
   NVR_FDDI_SMT.T_Notify = T_Notify_Default;			/* fddihdr.h */

   /*
    *  FDDI MAC
    */
   for (i=0; i < mac_Ct; i++)
   {
      NVR_FDDI_MAC[i].T_MaxGreatestLowerBound = -MUsecs2Fddi(
	MAX(MIN(MFddi2Usecs(-DEFAULT_TMAX_LOWERBOUND), T_MAX_MAX), T_MAX_MIN(MFddi2Usecs(-DEFAULT_TVX))));/* mibconf.h */
      NVR_FDDI_MAC[i].TVXGreatestLowerBound = -MUsecs2Fddi(
	MAX(MIN(MFddi2Usecs(-DEFAULT_TVX_LOWERBOUND), TVX_MAX), TVX_MIN));   /* mibconf.h */
      NVR_FDDI_MAC[i].T_Req = -MUsecs2Fddi(
	MIN(MFddi2Usecs(-DEFAULT_TREQ), T_REQ_MAX(MFddi2Usecs(-DEFAULT_TVX))));   	/* mibconf.h */
      NVR_FDDI_MAC[i].T_Max = -MUsecs2Fddi(
	 MAX(MIN(MFddi2Usecs(-DEFAULT_TMAX),
		 MFddi2Usecs(-NVR_FDDI_MAC[i].T_MaxGreatestLowerBound)), 
	     T_MAX_MIN(MFddi2Usecs(-DEFAULT_TVX))));	/* mibconf.h */
      NVR_FDDI_MAC[i].TVXValue = -MUsecs2Fddi(
	 MAX(MIN(MFddi2Usecs(-DEFAULT_TVX), 
		 MFddi2Usecs(-NVR_FDDI_MAC[i].TVXGreatestLowerBound)), 
	     TVX_MIN));	/* mibconf.h */
      NVR_FDDI_MAC[i].T_Min = -MUsecs2Fddi(
	 MIN(MFddi2Usecs(-DEFAULT_TMIN), T_MIN_MAX));	/* mibconf.h */
      NVR_FDDI_MAC[i].FrameErrorThreshold = DEF_FRAME_ERROR_THRESHOLD;
      NVR_FDDI_MAC[i].NotCopiedThreshold = DEF_NOT_COPIED_THRESHOLD;
      NVR_FDDI_MAC[i].T_Pri[0] = DEFAULT_TPRI0;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[1] = DEFAULT_TPRI1;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[2] = DEFAULT_TPRI2;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[3] = DEFAULT_TPRI3;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[4] = DEFAULT_TPRI4;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[5] = DEFAULT_TPRI5;			/* mibconf.h */
      NVR_FDDI_MAC[i].T_Pri[6] = DEFAULT_TPRI6;			/* mibconf.h */
      NVR_FDDI_MAC[i].frameStatus = FSC_Type0;			/* fddihdr.h */
      switch (i)
      {
         case PRIMARY_MAC:
            NVR_FDDI_MAC[i].pathRequested = PA_PRIMARY;		/* fddihdr.h */
            MCopyAddress(NVR_FDDI_MAC[i].SMTAddress, MyNid(0));
	    break;
         case SECONDARY_MAC:
            NVR_FDDI_MAC[i].pathRequested = PA_SECONDARY;	/* fddihdr.h */
            MCopyAddress(NVR_FDDI_MAC[i].SMTAddress, MyNid(1));
	    break;
         default:
            NVR_FDDI_MAC[i].pathRequested = PA_UNKNOWN;		/* fddihdr.h */
      }

      swap_bits(NVR_FDDI_MAC[i].SMTAddress, 
		sizeof(NVR_FDDI_MAC[i].SMTAddress));

      /*
       *  XDI
       */
      NVR_FDDI_MAC[i].xdiRMTDupPolicy1 = RMT_DUP_JAM_A;   	/* fddihdr.h */
      NVR_FDDI_MAC[i].xdiRMTDupPolicy2 = RMT_DUP_JAM_B;		/* fddihdr.h */
      NVR_FDDI_MAC[i].xdiOperational   = SET;
   }/* for FDDI MAC */

   /*
    *  FDDI PATH
    */
   for (i=0, mask=1; (i < MAX_PATH_COUNT) ; i++, mask<<=1)
   {
      NVR_FDDI_PATH[i].TVXLowerBound = NVR_FDDI_MAC[i].TVXGreatestLowerBound;	/* mibconf.h */
      NVR_FDDI_PATH[i].T_MAXLowerBound = NVR_FDDI_MAC[i].T_MaxGreatestLowerBound;/* mibconf.h */
      NVR_FDDI_PATH[i].T_Rmode = 0L;	/* It's not supported */
      NVR_FDDI_PATH[i].Trace_MaxExpiration = -MUsecs2Fddi (Trace_Max_Default);
   }/* for FDDI PATH */

   /*
    *  FDDI PORT and ATTACHMENT
    */
   for (i=0; (i < (nonMaster_Ct+master_Ct)); i++)
   {
      NVR_FDDI_PORT[i].connectionPolicies = PC_MAC_None;
      NVR_FDDI_PORT[i].connectionPolicies = PC_MAC_None;
      NVR_FDDI_PORT[i].MACLoop_Time = MUsecs2Fddi (T_Next_9);	/* fddihdr.h & smtmacro.h */
      NVR_FDDI_PORT[i].LER_Cutoff = 
#if 0
	             (i <= PHY_B)? LER_MIN : DEFAULT_LER_CUTOFF;
#else
                     DEFAULT_LER_CUTOFF;
#endif
      NVR_FDDI_PORT[i].LER_Alarm = DEFAULT_LER_ALARM;
      NVR_FDDI_PORT[i].TB_Max = -MUsecs2Fddi (TB_Max_Default);

      if (i < nonMaster_Ct) 
      {
	 
	 NVR_FDDI_ATTACHMENT[i].opticalBypassPresent = SET;
         if (nonMaster_Ct == 1)
	 {
            NVR_FDDI_PORT[i].pathRequested = PA_PRIMARY;
            NVR_FDDI_PORT[i].PC_Type = PC_Type_S;		/* fddihdr.h */
	 }
	 else
         {
	    NVR_FDDI_PORT[i].pathRequested = PA_PRIMARY;
	    if (i)
	    {
               NVR_FDDI_PORT[i].PC_Type = PC_Type_B;
            }
	    else
	    {
               NVR_FDDI_PORT[i].PC_Type = PC_Type_A;;
	    }
	 }
      }
      else
      {
	 NVR_FDDI_ATTACHMENT[i].opticalBypassPresent = CLEAR;
         NVR_FDDI_PORT[i].pathRequested = PA_PRIMARY;
         NVR_FDDI_PORT[i].PC_Type = PC_Type_M;
      }
      /*************
         XDI
      */
      NVR_FDDI_PORT[i].xdiOperational = SET;
   }/* for FDDI PORT and ATTACHMENT */
   /*************
      XDI
   */
   NVR_FDDI_SMT.xdiBothWrapPolicy = SET;

   /*************
      UI
   */
#if 0
   FddiRec->UI_Defaults.Port1_PC_Type = PC_Type_A;
   FddiRec->UI_Defaults.Port6_PC_Type = PC_Type_B;
#else
#ifndef __FEBRIDGE
   FddiRec->UI_Defaults.Port1_PC_Type = PC_Type_M;
   FddiRec->UI_Defaults.Port6_PC_Type = PC_Type_M;
#endif
#endif

#ifdef __FEBRIDGE
   FddiRec->UI_Defaults.Port1_PC_Type = 0; /* Port A FRONT */
   FddiRec->UI_Defaults.Port6_PC_Type = 1; /* Port B FRONT */
#endif

}


/************************************************************/
void SetEEP_FDDIDefaults ( void )
{
   uByte i, mask, nonMaster_Ct, master_Ct, mac_Ct;

   /*************
      FDDI SMT
   */
   eep_mfg_rec.eep_fddi.smtMac_Ct = mac_Ct = FDDI_MAC_CT;
   eep_mfg_rec.eep_fddi.smtNonmaster_Ct = nonMaster_Ct = FDDI_NONMASTER_CT;
   eep_mfg_rec.eep_fddi.smtMaster_Ct = master_Ct = FDDI_MASTER_CT;
   eep_mfg_rec.eep_ports = FDDI_NONMASTER_CT + FDDI_MASTER_CT;
   eep_mfg_rec.eep_fddi.smtPathAvailable = (PA_PRIMARY | PA_SECONDARY);	/* fddihdr.h */
   eep_mfg_rec.eep_fddi.smtConfigCapabilities = (Config_Hold_Available 
				    | Config_CF_Wrap_AB); 	/* fddihdr.h */
   eep_mfg_rec.eep_fddi.smtStatusReporting = TRUE;		/* 1 if SRP is supported */

   /*************
      FDDI MAC
   */
   for (i=0; i < mac_Ct; i++)
   {
      eep_mfg_rec.eep_fddi.macFrameStatusCapabilities[i] = 
        ( FSC_Type0 );/* fddihdr.h */

      eep_mfg_rec.eep_fddi.macBridgeFunction[i] = Bridge_None;		/* fddihdr.h */
      eep_mfg_rec.eep_fddi.macPathAvailable[i] = (i==PRIMARY_MAC) ? 
	                                    PA_PRIMARY : PA_SECONDARY;/* fddihdr.h */
   }/* for FDDI MAC */

   /*************
     FDDI PATH
   */
   for (i=0, mask=1; (i < MAX_PATH_COUNT) ; i++, mask<<=1)
   {
      if (eep_mfg_rec.eep_fddi.smtPathAvailable & mask)
      {
         eep_mfg_rec.eep_fddi.pathPortOrder[i] = Path_Order_Ascending;	/* fddihdr.h */
         eep_mfg_rec.eep_fddi.pathType[i] = (PA_PRIMARY | PA_SECONDARY);/* fddihdr.h */
      }
   }/* for FDDI PATH */

   /*************************
      FDDI PORT and ATTACHMENT
   */
   for (i=0; (i < (nonMaster_Ct+master_Ct)); i++)
   {
      if (i >= nonMaster_Ct)
      {
	 eep_mfg_rec.eep_fddi.portAvailPath[i] = (PA_PRIMARY | PA_SECONDARY);/* fddihdr.h */
      }
      else
      {
	 eep_mfg_rec.eep_fddi.portAvailPath[i] = (i==PHY_A) ? 
	   PA_PRIMARY : PA_SECONDARY;/* fddihdr.h */
      }

      eep_mfg_rec.eep_fddi.portFotxClass[i] = FOTX_Multimode;	/* fddihdr.h */

      if (i < nonMaster_Ct) 
      {
	 
         if (nonMaster_Ct == 1)
	 {
	    eep_mfg_rec.eep_fddi.attachClass[i] = (byte) Attachment_Class_Single;/* fddihdr.h */
	 }
	 else
         {
	    eep_mfg_rec.eep_fddi.attachClass[i] = (byte) Attachment_Class_Dual;/* fddihdr.h */
	 }
      }
      else
      {
         eep_mfg_rec.eep_fddi.attachClass[i] = (byte) Attachment_Class_Concentrator;/* fddihdr.h */
      }
   }/* for FDDI PORT and ATTACHMENT */

   /*************
      XDI
   */
   eep_mfg_rec.eep_fddi.xdiBothWrapCapability = SET;	/* Not used currently */
}


void ChangeFDDIRecord( MfgRec )
EEP_MFG *MfgRec;
{
   
   uByte i, mask, nonMaster_Ct, master_Ct, mac_Ct;
   int item;

   /*************
      FDDI SMT
   */
   MfgRec->eep_fddi.smtMac_Ct = mac_Ct 
     = QueryUnsigned("Enter the total number of MACs", 
		       FDDI_MAC_CT, 0, 3);

   MfgRec->eep_fddi.smtNonmaster_Ct = nonMaster_Ct 
     = QueryUnsigned("Enter the total number of NonMaster Ports",
		     FDDI_NONMASTER_CT, 0, 2);

   MfgRec->eep_fddi.smtMaster_Ct = master_Ct 
     = QueryUnsigned("Enter the total number of Master Ports",
		     FDDI_MASTER_CT, 0, 16);

   MfgRec->eep_ports = nonMaster_Ct + master_Ct;

   sprintf(config_buffer, "Please enter the number you want to have for available SMT paths (%d)",
                    3);
   item = QueryMenu(CT_PATH_AVAIL, FDDIPathAvail, config_buffer);
   if (item > 0)
   {
      MfgRec->eep_fddi.smtPathAvailable = item;
   }
   else
   {
      MfgRec->eep_fddi.smtPathAvailable = 3;
   }


   sprintf(config_buffer, "Please enter the number you want to have for SMT configuration capabilities(%d)",
                    4);
   item = QueryMenu(CT_SMTCONFIG_CAPABILITY, SMTConfigCapability, config_buffer);
   if (item > 0)
   {
         MfgRec->eep_fddi.smtConfigCapabilities = --item;
   }
   else
   {
         MfgRec->eep_fddi.smtConfigCapabilities = 3;
   }

   MfgRec->eep_fddi.smtStatusReporting 
     = (AskYesNo("Do you want to have the SMT status report ([y]/n) ? "))? TRUE : FALSE;

   /*************
      FDDI MAC
   */
   for (i=0; i < mac_Ct; i++)
   {
      MfgRec->eep_fddi.macFrameStatusCapabilities[i] = 
        ( FSC_Type0 );/* fddihdr.h */
      MfgRec->eep_fddi.macBridgeFunction[i] = Bridge_None;   /* fddihdr.h */
#if 1   /* MAC path is not configurable */
      eep_mfg_rec.eep_fddi.macPathAvailable[i] = (i==PRIMARY_MAC) ? 
	                                    PA_PRIMARY : PA_SECONDARY;/* fddihdr.h */
#else
      sprintf(config_buffer, "Please enter the number you want to have for available MAC %d's paths (%d)",
                    i+1, 
	   (MfgRec->eep_fddi.smtPathAvailable & (i+1)) ? (i+1) : 1);
      item = QueryMenu(CT_PATH_AVAIL, FDDIPathAvail, config_buffer);
      if ((item > 0) && !(item & ~MfgRec->eep_fddi.smtPathAvailable))
      {
	 MfgRec->eep_fddi.macPathAvailable[i] = item;
      }
      else 
      {
	 if (item>0)
	 {
	    printf("\nPath %s is not a leagal path.\n", FDDIPathAvail[item-1]);
	 }
	 MfgRec->eep_fddi.macPathAvailable[i] = MfgRec->eep_fddi.smtPathAvailable;
      }
#endif
   }/* for FDDI MAC */

   /*************
     FDDI PATH
   */
   for (i=0, mask=1; (i < MAX_PATH_COUNT) ; i++, mask<<=1)
   {
      if (MfgRec->eep_fddi.smtPathAvailable & mask)
      {
         MfgRec->eep_fddi.pathPortOrder[i] = Path_Order_Ascending;	/* fddihdr.h */

         MfgRec->eep_fddi.pathType[i] = MfgRec->eep_fddi.macPathAvailable[i];
      }
   }/* for FDDI PATH */

   /*************************
      FDDI PORT and ATTACHMENT
   */
   for (i=0; (i < (nonMaster_Ct+master_Ct)); i++)
   {
      sprintf(config_buffer, "Please enter the number you want to have for available Port %d's paths (%d)",
	      i+1, MfgRec->eep_fddi.smtPathAvailable);
      item = QueryMenu(CT_PATH_AVAIL, FDDIPathAvail, config_buffer);
      if ((item > 0) && !(item & ~MfgRec->eep_fddi.smtPathAvailable))
      {
	 MfgRec->eep_fddi.portAvailPath[i] = item;
      }
      else
      {
	  if (item>0)
	  {
	     printf("\nPath %s is not a leagal path.\n", FDDIPath[item-1]);
	  }
         MfgRec->eep_fddi.portAvailPath[i] = MfgRec->eep_fddi.smtPathAvailable;
      }

      sprintf(config_buffer, "Please enter the number you want to have for Port %d's Fiber Optic Transmitter (%d)", i+1, 1);
      item = QueryMenu(CT_PORT_FOTX, PortFotx, config_buffer);
      if (item > 0)
      {
	 MfgRec->eep_fddi.portFotxClass[i] = --item;
      }
      else
      {
	 MfgRec->eep_fddi.portFotxClass[i] = 0;
      }


      if (i < nonMaster_Ct) 
      {
	 
         if (nonMaster_Ct == 1)
	 {
	    MfgRec->eep_fddi.attachClass[i] = (byte) Attachment_Class_Single;/* fddihdr.h */
	 }
	 else
         {
	    MfgRec->eep_fddi.attachClass[i] = (byte) Attachment_Class_Dual;/* fddihdr.h */
	 }
      }
      else
      {
         MfgRec->eep_fddi.attachClass[i] = (byte) Attachment_Class_Concentrator;/* fddihdr.h */
      }
   }/* for FDDI PORT and ATTACHMENT */

   /*************
      XDI
   */
   MfgRec->eep_fddi.xdiBothWrapCapability = SET;	/* Not used currently */
}

GetFDDIRec(FddiRec)
NVR_FDDI *FddiRec;
{
  int error_code;

  if (((error_code = Nvram_Load(NVR_FDDI_ADDR, FddiRec,
				NVR_FDDI_SIZE)) 
       != NVRAM_AOK) || (FddiRec->nvr_fddi_marker != NVR_FDDI_MARKER)) 
    {
       printf("FDDI Mib boot record has been set to default values.\n");
       setNVRAM_FDDIDefaults ( FddiRec );
       PutFDDIRec(FddiRec);
    }

  NumberOfPorts = eep_mfg_rec.eep_fddi.smtMac_Ct;

  SetMyNids();

  return (error_code);
}


PutFDDIRec(FddiRec)
NVR_FDDI *FddiRec;
{
        int error_code;

        FddiRec->nvr_fddi_marker = NVR_FDDI_MARKER;
        if ((error_code = Nvram_Updt(NVR_FDDI_ADDR, FddiRec, 
				     NVR_FDDI_SIZE)) != NVRAM_AOK)
                {
                printf("FDDI's NVR address = %x FDDI's NVR size = %x\n",NVR_FDDI_ADDR, NVR_FDDI_SIZE);
                printf("NVRAM Error %d: Cannot update the FDDI's NVRAM record\n", error_code);
                }
        return (error_code);
}

UpdateFddiMibInNvr(TLVPtr, stationID)
TLVParamType *TLVPtr;
SMTStationIdType *stationID;
{
   static NVR_FDDI *FddiRec = &nvr_fddi_rec;
   uInt16 entity;

   switch (TLVPtr->paramType & MIB_OBJECT_MASK)
     {
     case fddiSMT:
       switch(TLVPtr->paramType)
       {
       case fddiSMTOpVersionId:
	 NVR_FDDI_SMT.opVersionID = TLVPtr->SMTPARAM16;
	 break;
       case fddiSMTUserData:
	 MEMCOPY (NVR_FDDI_SMT.userData,
		  TLVPtr->SMTOTHER, TLVPtr->paramLen);
	 break;
       case fddiSMTConfigPolicy:
	 NVR_FDDI_SMT.configPolicy = TLVPtr->SMTPARAM16;
	 break;
       case fddiSMTConnectionPolicy:
	 NVR_FDDI_SMT.connectionPolicy = TLVPtr->SMTPARAM16;
	 break;
       case fddiSMTReportLimit:
	 NVR_FDDI_SMT.reportLimit = TLVPtr->SMTPARAM32;
	 break;
       case fddiSMTT_Notify:
	 NVR_FDDI_SMT.T_Notify = TLVPtr->SMTPARAM16;
	 break;
       case xdiSMTBothWrapPolicy:
	 NVR_FDDI_SMT.xdiBothWrapPolicy = TLVPtr->SMTPARAM8;
	 break;
       case fddiSMTStationAction:
	 if (TLVPtr->SMTPARAM16 == StationAction_Disconnect)
	 {
            MEMCOPY(&mib->HLSSMTGrp.RemoteDisconnectStationId,
		    stationID,
		    sizeof(SMTStationIdType));
	    mib->SMTStatusGrp.RemoteDisconnectFlag = SET;
	 }
	 else if (TLVPtr->SMTPARAM16 == StationAction_Connect)
	 {
	    mib->SMTStatusGrp.RemoteDisconnectFlag = CLEAR;
	 }
	 break;

       /* 
	* Read Only 
	*/
	case fddiSMTStationId:
	case fddiSMTHiVersionId:
	case fddiSMTManufacturerData:
	 break;
       }
       break;
     case fddiMAC:
       entity = TLVPtr->MACINDEX - 1;
       switch(TLVPtr->paramType)
       {
       case fddiMACPathsRequested:
	 NVR_FDDI_MAC[entity].pathRequested = TLVPtr->MACPARAM8;
	 break;
       case fddiMACSMTAddress:
	 MCopyAddress(NVR_FDDI_MAC[entity].SMTAddress,
		      TLVPtr->MACADDR);
	 break;
       case fddiMACT_Req:
	 NVR_FDDI_MAC[entity].T_Req = TLVPtr->MACPARAM32;
	 break;
       case fddiMACT_Min:
	 NVR_FDDI_MAC[entity].T_Min = TLVPtr->MACPARAM32;
	 break;
       case fddiMACFrameStatus: 
	 NVR_FDDI_MAC[entity].frameStatus = TLVPtr->MACPARAM16;
	 break;
	case fddiMACFrameErrorThreshold:
	 NVR_FDDI_MAC[entity].FrameErrorThreshold = TLVPtr->MACPARAM16;
	 break;
	case fddiMACNotCopiedThreshold:
	 NVR_FDDI_MAC[entity].NotCopiedThreshold = TLVPtr->MACPARAM16;
	 break;
	case xdiMACRMTDupPolicy1:
	 NVR_FDDI_MAC[entity].xdiRMTDupPolicy1 = TLVPtr->MACPARAM8;
	 break;
	case xdiMACRMTDupPolicy2:
	 NVR_FDDI_MAC[entity].xdiRMTDupPolicy2 = TLVPtr->MACPARAM8;
	 break;
	case xdiMACOperational:
	 NVR_FDDI_MAC[entity].xdiOperational = TLVPtr->MACPARAM8;
	 break;
      
       /* 
	* Read Only 
	*/
       case fddiMACT_MaxGreatestLowerBound:
       case fddiMACTVXGreatestLowerBound:
       case fddiMACT_Max:
       case fddiMACTvxValue:
       case fddiMACT_Pri0:
       case fddiMACT_Pri1:
       case fddiMACT_Pri2:
       case fddiMACT_Pri3:
       case fddiMACT_Pri4:
       case fddiMACT_Pri5:
       case fddiMACT_Pri6:
	 break;
       }
       break;
     case fddiPATHClass:
       entity = TLVPtr->PATHINDEX - 1;
       switch(TLVPtr->paramType)
       {
       case fddiPATHClassTrace_MaxExpiration:
	 NVR_FDDI_PATH[entity].Trace_MaxExpiration = TLVPtr->PATHPARAM32;	 
	 break;
       case fddiPATHClassTVXLowerBound:
	 NVR_FDDI_PATH[entity].TVXLowerBound = TLVPtr->PATHPARAM32;
	 break;
       case fddiPATHClassT_MaxLowerBound:
	 NVR_FDDI_PATH[entity].T_MAXLowerBound = TLVPtr->PATHPARAM32;
	 break;
       case fddiPATHClassPATHT_Rmode:
	 NVR_FDDI_PATH[entity].T_Rmode = TLVPtr->PATHPARAM32;
	 break;
       }
       break;
     case fddiPORT:
       entity = TLVPtr->PORTINDEX - 1;
       switch(TLVPtr->paramType)
       {
       case fddiPORTConnectionPolicies:
	 NVR_FDDI_PORT[entity].connectionPolicies = TLVPtr->PORTPARAM8;
	 break;
	case fddiPORTPathsRequested:
	 NVR_FDDI_PORT[entity].pathRequested = TLVPtr->PORTPARAM8;
	 break;
	case xdiPORTOperational:
	 NVR_FDDI_PORT[entity].xdiOperational = TLVPtr->PORTPARAM8;
	 break;
	case fddiPORTMACLoop_Time:
	 NVR_FDDI_PORT[entity].MACLoop_Time = TLVPtr->PORTPARAM32;
	 break;
	case fddiPORTTB_Max:
	 NVR_FDDI_PORT[entity].TB_Max = TLVPtr->PORTPARAM32;
	 break;
	case fddiPORTLer_Cutoff:
	 NVR_FDDI_PORT[entity].LER_Cutoff = TLVPtr->PORTPARAM8;
	 break;
	case fddiPORTLer_Alarm:
	 NVR_FDDI_PORT[entity].LER_Alarm = TLVPtr->PORTPARAM8;
	 break;
       
       /* 
	* Read Only 
	*/
       case fddiPORTPC_Type:
	 break;
       }
       break;
     case fddiATTACHMENT:
       entity = TLVPtr->ATTACHINDEX - 1;
       switch(TLVPtr->paramType)
       {
       case fddiATTACHMENTOpticalBypassPresent:
	 NVR_FDDI_ATTACHMENT[entity].opticalBypassPresent 
	     = TLVPtr->ATTACHPARAM8;
	 break;
       }
       break;
     }
     PutFDDIRec(FddiRec);
}


uInt32 GetHLSMIBSMTAttr (bufSize, bufData)
uInt16                  bufSize;
uChar                   *bufData;
{
   TLVParamType *TLVPtr;
   TLVPtr = (TLVParamType*) bufData;

   switch (TLVPtr->paramType & MIB_OBJECT_MASK)
     {
     case fddiSMT:
       switch(TLVPtr->paramType)
       {
       case hlsSMTRemoteDisconnectStationID:
	 TLVPtr->paramLen = sizeof (SMTStationIdType);
	 MEMCOPY (TLVPtr->SMTOTHER,
		  &mib->HLSSMTGrp.RemoteDisconnectStationId,
		  sizeof (SMTStationIdType));
	       break;
       default:
	 return RC_ILLEGAL_PARAMETER;
       }       
       break;

     case fddiMAC:
     case fddiPATHClass:
     case fddiPORT:
     case fddiATTACHMENT:
     default:
       return RC_ILLEGAL_PARAMETER;
     }
   return RC_SUCCESS;
}
     
void PrintFddiMacAddress()
{
   MACAddr48 macAddr;

   MCopyAddress(macAddr, MyNid(2));
   swap_bits(macAddr, sizeof(macAddr));
   printf("\nFDDI SMT's Address:\t\t%s\n", NidToString((byte *)macAddr));

   MCopyAddress(macAddr, MyNid(0));
   swap_bits(macAddr, sizeof(macAddr));
   printf("FDDI MAC 1's Address:\t%s\n", NidToString((byte *) macAddr));

   MCopyAddress(macAddr, MyNid(1));
   swap_bits(macAddr, sizeof(macAddr));
   printf("FDDI MAC 2's Address:\t%s\n", NidToString((byte *) macAddr));
}

/*------------------------------------------------------------------*/
/*              puts back the alarm entries on nvram                */
/*------------------------------------------------------------------*/
/* export */
int PutAlarmRec()
    {
    int err;

#ifdef ALDEBUG
    printf("PutAalrmRec \n");
#endif

    nvr_alarms.nvr_alarm_marker = NVR_ALARM_MARKER;

    if ((err = Nvram_Updt(NVR_ALARM_ADDR, &nvr_alarms, NVR_ALARM_SIZE))
                != NVRAM_AOK)
        printf("Error: can't write new alarm record to NVRAM\n");

#ifdef ALDEBUG
    printf("err = %d %x\n", err, err);
#endif
    return (err);
    }


/*------------------------------------------------------------------*/
/*              puts back the event entries on nvram                */
/*------------------------------------------------------------------*/
/* export */
int PutEventRec()
    {
    int err;
 
#ifdef ALDEBUG
    printf("PutEventRec \n");
#endif
    nvr_events.nvr_event_marker = NVR_EVENT_MARKER;
 
    if ((err = Nvram_Updt(NVR_EVENT_ADDR, &nvr_events, NVR_EVENT_SIZE))
                != NVRAM_AOK)
            printf("Error: can't write new event record to NVRAM\n");
 
    return (err);
    }
  
