#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) mib.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/**********************************************************************
	Management Information Base Module

	Main processing module.

	File:		mib.c
	Created:	12/01/89
	SMT Version:	6.2

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This module is the main processing loop for the Management 
	Information Base (MIB). The basic mode of operation is for the 
	MIB to initialize itself and the hardware and software environment, 
	notify FBM and CSP that the environment has been prepared, and 
	then wait for requests and events to occur. As requests and events 
	come in, this module will field them appropriately.

	Modification History:

	*** Updated to SMT 6.2 ***
	910122-005	LJP
		Clean up: MIBMain() needs to call InitMIBInterrupts()
		and InitTimeStamp().

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"mibdefs.h"
#include	"mibtypes.h"
#include	"mibglbl.h"
#include	"smtmsg.h"


/*********************************************************************
	External function definitions.
*********************************************************************/

extern	uInt16	phyTotal, macTotal, masterTotal;

extern	uInt32	InitMIB ();
extern	uInt32	InitMIBMessage ();
extern	uInt32	InitMIBLocal ();
extern	uInt32	InitTimeStamp ();	/* 910122-005 LJP */
extern	uInt32	InitMIBInterrupts ();	/* 910122-005 LJP */


/*********************************************************************
	MIB Functions.
*********************************************************************/

uInt32
MIBMain ()
/*********************************************************************
Function:	Main processing loop for MIB. The MIB initializes
		itself and then waits for requests from other processes.
		When a request comes in, this function will route it
		to the appropriate processing function.
Parameters:	None.
Input:		None.
Output:		Initializes MIB and processes MIB requests.
Return:		0 returned if MIB process is terminated properly.
		-1 if process terminates abnormally or cannot initialize.
Modification History:
*********************************************************************/
{
uInt32	result = 0;

	/*
	*	Initialize system.
	*/
	/* 910122-005 LJP */
        SMTDPT("InitTimeStamp\n");
	if (result = InitTimeStamp ())
		return (result);

        SMTDPT("InitMIBMessage\n");
	if (result = InitMIBMessage ())
		return (result);

        SMTDPT("InitMIBM\n");
	if (result = InitMIB ())
		return (result);

	/* 910122-005 LJP */
        SMTDPT("InitMIBInterrupts\n");
	if (result = InitMIBInterrupts ())
		return (result);

        SMTDPT("InitMIBMLocal\n");
	if (result = InitMIBLocal ())
		return (result);

        SMTDPT("Initialize MIB successfully.\n");
	return (0);
}

