/*
@(#) smttypes.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Station Management Header File
	
	SMT Type Definition Header File
	
	File:		smttypes.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This is the header file used by all SMT modules. This file contains
	type definitions for used by all SMT modules. The type definitions
	supplied here give the SMT system its portability.
		
	Modification History:
	910122-005	LJP
		Change definition of CLEAR from FALSE to 0.
	910220-002	LJP
		Changed size of smtOther member in TLVParamType structure
		from 12 to 32 to handle fddiSMTUserData change requests
		from a MAP in the FBM_ACTION_SEND_FRAME message. This also
		makes local Get and Change operations easier for this
		attribute and fddiSMTManufacturerData.
	910315-005	LJP
		Added new defined constant XDIMANUFDATA.
*********************************************************************/
#ifndef __FDDI_SMTTYPES_H
#   define __FDDI_SMTTYPES_H

#pragma align 1
#pragma pack  1

/*********************************************************************
	Type Definitions
*********************************************************************/

/*
*	Time Values
*	The CSP system uses two types of time values, one for microseconds
*	and one for seconds.
*/
typedef	uInt32	uTime;


/*********************************************************************
*	FDDI Types
*	Some FDDI values exceed the size of the average processor word
*	size. Therefore, structures need to be defined to handle these
*	oversized values.
*********************************************************************/

/*
*	FDDI Addresses
*/
typedef	uChar	MACAddr48[6];
typedef	uChar	MACAddr16[2];

/*
*	Line States
*/
typedef	uInt16	LineState;


/**********************************************************************
*
*	The following typedefs provide data types and structures
*	for use throughout the MIB. These types align short data
*	values to 32-bit boundaries. This allows the MIB routines
*	to provide attributes properly aligned for frame transmission.
*	Thus, the frame processing routines do not need to know about
*	individual data sizes when building frame parameters.
*
**********************************************************************/

/*
*	8-bit attribute values.
*/
typedef	struct SMT8BitStruct {
	uChar		pad[3];
	uChar		data;
} TLV8BitType;

/*
*	16-bit attribute values.
*/
typedef	struct SMT16BitStruct {
	uChar		pad[2];
	uInt16		data;
} TLV16BitType;

/*
*	32-bit attribute values.
*	This type allows access to 32-bit attribute using member data
*	as with the 16- and 8-bit attributes.
*/
typedef	struct SMT32BitStruct {
	uInt32		data;
} TLV32BitType;

/*
*	Address/ID attribute values.
*	This type allows access to two-byte data field followed by
*	a 6-byte address.
*/
typedef struct SMTIdStruct {
	uChar		data[2];
	MACAddr48	addr;
} TLVIdType;


/**********************************************************************
*
*	Typedefs for special attributes. These attributes are either
*	larger than 32 bits or consists of aggregate members.
*
**********************************************************************/

typedef	struct SMTStationIdStruct {
	uChar		user[2];		/* user defined octets */
	MACAddr48	IEEEAddress;		/* IEEE-assigned address */
} SMTStationIdType;

typedef	struct SMTManufacturerDataStruct {
	uChar		OUI[3];			/* implementor's OUI */
	uChar		data[29];		/* implementor's data */
} SMTManufacturerDataType;

typedef	uChar	SMTUserDataType[32];		/* implementor's data */

typedef	struct	SMTTimeStampStruct {
	uInt32		hiword;			/* upper 32 bits */
	uInt32		loword;			/* lower 32 bits */
} SMTTimeStamp;

typedef	struct	SMTSetCountStruct {
	uInt32		count;			/* last counter value */
	SMTTimeStamp	setTimeStamp;		/* last time of set */
} SetCountType;

typedef	struct	PathConfigStruct {
	uInt16		ResourceType;		/* 2=MAC, 4=PORT */
	uInt16		ResourceIndex;
} PathConfigType;

typedef	struct	TLVHdrStruct {
	uInt16	paramType;
	uInt16	paramLen;
} TLVHdrType;

typedef	struct	TLVParamStruct {
	uInt16		paramType;		/* Type and length are */
	uInt16		paramLen;		/* common to all params */
	union {
		struct {			/* Some attrs require index */
			TLV16BitType	paramIndex;
			union {
				TLV8BitType	p8;
				TLV16BitType	p16;
				TLV32BitType	p32;
				TLVIdType	pId;
				uChar		pOther[12];
			} pval;
		} otherAttr;
		union {
			TLV8BitType	smt8;	/* SMT attrs need no index */
			TLV16BitType	smt16;
			TLV32BitType	smt32;
			TLVIdType	smtId;
			/*
			*	910220-002 LJP
			*	Changed size of smtOther from 12 to 32 bytes.
			*/
			uChar		smtOther[32];
		} smtAttr;
	} paramValue;
} TLVParamType;

typedef	struct 	TLVSetCountStruct {
	uInt16		paramType;
	uInt16		paramLen;
	SetCountType	paramValue;
} TLVSetCountType;


/*********************************************************************
*
*	The following typedefs are left of backward compatibility to
*	older versions of the XLNT Manager software.
*
*********************************************************************/

/*
*	FDDI Timer type.
*/
typedef uInt32 FDDITimer;

/*
*	The data type for manufacturer data fields.
*/
typedef SMTManufacturerDataType	SMTManufData;

/*
*	SMT Station id.  This value is recommended to be set to
*	the MAC address of the first MAC in the station.
*/
typedef SMTStationIdType	SMTStationId;

/*
*	SMT User Data field type.
*/
typedef SMTUserDataType	SMTUserData;

/*
*	The list of supported SMT versions.  The supported versions
*	must be a contigous range.  The structure below gives the
*	starting version supported and the ending version supported.
*/
typedef struct SMTVersList {
	uInt16	Start;			/* Initial version supported */
	uInt16	End;			/* Last version supported */
} SMTVersList;


/**********************************************************************
*
*	Typedefs for events and conditions as defined in the MIB.
*
**********************************************************************/

/* Configuration Change Event */
typedef struct EvtCfgChgStruct {
	TLVHdrType	eventHdr;	/* event header */
	TLVHdrType	CF_StateHdr;	/* CF_State header */
	TLV8BitType	CF_State;	/* CF_State value */
#ifdef OPTIONAL_PARAMETER
	TLVHdrType	PathListHdr;	/* Path list header */
	TLV16BitType	pathIndex;	/* index for path */
					/* maximum size path list */
	uChar		PathList[(MAX_MAC_COUNT + MAX_PORT_COUNT) * 4];
#endif
}
EvtCfgChgType;

/* Duplicate Address Condition */
typedef struct CondDAStruct {
	TLVHdrType	condHdr;	/* condition header */
	uInt16		Condition;	/* condition status */
	uInt16		MACIndex;	/* index (MIB value) */
	MACAddr48	DuplicateAddr;	/* this duplicate */
	MACAddr48	UNADuplicateAddr;	/* UNA duplicate */
} CondDAType;

/* Frame Error Condition */
typedef struct CondFrErrStruct {
	TLVHdrType	condHdr;	/* condition header */
	uInt16		Condition_State;
	uInt16		MACIndex;	/* index (MIB value) */
	uInt32		Frame_Ct;
	uInt32		Error_Ct;
	uInt32		Lost_Ct;
	uInt32		BaseFrame_Ct;
	uInt32		BaseError_Ct;
	uInt32		BaseLost_Ct;
	SMTTimeStamp	BaseTimeStamp;
	uChar		pad[2];
	uInt16		FrameErrorRatio;
} CondFrErrType;

/* Not Copied Condition */
typedef struct CondNotCopiedStruct {
	TLVHdrType	condHdr;	/* condition header */
	uInt16		Condition_State;
	uInt16		MACIndex;	/* index (MIB value) */
	uInt32		NotCopied_Ct;
	uInt32		Copied_Ct;
	uInt32		BaseNotCopied_Ct;
	SMTTimeStamp	BaseTimeStamp;
	uInt32		BaseCopied_Ct;
	uChar		pad[2];
	uInt16		NotCopiedRatio;
} CondNotCopiedType;

/* MAC Neighbor Change Event */
typedef struct EvtNbrChgStruct {
	TLVHdrType	eventHdr;
	uInt16		Condition;
	uInt16		MACIndex;
	MACAddr48	Old_UNA;
	MACAddr48	New_UNA;
	MACAddr48	Old_DNA;
	MACAddr48	New_DNA;
} EvtNbrChgType;

/* Trace Status Event */
typedef struct EvtTrStatType {
	TLVHdrType	eventHdr;
	uChar		pad;
	uChar		TraceStarted;
	uChar		TraceTerminated;
	uChar		TracePropagated;
} EvtTrStatType;

/* Ler Condition */
typedef struct CondLerStruct {
	TLVHdrType	condHdr;
	uInt16		ConditionState;
	uInt16		PORTIndex;
	uChar		pad1;
	uChar		Ler_Cutoff;
	uChar		Ler_Alarm;
	uChar		Ler_Estimate;
	uInt32		Lem_Reject_Ct;
	uInt32		Lem_Ct;
	uChar		pad2[3];
	uChar		BaseLer_Estimate;
	uInt32		BaseLem_Reject_Ct;
	uInt32		BaseLem_Ct;
	SMTTimeStamp	BaseLer_TimeStamp;
} CondLerType;

/* Undesired Connection Attempt Event */
typedef struct EvtConnectStruct {
	TLVHdrType	eventHdr;
	uChar		pad[2];
	uInt16		PORTIndex;
	uChar		PC_Type;
	uChar		connectState;
	uChar		PC_Neighbor;
	uChar		connectionAccepted;
} EvtConnectType;

/* EB Error Condition */
typedef struct CondEBErrStruct {
	TLVHdrType	condHdr;
	uInt16		ConditionState;
	uInt16		PORTIndex;
	uInt32		EbError_Ct;
} CondEBErrType;


#pragma align 16
#pragma pack  16

/*********************************************************************
*	Constant Definitions
*********************************************************************/

/*
*	Boolean values
*/

#ifndef	FALSE
#define	FALSE	0
#endif

#ifndef	TRUE
#define	TRUE	!FALSE
#endif

#ifndef	CLEAR
#define	CLEAR	0		/* 910122-005 LJP */
#endif

#ifndef	SET
#define	SET	1
#endif

#ifndef	NULL
#define	NULL	0
#endif

#define	DISABLE	FALSE
#define	ENABLE	TRUE

#define	INSERTED	TRUE
#define	DEINSERTED	FALSE

/* 910315-005	LJP */
#define	XDIMANUFDATA	"XDI622"


/*********************************************************************
*	Macro Definitions
*********************************************************************/

/*
*	Definitions to access parameter values.
*
*	Use the macros to access the appropriate parameter element
*	in the TLVParamType. To use them, put the element reference
*	in front of the macro as follows:
*		x.SMTPARAM8
*		y->MACINDEX
*	where x is of type TLVParamType and y is a pointer to a
*	TLVParamType.
*/
#define	SMTPVAL		paramValue.smtAttr
#define	SMTPARAM8	paramValue.smtAttr.smt8.data
#define	SMTPARAM16	paramValue.smtAttr.smt16.data
#define	SMTPARAM32	paramValue.smtAttr.smt32.data
#define	SMTADDR		paramValue.smtAttr.smtId.addr
#define	SMTOTHER	paramValue.smtAttr.smtOther

#define	MACPVAL		paramValue.otherAttr.pval
#define	MACINDEX	paramValue.otherAttr.paramIndex.data
#define	MACPARAM8	paramValue.otherAttr.pval.p8.data
#define	MACPARAM16	paramValue.otherAttr.pval.p16.data
#define	MACPARAM32	paramValue.otherAttr.pval.p32.data
#define	MACADDR		paramValue.otherAttr.pval.pId.addr
#define	MACOTHER	paramValue.otherAttr.pval.pOther

#define	PATHPVAL	paramValue.otherAttr.pval
#define	PATHINDEX	paramValue.otherAttr.paramIndex.data
#define	PATHPARAM8	paramValue.otherAttr.pval.p8.data
#define	PATHPARAM16	paramValue.otherAttr.pval.p16.data
#define	PATHPARAM32	paramValue.otherAttr.pval.p32.data
#define	PATHOTHER	paramValue.otherAttr.pval.pOther

#define	PORTPVAL	paramValue.otherAttr.pval
#define	PORTINDEX	paramValue.otherAttr.paramIndex.data
#define	PORTPARAM8	paramValue.otherAttr.pval.p8.data
#define	PORTPARAM16	paramValue.otherAttr.pval.p16.data
#define	PORTPARAM32	paramValue.otherAttr.pval.p32.data
#define	PORTOTHER	paramValue.otherAttr.pval.pOther

#define	ATTACHPVAL	paramValue.otherAttr.pval
#define	ATTACHINDEX	paramValue.otherAttr.paramIndex.data
#define	ATTACHPARAM8	paramValue.otherAttr.pval.p8.data
#define	ATTACHPARAM16	paramValue.otherAttr.pval.p16.data
#define	ATTACHPARAM32	paramValue.otherAttr.pval.p32.data
#define	ATTACHOTHER	paramValue.otherAttr.pval.pOther

#endif /* __FDDI_SMTTYPES_H */
