#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbm.c V6.2.3:cs.911022:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Main Processing Module

	File:		fbm.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.911022	10/28/91
	
	Copyright 1990,1991 XLNT Designs, Inc.

	This module is responsible for initializing the basic FBM
	processing.

	Modification History:

	*** Updated to SMT 6.2 ***

	910315-004	LJP
		Include call to InitSRP().
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"


/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/


/*********************************************************************
	External Functions
*********************************************************************/

extern	uInt32	InitFBMQueue ();
extern	uInt32	InitProcessFBM ();
extern	uInt32	InitFBMData ();
extern	uInt32	InitFBMNN ();
extern	uInt32	InitFBMReceive ();
extern	uInt32	InitFBMTransId ();
extern	uInt32	InitFBMMessage ();
extern	uInt32	InitFBMInterrupts ();
extern	uInt32	InitFBMFrameBuffer ();
extern	uInt32	InitFBMFrame ();
extern	uInt32	InitFBMTimer ();
extern	uInt32	InitFBMLocal ();
extern	uInt32	InitESFLocal ();
extern	uInt32	InitSRP ();		/* 910315-004 LJP */


/*********************************************************************
	FBM Processing Routines
*********************************************************************/

uInt32
FBMMain ()
/*********************************************************************
Function:	Begin FBM processing.
Parameters:	None.
Input:		None.
Output:		Initializes FBM.
Return:		0 if successful, or error code.
Modification History:
*********************************************************************/
{
uInt32	result;

	/*
	*	Initialize values and interfaces.
	*/
	if (result = InitFBMQueue ())
		return (result);

	if (result = InitProcessFBM ())
		return (result);

	if (result = InitFBMData ())
		return (result);

	if (result = InitFBMNN ())
		return (result);

	if (result = InitFBMReceive ())
		return (result);

	if (result = InitFBMTransId ())
		return (result);

	if (result = InitFBMMessage ())
		return (result);

	if (result = InitFBMInterrupts ())
		return (result);

	if (result = InitFBMFrameBuffer (&fbmFrameBuffer))
		return (result);
	fbmFrameHeader = (SMTFrameHdrType *) fbmFrameBuffer;

	if (result = InitFBMFrame ())
		return (result);

	if (result = InitFBMTimer ())
		return (result);

	if (result = InitSRP ())
		return (result);

	if (result = InitFBMLocal ())
		return (result);

	if (result = InitESFLocal ())
		return (result);

	return (0);
}

