#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbmesf.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Based Management Module

	Process ESF Frames Module

	File:		fbmesf.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This module is responsible for processing ESF frames and taking
	whatever action is necessary for processing each frame.  For 
	frames which require a require a response one is generated 
	immediately. 

	Modification History:
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"


/*********************************************************************
	External functions used.
*********************************************************************/

extern	void	ClearFrameBuffer ();
extern	uInt16	ntohs ();
extern	uInt32	ntohl ();
extern	uInt16	htons ();
extern	uInt32	htonl ();
extern	void	LocalESFAnnouncement ();
extern	uInt32	LocalESFRequest ();
extern	void	LocalESFResponse ();
extern	uInt32	BuildRDFResponse ();
extern	void	SendSMTFrame ();


/*********************************************************************
	FBM Receive Routines
*********************************************************************/

void
ProcessESFAnnouncement (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:	This function processes an ESF Announcement. If the
		ESF does not fall into any approved extensions of the
		standard, a call to LocalESFAnnouncement() is made.
Parameters:	memPtr		= address of buffer containing frame.
		frameLen	= length of total frame in bytes.
		MACNum		= MAC index which received the frame.
		EACbits		= EAC bits received by MAC.
Input:		memPtr		= complete ESF frame received. This frame
				has already had its E indicator and version
				verified by ProcessFBMFrame().
Output:		None.
Return:		No value is returned.
Modification History:
*********************************************************************/
{

	/*
	*	No defined ESF processing. Call local options.
	*/
	LocalESFAnnouncement (memPtr, frameLen, MACNum, EACbits);

	return;
}

void
ProcessESFRequest (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:	This function processes an ESF Request. If the
		ESF does not fall into any approved extensions of the
		standard, a call to LocalESFRequest() is made. 
		If LocalESFRequest() returns a reason code other than
		RC_SUCCESS, then an RDF is generated.
Parameters:	memPtr		= address of buffer containing frame.
		frameLen	= length of total frame in bytes.
		MACNum		= MAC index which received the frame.
		EACbits		= EAC bits received by MAC.
Input:		memPtr		= complete ESF frame received. This frame
				has already had its E indicator and version
				verified by ProcessFBMFrame().
Output:		None.
Return:		No value is returned.
Modification History:
*********************************************************************/
{
uInt32		result;
uInt16		len;

	/*
	*	No defined ESF processing. Call local options.
	*/
	result = LocalESFRequest (memPtr, frameLen, MACNum, EACbits);

	if (result != RC_SUCCESS)
	{
		/* clear buffer for the response frame */
		ClearFrameBuffer (fbmFrameBuffer);

		/* build RDF frame */
		BuildRDFResponse (memPtr, fbmFrameBuffer,
			MACNum, RC_FRAME_CLASS, frameLen);

		/* send frame */
		len = ntohs (fbmFrameHeader->smtHdr.InfoField_Length)
				+ SMT_FRAME_HDR_SIZE;
		SendSMTFrame (fbmFrameBuffer, len, MACNum);
	}

	return;
}

void
ProcessESFResponse (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:	This function processes an ESF Announcement. If the
		ESF does not fall into any approved extensions of the
		standard, a call to LocalESFAnnouncement() is made. 
Parameters:	memPtr		= address of buffer containing frame.
		frameLen	= length of total frame in bytes.
		MACNum		= MAC index which received the frame.
		EACbits		= EAC bits received by MAC.
Input:		memPtr		= complete ESF frame received. This frame
				has already had its E indicator and version
				verified by ProcessFBMFrame().
Output:		None.
Return:		No value is returned.
Modification History:
*********************************************************************/
{
	/*
	*	No defined ESF processing. Call local options.
	*/
	LocalESFResponse (memPtr, frameLen, MACNum, EACbits);

	return;
}
