/*********************************************************************
	Management Services Process Module
	
	Message Interface Routines

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		mibmsgif.c
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This module provides the interface routines to handle message
	passing between MIB and the other processes in the SMT system.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/
#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include        "msgutil.h"
#include        "cmtflag.h"

/*********************************************************************
	Message External Declarations
*********************************************************************/


/*********************************************************************
	Message Interface Defined Values
*********************************************************************/


/*********************************************************************
	Message Interface Global Variables
*********************************************************************/


/*********************************************************************
	Message Interface Routines
*********************************************************************/

void
SendMIBMessage (msg)
	SMTMessage	*msg;
/*********************************************************************
Function:	Send a message from MIB to another process.
Parameters:	msg	= address of buffer containing message.
Input:		msg	= contains SMT message structure that defines the
				message to send.
Output:		None.
Return:		None.
Notes:		In systems, where all Manager tasks (CSP, FBM, MIB and
		possible MAP), this routine may call the destination
		task's ProcessXXXMessage() function directly.
Modification History:
*********************************************************************/
{
   switch (msg->destination) {
   case CSP_MSG_ID:
      ReceiveCSPMessage (msg);         /* Call directly without allocate
					  extra memory and copy the data 
				        */
      break;

   case MAP_MSG_ID:
      ProcessMAPMessage (msg);         /* Call directly without allocate
					  extra memory and copy the data 
				        */
      break;

   case FBM_MSG_ID:
#ifdef __CMT_ONLY
      return;
#endif
      MIBDPT("$MIB: Send message to FBM$...");
      ProcessFBMMessage (msg);         /* Call directly without allocate
					  extra memory and copy the data 
				        */
      break;
   }

   
   return;
}

uInt32
InitMIBMessage ()
/*********************************************************************
Function:	Initialize system for sending and receiving SMT messages.
Parameters:	None.
Input:		None.
Output:		Set system message processing.
Return:		0 if successful, error number if failed.
*********************************************************************/
{

 /*
  *   There is no MIB mailbox.  All other processes access the MIB through
  *   direct function calls.
  */

  /*
   *   It initializes the free buffer allocation for all internal messages
   *   in SMT and MAP.
   */
   
   return InitFDDIMsgMBox(&FDDIMsgHdrDescr);
}


