/*********************************************************************
	Connection Services Process Header File
	
	CSP Macro Definitions

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.
	
	File:		cspmacro.h
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This is the header file used throughout the CSP modules. This 
	file defines C macros used to make the CSP source code portable.
	The macros listed here are to be provided by implementor.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

/*********************************************************************
	Implementor Provided Macros
*********************************************************************/

/*
*	Processor State
*	Throughout the CSP portion of the SMT system, the system interrupts
*	will need to be disabled and enabled. This variable type defines
*	a variable large enough to hold the processor state information
*	required to change the interrupt settings.
*/

#ifndef __FDDI_CSPMACRO_H
#   define __FDDI_CSPMACRO_H

typedef	int	ProcState;
extern long crit_on();
extern int crit_off();
/*********************************************************************
macro	MDisableCSPInterrupts (pState)

Function:	Set the system or processor state to disable interrupt
		processing for CSP interrupts.
Parameters:	pState	= address of buffer to hold current interrupt
			or processor state.
Input:		None.
Output:		pState	= contains current interrupt or processor state.
Return:		No value returned.
Notes:		Since interrupt processing is completely system dependent,
		the implementor must provide a facility for disabling
		interrupt processing. When CSP uses this macro to disable
		interrupts, it stores the current state and restores the
		current state to enable interrupts (see MRestoreInterrupts()).
Modification History:
*********************************************************************/
#define	MDisableCSPInterrupts(pState)       *(pState) = crit_on();


/*********************************************************************
macro	MRestoreCSPInterrupts (pState)

Function:	Restore interrupt processing to a previous state.
Parameters:	pState	= address of buffer containing previous interrupt state.
Input:		pState	= containes interrupt state to restore to.
Output:		None.
Return:		No value returned.
Notes:		When interrupts are disabled in CSP, the previous interrupt
		level is remember. When the critical code section completes
		execution, the CSP code restore the interrupt processing
		state.
Modification History:
*********************************************************************/
#define	MRestoreCSPInterrupts(pState)       crit_off(*(pState));

#endif /* __FDDI_CSPMACRO_H */
