/*********************************************************************
	Frame Based Management Module

	Interrupt/Event/Invocation Interface Routines

	THIS MODULE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmintif.c
	Created:	12/01/89

	SID:		1.4
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	This module provides the interface routines to handle event
	conditions that must be reported to CSP.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"smterror.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmmacro.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"
#include        "krnl.h"
#include        "msgutil.h"
#include        <pkt.h>
#include        "drv.h"


/*********************************************************************
	Interrupt Interface External Functions
*********************************************************************/


/*********************************************************************
	Interrupt Interface Defined Values
*********************************************************************/
static byte FrameBuffer[4500];
static BOOLEAN Running;
static word *FBMstack;
MBOX RxSMTFrameMBox;
SEM    FBMSyncSema;

/*********************************************************************
	External Routines
*********************************************************************/
extern uInt32 TimeStampEnable;
extern uChar MacInPromiscous[];

/*********************************************************************
	Interrupt Interface Routines
*********************************************************************/
uChar GetEACbits(msg)
GenericMsgType *msg;
{
   uChar EACbits=0;

   if ((msg->frame_status & DRV_FS_E_MASK) == DRV_FS_E_SET)
   {
      EACbits |= E_Bit_Position;
   }

   if ((msg->frame_status & DRV_FS_A_MASK) == DRV_FS_A_SET)
   {
      EACbits |= A_Bit_Position;
   }

   if ((msg->frame_status & DRV_FS_C_MASK) == DRV_FS_C_SET)
   {
      EACbits |= C_Bit_Position;
   }

   return EACbits;
}

void ProcessRxFrame (memPtr, frameLen, MACNum, EACbits)
uChar *memPtr;
uInt16 frameLen, MACNum;
uChar EACbits;
{
   extern int fault_cnt;
   uInt32 reasonCode;

   SMTFrameHdrType *frameHdr;
   Int16 compare;


   if (!fbmStationData.FBMInitialized)
   {
      return;
   }

   if (EACbits & E_Indicator)
   {
#if 0
      fault_cnt = 1;
      printf("FBM%d: error frame rxed.\n", MACNum);
      fault_cnt = 0;
#endif
      return;
   }
#if 0
   else
   { 
      fault_cnt = 1;
      printf("FBM%d: Rx a frame.\n", MACNum);
      fault_cnt = 0;
   }
#endif

   frameHdr = (SMTFrameHdrType *) memPtr;

   MCompareAddress (frameHdr->macHdr.SA, fbmMACData[MACNum].SMTAddress,
		    compare);

   if (!compare)   /* my own frames */
   {
#if 0
      fault_cnt = 1;
      printf("FBM%d: Rx my own frame (SA=%02x.%02x.%02x.%02x.%02x.%02x).\n", 
	     MACNum, frameHdr->macHdr.SA[0], frameHdr->macHdr.SA[1],
	     frameHdr->macHdr.SA[2], frameHdr->macHdr.SA[3],
	     frameHdr->macHdr.SA[4], frameHdr->macHdr.SA[5]);
      fault_cnt = 0;
#endif

      
      if (frameHdr->smtHdr.Frame_Type != SMTREQUEST)
      {
	 if ((reasonCode = ValidateFrameContents (frameHdr, frameLen))
	     != RC_SUCCESS)
	 {
	    return;
	 }

	 if (frameHdr->smtHdr.Frame_Class == ECHO_CLASS)
	 {
	    MCompareAddress (frameHdr->macHdr.DA, fbmMACData[MACNum].SMTAddress,
			     compare);
	    if (!compare)
	    {
	       PassMAPFrame (FBM_EVENT_FRAME_RECEIVED,
			     memPtr, frameLen, MACNum, EACbits);	    
	    }
	 }
	 LocalFBMFrames (memPtr, frameLen, MACNum, EACbits);
	 return;
      }

      if (frameHdr->smtHdr.Frame_Class == ECHO_CLASS)
      {
	 MCompareAddress (frameHdr->macHdr.DA, fbmMACData[MACNum].SMTAddress,
			  compare);
	 if (compare)
	 {
	    LocalFBMFrames (memPtr, frameLen, MACNum, EACbits);
	    return;
	 }
      }
      else if (frameHdr->smtHdr.Frame_Class != SIFCONFIG_CLASS)
      { 
	 LocalFBMFrames (memPtr, frameLen, MACNum, EACbits);
	 return;
      }
   }
   else
   {
#if 0
      fault_cnt = 1;
      printf("FBM%d: Rx other's frame (SA=%02x.%02x.%02x.%02x.%02x.%02x).\n", 
	     MACNum, frameHdr->macHdr.SA[0], frameHdr->macHdr.SA[1],
	     frameHdr->macHdr.SA[2], frameHdr->macHdr.SA[3],
	     frameHdr->macHdr.SA[4], frameHdr->macHdr.SA[5]);
      fault_cnt = 0;
#endif

      MCompareAddress (frameHdr->macHdr.DA, fbmMACData[MACNum].SMTAddress,
		       compare);
      if (compare)    /* the frame is not destinated to me */
      {
	 
	 MCompareAddress (frameHdr->macHdr.DA, BROADCAST_ADDRESS,
			  compare);
         if (compare)  /* if it's not a broadcast frame */
	 {
	    LocalFBMFrames (memPtr, frameLen, MACNum, EACbits);
	    return;
	 }
      }
   }

   RcvSignal (&FBMSyncSema);
   CheckSMTDBDBuffer();
#if 0
   fault_cnt = 1;
#endif
   ProcessFBMFrame (memPtr, frameLen, MACNum, EACbits);
#if 0
   fault_cnt = 0;
#endif
   SendSignal (&FBMSyncSema);
}

void
FBMInterruptHandler ()
/*********************************************************************
Function:	Handler interrupts to be reported to FBM.
Parameters:	None.
Input:		None.
Output:		Specific service functions will post signals for CMT.
Return:		None.
Note:		Interrupts are left disabled during FBM processing.
*********************************************************************/
{
   ProcState	pState;
   GenericMsgType *msg;
   word  bufLen;
   uInt32 i;
   uChar *ch;

   Running = TRUE;
   CreatMailbox (&RxSMTFrameMBox);
   CreatSemaphore(&FBMSyncSema, 1);

   while (Running)
   {
      msg = (GenericMsgType *) RcvMessage( &RxSMTFrameMBox);

      switch (msg->msg_type)
      {
         case DRV_RX_MSG_TYPE:
	      if (((PKT*) msg->ptr)->pktBufLink)
	      {
		 bufLen = ((PKT*) msg->ptr)->pktDataSize;
		 /* 
		  * db_buffer points to the word boundary,
		  * the FC actually starts from the 3rd byte from
		  * the word boundary.
		  * db_actcnt does not count the 3 padding bytes 
		  * of the FC field.
		 */
		 MEMCOPY(FrameBuffer+3, ((PKT*) msg->ptr)->pktBufPtr, bufLen);
		 MEMCOPY(FrameBuffer+bufLen+3, 
			 ((PKT*) msg->ptr)->pktBufLink->pktBufPtr, 
			 ((PKT*) msg->ptr)->pktBufLink->pktDataSize);
		 bufLen += ((PKT*) msg->ptr)->pktBufLink->pktDataSize;
#if 0
		 printf("xmt huge packet, len %d\n",bufLen);
#endif
#if 0
		 {
		    extern int fault_cnt;
		    fault_cnt = 1;
		    printf("FBM: Free the 2nd rx PKT %x (%d).\n",
			   ((PKT*) msg->ptr)->pktBufLink,
			   ((PKT*) msg->ptr)->pktBufLink->pktDataSize);
		    fault_cnt = 0;
		 }
#endif		 
#if 0
		 {
		    extern int fault_cnt;
		    fault_cnt = 1;
		    printf("FBM: Free the 1st rx DBD %x (%d).\n",
			   (DBD*) msg->ptr, ((DBD*) msg->ptr)->db_contrl);
		    fault_cnt = 0;
		 }
#endif		 
		 FreePktBuf(msg->ptr);
		 FBMDPT("Frame rxed from Driver.\n");

		 ProcessRxFrame(FrameBuffer, bufLen, msg->dev_num, 
				 GetEACbits(msg));
	      }
	      else
	      {
		 FBMDPT("Frame rxed from Driver.\n$");
#if 0
		 ch = (uChar*) ((DBD*) msg->ptr)->db_buffer;
		 for (i=0; i < ((DBD*) msg->ptr)->db_actcnt; i++)
		   {
		      printf("%2x ",  ch[i]);
		   }
		 printf("$\n");
#endif
		 
	         ProcessRxFrame(((PKT*) msg->ptr)->pktBufPtr, ((PKT*) msg->ptr)->pktDataSize,
				 msg->dev_num, GetEACbits(msg));
#if 0
		 {
		    extern int fault_cnt;
		    fault_cnt = 1;
		    printf("FBM: Free the rx DBD %x (%d).\n",
			   (PKT*) msg->ptr, ((PKT*) msg->ptr)->db_contrl);
		    fault_cnt = 0;
		 }
#endif		 
/*		 FreePktBuf(msg->ptr);  */
		 ((PKT*)msg->ptr)->pktFree(((PKT*) msg->ptr));
	      }
	      ReSchedule();
	      break;

         case MSG_FBM_TIMER_TIMEOUT:
	      {
		 RcvSignal (&FBMSyncSema);
		 CheckSMTDBDBuffer();
	         ProcessFBMTimer();
		 SendSignal (&FBMSyncSema);
		 break;
	      }

         case MSG_FBM_STOP:
	      {
		 Running = FALSE;
		 break;
	      }

	 default:
	      break;
      }
      FreeFDDIMsgHdr(msg);
   }
}

uInt32
InitFBMInterrupts ()
/*********************************************************************
Function:	Initialize system for processing FBM interrupts.
Parameters:	None.
Input:		None.
Output:		Set system signal processing.
Return:		0 if successful, error number if failed.
*********************************************************************/
{
   if (!(FBMstack = (word*) lmalloc(FBM_STACK_BYTE_SIZE)))
   {
      printf("\nFBM stack allocation fails.\n");
      return 1;
   }
   CreatTask(FBMInterruptHandler, FBMstack, FBM_STACK_BYTE_SIZE, NULL);
   ReSchedule();
   return (0);
}



void
FBMTerminate()
/*********************************************************************
Function:	Process a termination signal.
Parameters:	None.
Input:		None.
Output:		Notifies all other processes that FBM is terminating.
Return:		None. Program stops and exits.
*********************************************************************/
{
   GenericMsgType *msg;

   msg = (GenericMsgType *) GetFDDIMsgHdr();
   msg->msg_type = MSG_FBM_STOP;
   SendMessage((MSGHDR *) msg, &RxSMTFrameMBox);
   TimeStampEnable = FALSE;
   return;
}







