/*********************************************************************
	Frame Based Management Module

	Local ESF Processing Module

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		fbmesfif.c
	Created:	09/05/90

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	This module contains all implementor routines for handling
	Extended Service Frames.

	Modification History:
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"fbmframe.h"
#include	"fbmhdr.h"


/*********************************************************************
	Defined Values
*********************************************************************/


/*********************************************************************
	Global Data
*********************************************************************/


/*********************************************************************
	External Functions
*********************************************************************/


/*********************************************************************
	FBM Processing Routines
*********************************************************************/

uInt32
LocalESFAnnouncement (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:       This function is called from the ESF frame service
                routine. When this function is called, its E indicator
		and version have been checked for validity. If this routine
		returns any value other than RC_SUCCESS, then the
		calling routine generates an RDF using the value returned
		as the reason code.
Parameters:     memPtr          = address of frame buffer.
                frameLen        = length of frame (in bytes).
                MACNum          = MAC index that received the frame.
                EACbits         = EAC indicators as received by the MAC.
Input:          memPtr          = contains frame to process. This must
                                include the three pad bytes at the start
                                of the frame.
Output:         Local option.
Return:         RC_SUCCESS
			if this frame was accepted or processed.
		RC_FRAME_CLASS
			if this frame is not part of the local ESF
			protocol.
		Other error code
			frame not processed.
Modification History:
*********************************************************************/
{
	return (RC_FRAME_CLASS);
}

uInt32
LocalESFRequest (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:       This function is called from the ESF frame service
                routine. When this function is called, its E indicator
		and version have been checked for validity. If this routine
		returns any value other than RC_SUCCESS, then the
		calling routine generates an RDF using the value returned
		as the reason code.
Parameters:     memPtr          = address of frame buffer.
                frameLen        = length of frame (in bytes).
                MACNum          = MAC index that received the frame.
                EACbits         = EAC indicators as received by the MAC.
Input:          memPtr          = contains frame to process. This must
                                include the three pad bytes at the start
                                of the frame.
Output:         Local option.
Return:         RC_SUCCESS
			if this frame was accepted or processed.
		RC_FRAME_CLASS
			if this frame is not part of the local ESF
			protocol.
		Other error code
			used by calling routine to generate an RDF.
Modification History:
*********************************************************************/
{
	return (RC_FRAME_CLASS);
}

uInt32
LocalESFResponse (memPtr, frameLen, MACNum, EACbits)
	uChar	*memPtr;
	uInt16	frameLen;
	uInt16	MACNum;
	uChar	EACbits;
/*********************************************************************
Function:       This function is called from the ESF frame service
                routine. When this function is called, its E indicator
		and version have been checked for validity. If this routine
		returns any value other than RC_SUCCESS, then the
		calling routine generates an RDF using the value returned
		as the reason code.
Parameters:     memPtr          = address of frame buffer.
                frameLen        = length of frame (in bytes).
                MACNum          = MAC index that received the frame.
                EACbits         = EAC indicators as received by the MAC.
Input:          memPtr          = contains frame to process. This must
                                include the three pad bytes at the start
                                of the frame.
Output:         Local option.
Return:         RC_SUCCESS
			if this frame was accepted or processed.
		RC_FRAME_CLASS
			if this frame is not part of the local ESF
			protocol.
		Other error code
			frame could not be processed.
Modification History:
*********************************************************************/
{
	return (RC_FRAME_CLASS);
}

uInt32
InitESFLocal ()
/*********************************************************************
Function:	Provide initialization for local ESF support.
Parameters:	None.
Input:		
Output:		
Return:		0 if initialization is successful, otherwise an error
		code is returned.
*********************************************************************/
{
	return (0);
}

