/***********************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       mapper.c
 *      Created:	12/18/92
 *
 *      Description:    This file contains routines for building logical
 *			ring map.
 *
 *      $log$
 *
 *
 ***********************************************************************
 */

#include <krnl.h>
#include <types.h>
#include <sys.h>
#include <constant.h>
#include <call_svc.h>
#include <errors.h>
#include <except.h>
#include <fdrextrn.h>

#include "smtdefs.h"
#include "smttypes.h"
#include "smtmsg.h"
#include "fddihdr.h"
#include "fbmframe.h"
#include "fbmmacro.h"
#include "mibdefs.h"
#include "maphdr.h"
#include "mapglbl.h"
#include "fbmhdr.h"
#include "fbmglbl.h"


#define TEST_MAPPER 1


/*********************************************************************
        External functions 
*********************************************************************/
extern  uInt32  ntohl ();
extern  uInt32  htonl ();
extern  uChar *FindFrameParam ();
extern  HOSTENTRY *MONP_hash (byte *, uint32, bool);
extern  scr_pause();
extern BuildRingOrder(HOSTENTRY *, HOSTENTRY *, uInt); 
extern void CopyRingMap(uInt); 
extern void ReInitWorkRingMap(uInt); 

/*********************************************************************
        Global Data
*********************************************************************/





print_MacAddr(msg, addr)
	char *msg;
	MACAddr48 addr;
{
	printf (" %s: ", msg);
	printf ("%x.%x.%x.%x.%x.%x ",
                addr[0],
                addr[1],
                addr[2],
                addr[3],
                addr[4],
                addr[5]);
	printf("\n");
}

/*****************************************************************************
 Debug Print Routine for Queue. 
 *****************************************************************************/
print_HostEntry(RSE)
HOSTENTRY *RSE;
{
	
        printf("HEMac: %x.%x.%x.%x.%x.%x ",
		RSE->macAddress[1],RSE->macAddress[2],
                RSE->macAddress[3],RSE->macAddress[4],
		RSE->macAddress[5],RSE->macAddress[6]);
 	
        printf("UNA: %x.%x.%x.%x.%x.%x ",
		RSE->rs_entry->LastUNA[1],RSE->rs_entry->LastUNA[2],
		RSE->rs_entry->LastUNA[3],RSE->rs_entry->LastUNA[4],
		RSE->rs_entry->LastUNA[5],RSE->rs_entry->LastUNA[6]);
#ifdef 0
        printf("(%d,%d,%d,%d,%d,%d) ",
		RSE->macAddress[1],RSE->macAddress[2],
                RSE->macAddress[3],RSE->macAddress[4],
		RSE->macAddress[5],RSE->macAddress[6]);
#endif

	printf("\n");
}

/***************************************************************************
 This routine sets prev field of this_node point to una_node and next field
 of una_node point to this_node. Returns true if successsful, otherwise 
 false.   
***************************************************************************/
int set_next_prev  
(queue_head FAR * head, void FAR * this_node, void FAR * una_node)
{
int success_flag;

	if ( head == NULL )
		success_flag = FALSE;
	else if (this_node == NULL)
		success_flag = FALSE;
	else if (una_node == NULL)
		success_flag = FALSE;
	else 
	{
	   ((queue_node FAR *)((int)this_node + head->offset))->my_self =  
				(queue_node FAR *) this_node ;
	
	   ((queue_node FAR *)((int)this_node + head->offset))->prev =  
				(queue_node FAR *) una_node ;

	   ((queue_node FAR *)((int)una_node + head->offset))->my_self = 
				(queue_node FAR *) una_node ;
	   ((queue_node FAR *)((int)una_node + head->offset))->next = 
				(queue_node FAR *) this_node ;

	   success_flag = TRUE;
	}
#ifdef 0
	else 
	{
          if (head->queue_list.my_self != head )
               error(q_next_in_queue_error+q_bad_head,"next_in_queue: Invalid head"); /* Never returns */
          if (((queue_node FAR *)((int)this_node + head->offset))->my_self != this_node )
               error(q_next_in_queue_error+q_bad_node,"next_in_queue: Invalid this_node"); /* Never returns */
          if (((queue_node FAR *)((int)una_node + head->offset))->my_self != una_node )
               error(q_next_in_queue_error+q_bad_node,"next_in_queue: Invalid una_node"); /* Never returns */

	   ((queue_node FAR *)((int)this_node + head->offset))->prev =  
				(queue_node FAR *) una_node ;
	   ((queue_node FAR *)((int)una_node + head->offset))->next = 
				(queue_node FAR *) this_node ;

	   success_flag = TRUE;
	}
#endif


#ifdef TEST_MAPPER
	printf("\nIn set_n_p Link built una src:\n");
	print_HostEntry(((queue_node FAR *)((int)this_node + head->offset))->prev);
	print_HostEntry((HOSTENTRY *)this_node);

	if (success_flag = FALSE)
		printf("\nset_next_prev routine failed.\n"); 
#endif

	return success_flag;
}

/***************************************************************************
 This routine sets prev field of this_node point to null and next field
 of this_node point to null. Returns true if successsful, otherwise 
 false.   
***************************************************************************/
int set_to_null  
(queue_head FAR * head, void FAR * this_node)
{
int success_flag;

	if ( head == NULL )
	{
		printf("set_to_null failed\n");
		success_flag = FALSE;
		return;
	}
	else if (this_node == NULL)
	{
		printf("set_to_null failed\n");
		success_flag = FALSE;
		return;
	}
	else 
	{
printf("this node deleted: %lx\n",this_node);
		((queue_node FAR *)((int)this_node + head->offset))->prev =  
				(queue_node FAR *) NULL;
		((queue_node FAR *)((int)this_node + head->offset))->next = 
				(queue_node FAR *) NULL ;

		success_flag = TRUE;
#ifdef 0
		printf("set_to_null successful\n");
#endif

	   	return;
	}

}
/***************************************************************************
 This routine checks if this_node is present in the recent Ring Map built 
 that is, in the Work RingOrder queue. Returns true if present, otherwise 
 false.   
***************************************************************************/
int IsHostActive  
(queue_head FAR * head, void FAR * this_node)
{
queue_node *prev, *next;

#ifdef TEST_MAPPER
printf("In IsHostActive\n");
#endif
 
	if ( head == NULL )
	{
		printf("IsHostActive failed\n");
		return;
	}
	else if (this_node == NULL)
	{
		printf("IsHostActive failed\n");
		return;
	}
	else 
	{
		prev = ((queue_node FAR *)
				((int)this_node + head->offset))->prev;
		next = ((queue_node FAR *)
				((int)this_node + head->offset))->next; 
#ifdef TEST_MAPPER
printf("Work Qu prev: %lx this_node: %lx next: %lx\n", prev, this_node, next);
#endif

		if ( (prev == NULL) && (next == NULL) )
		{
		
			printf("return false\n");
			return FALSE;
		}
		else
		{
			printf("return true\n");
			return TRUE;
		}
	}
}

/***************************************************************************
 This routine checks if the host entry pointed to by pHE is present in the 
 recent Ring Map built that is, the Work RingOrder queue. Returns true if 
 present, otherwise false.   
***************************************************************************/
int IsHostActiveDead(Head, pHE)
	queue_head *Head;
	HOSTENTRY *pHE;
{
        HOSTENTRY *pcur, *pFirst;
 
#ifdef TEST_MAPPER
printf("In IsHostActive\n");
#endif
        pFirst = pcur = (HOSTENTRY *)first_in_queue(Head);

        if ( pFirst == NULL )
                printf("IsHostActive failed\n");

        while ( pcur != pHE)
        {
                pcur = (HOSTENTRY *)next_in_queue(Head, pcur);
                if ( pcur == pFirst )
		{
			printf("return false\n");
			return FALSE;
		}
        }
	printf("return true\n");
        return TRUE;
}



extern uChar Addr5[];
uchar Pri_Addr[7]  = "\006\001\001\002\002\002\001";
uchar Sec_Addr[7]  = "\006\001\001\002\002\002\011";



/*****************************************************************************
 This routine initializes certian parameters for building logical ring map.
 *****************************************************************************/
InitRingMap( MacNum, Head)
uInt MacNum;
queue_head *Head;
{
HOSTENTRY 	*pHEntry; 

	if (MacNum == 0)
		pHEntry = MONP_hash((byte *)&Pri_Addr[1], MacNum, TRUE);
 	else	
		pHEntry = MONP_hash((byte *)&Sec_Addr[1], MacNum, TRUE);
	 

#ifdef TEST_MAPPER
	if (MacNum == 0)
        	print_MacAddr("Pri: ",&(pHEntry->macAddress[1]));
	else
        	print_MacAddr("Sec: ",&(pHEntry->macAddress[1]));
#endif

	if (pHEntry->rs_entry == NULL)
	{
#ifdef TEST_MAPPER
		printf("\nGet Buffer for fddi_rs_entry\n");
#endif
		pHEntry->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
		if ( pHEntry->rs_entry == NULL)
		{
			printf("fatal error: get_rs_entry failed\n");
			return;
		}	
		
#if 0
        	get_simple_svc( sysUpTime, &(pHEntry->rs_entry->LastEnterTime), 
				&len);
        	pHEntry->rs_entry->StationStatus = 1; 
#endif
	}

	push_queue(Head,pHEntry);
	
}
	
#ifdef 0
/*****************************************************************************
 This routine processes SMT messages received as a result of sending a broadcast
 SIF Request for the purpose of building logical ring map.
 *****************************************************************************/
BuildRingMap(msg)
	SMTMessage      *msg;
{
SendFrameBuf    *sendBuf;
MACAddr48       destAddr;
RecFrameBuf     *recBuf;
SMTFrameHdrType *frameHdr;
MACAddr48	SrcAddr, UNAAddr;
uInt16		MacNum;  
ParamHdrType    *phdr;
UNAParamType    *unaptr;
MACNeighborsParamType    *MacNeighbrptr;
HOSTENTRY 	*pSrcHostEntry, *pUNAHostEntry; 
Int16 		compare;

	/* get smt frame */ 
	frameHdr = (SMTFrameHdrType *) msg->p2;

#ifdef TEST_MAPPER
        printf ("Received %s %s from ",
        	FRAMECLASS[frameHdr->smtHdr.Frame_Class],
        	FRAMETYPE[frameHdr->smtHdr.Frame_Type]);
        print_MacAddr("Src: ", frameHdr->macHdr.SA);
        printf ("ID = %ld\n",
                ntohl (frameHdr->smtHdr.Transaction_ID));
#endif  	

	/* 
	 * copy SrcAddr and MacNum  
	 */
	MCopyAddress(SrcAddr,frameHdr->macHdr.SA);
	MacNum = msg->entity; 

#ifdef 0
	/*
        *       Get parameter header.
        */
        phdr = (ParamHdrType *) (frameHdr + 1);

	if ( (ntohs (phdr->type)) == UNA_PARAM_TYPE)
        { 
        	unaptr = (UNAParamType *) phdr;
		MCopyAddress(UNAAddr,unaptr->UNA);
	}
	else
	{
		printf("\nFatal Error: UNA not in info field\n");
		return;
	}
#endif

	/* locate MAC Neighbors parameter */
	MacNeighbrptr = (MACNeighborsParamType *) FindFrameParam
				(MAC_NEIGHBORS_PARAM_TYPE, msg->p2);	
	
	MCopyAddress(UNAAddr,MacNeighbrptr->UNA);

#ifdef TEST_MAPPER
        print_MacAddr("Src: ", SrcAddr);
        print_MacAddr("  UNA: ",UNAAddr);
	printf("  MacNum:  %d\n", MacNum);
	printf("  IsRingClosed:  %d\n", 
			fddiHost_control_tbl[MacNum].IsRingClosed);
#endif

	pSrcHostEntry = MONP_hash((byte *)SrcAddr, MacNum, TRUE);

	if (pSrcHostEntry == NULL)
	{
		printf("\nfatal error: Hash returned a null ptr\n");
		return;
	}
	
	if (pSrcHostEntry->rs_entry == NULL)
	{
#ifdef TEST_MAPPER
		printf("\nGet Buffer for Src fddi_rs_entry\n");
#endif
		pSrcHostEntry->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
		if ( pSrcHostEntry->rs_entry == NULL)
		{
			printf("fatal error: get_rs_entry failed\n");
			return;
		}	
#if 0
        	get_simple_svc( sysUpTime, 
			&(pSrcHostEntry->rs_entry->LastEnterTime),&len);
        	pSrcHostEntry->rs_entry->StationStatus = 1; 
#endif
	}

	MCompareAddress(UNAAddr,NULL_ADDRESS, compare);

	if (compare == 0)
	/* UNA is a null-address then do nothing */
	{
#ifdef TEST_MAPPER
		printf("\nUNA is nul_address.\n");
#endif
		return;
	}

	pUNAHostEntry = MONP_hash((byte *)UNAAddr, MacNum, TRUE);
	
	if (pSrcHostEntry == NULL)
	{
		printf("\nHash returned a null ptr\n");
		return;

	}
	if (pUNAHostEntry->rs_entry == NULL)
	{
#ifdef TEST_MAPPER
		printf("\nGet Buffer for UNA fddi_rs_entry\n");
#endif
		pUNAHostEntry->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
		if ( pUNAHostEntry->rs_entry == NULL)
		{
			printf("get_rs_entry failed\n");
			return;
		}	
#if 0
        	get_simple_svc( sysUpTime, 
			&(pUNAHostEntry->rs_entry->LastEnterTime),&len);
        	pUNAHostEntry->rs_entry->StationStatus = 1; 
#endif
	}


	BuildRingOrder(pSrcHostEntry,pUNAHostEntry,MacNum);
}
#endif	


BuildRingMap(Src, UNA, Num)
	uChar *Src, *UNA;
	uInt16	Num;
{
SendFrameBuf    *sendBuf;
MACAddr48       destAddr;
RecFrameBuf     *recBuf;
SMTFrameHdrType *frameHdr;
MACAddr48	SrcAddr, UNAAddr;
uInt16		MacNum;  
ParamHdrType    *phdr;
UNAParamType    *unaptr;
MACNeighborsParamType    *MacNeighbrptr;
HOSTENTRY 	*pSrcHostEntry, *pUNAHostEntry; 
Int16 		compare;
uInt		len;

	MCopyAddress(SrcAddr,Src);
	MCopyAddress(UNAAddr,UNA);
	MacNum = Num;

#ifdef TEST_MAPPER
	printf("\nNew Call:\n");
        print_MacAddr("Src", SrcAddr);
        print_MacAddr("UNA: ",UNAAddr);
	printf(" MacNum: %d\n", MacNum);
	printf(" Valid: %d", 
			fddiHost_control_tbl[MacNum].IsRingMapValid);
	printf(" UNAChanged: %d", 
			fddiHost_control_tbl[MacNum].HasUNAChanged);
	printf(" ROChanged: %d\n\n", 
			fddiHost_control_tbl[MacNum].RingOrderChanged);
#endif

	pSrcHostEntry = MONP_hash((byte *)SrcAddr, MacNum, TRUE);
	
	if (pSrcHostEntry == NULL)
	{
		printf("\nHash returned a null ptr\n");
		return;
	}

	if (pSrcHostEntry->rs_entry == NULL)
	{
#ifdef TEST_MAPPER
		printf("Get Buffer for Src fddi_rs_entry\n");
#endif
		pSrcHostEntry->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
		if ( pSrcHostEntry->rs_entry == NULL)
		{
			printf("get_rs_entry failed\n");
			return;
		}	
#if 0
        	get_simple_svc( sysUpTime, 
			&(pSrcHostEntry->rs_entry->LastEnterTime),&len);
        	pSrcHostEntry->rs_entry->StationStatus = 1; 
#endif
	}

	MCompareAddress(UNAAddr,NULL_ADDRESS, compare);

	if (compare == 0)
	/* UNA is a null-address then do nothing */
	{
#ifdef TEST_MAPPER
		printf("UNA is nul_address.\n");
#endif
		return;
	}

	pUNAHostEntry = MONP_hash((byte *)UNAAddr, MacNum, TRUE);
	
	if (pUNAHostEntry == NULL)
	{
		printf("\nFatal Error: Hash returned a null ptr\n");
		return;
	}

	if (pUNAHostEntry->rs_entry == NULL)
	{
#ifdef TEST_MAPPER
		printf("Get Buffer for UNA fddi_rs_entry\n");
#endif
		pUNAHostEntry->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
		if ( pUNAHostEntry->rs_entry == NULL)
		{
			printf("get_rs_entry failed\n");
			return;
		}	
#if 0
        	get_simple_svc( sysUpTime, 
			&(pUNAHostEntry->rs_entry->LastEnterTime),&len);
        	pUNAHostEntry->rs_entry->StationStatus = 1; 
#endif
	}

#if 0
        print_MacAddr("UNA",&(pUNAHostEntry->macAddress[1]));
        print_MacAddr("Src",&(pSrcHostEntry->macAddress[1]));
#endif

#ifdef 0
	printf("In BRiMap UNA Src after hash:\n");
	print_HostEntry(pUNAHostEntry);
	print_HostEntry(pSrcHostEntry);
	printf("\n");
#endif

#ifdef 0
	printf("In BRiMap UNA Src after cp:\n");
        print_MacAddr("UNA",&(pUNAHostEntry->macAddress[1]));
        print_MacAddr("Src",&(pSrcHostEntry->macAddress[1]));
	print_HostEntry(pUNAHostEntry);
	print_HostEntry(pSrcHostEntry);
	printf("\n");
#endif
	
	scr_pause();
	BuildRingOrder(pSrcHostEntry,pUNAHostEntry, (uInt)MacNum);
}


/*****************************************************************************
 This routine uses SRC Addr and UNA Addr obtained from SIF Response Frame to
 build individual links which in turn form a close ring. 
 *****************************************************************************/
BuildRingOrder(pSrc, pUNA, MacNum)
	HOSTENTRY *pSrc, *pUNA;
	uInt MacNum;
{
HOSTENTRY *pHE, *pFirst, *pcur;
MACAddr48	MacAddr;
Int16 compare;
uInt q_size, len;
queue_head *Head;

	Head = fddiHost_control_tbl[MacNum].WorkHead ;

		/*
	pFirst = (HOSTENTRY *) first_in_queue
			(&(fddiHost_control_tbl[MacNum].WorkRingOrderHead));
		 */

	/* get Host Entry for Pri or Sec MAC of HLS Con */
	pFirst = (HOSTENTRY *) first_in_queue(Head);

	if (pFirst == NULL)
	{
		printf("fatal error: first_in_queue returned a null ptr\n");
		return;
	}

#ifdef 0
	printf("Inside BuildRingOrder:\n");
#endif

#ifdef 0
        /* get the most recent UNA of HLS Concentrator */
        MCopyAddress(MacAddr, fbmMACData[MacNum].UNA);
#endif
        /* temporary */
        MCopyAddress(MacAddr, Addr5);

	if (MacNum == 0)
	{
#ifdef TEST_MAPPER
        print_MacAddr("Pri",MacAddr);
        print_MacAddr("UNA of Pri",MacAddr);
#endif
	}
	else
	{
#ifdef TEST_MAPPER
        print_MacAddr("Sec",MacAddr);
        print_MacAddr("UNA of Sec",MacAddr);
#endif
	}


	MCompareAddress(MacAddr,NULL_ADDRESS, compare);

	if (compare != 0 )
	/* UNA of HLS Con not a NULL_ADDRESS */
	{
		pHE = MONP_hash((byte *)MacAddr, MacNum, TRUE);

		if (pHE == NULL)
		{
			printf("fatal error: Hash returned a null ptr\n");
			return;
		}

		if (pHE->rs_entry == NULL)
		{
#ifdef TEST_MAPPER
printf("Get Buffer for HLS Con UNA fddi_rs_entry\n");
#endif
			pHE->rs_entry = (FDDI_RS_ENTRY *) get_rs_entry(MacNum);
			if ( pHE->rs_entry == NULL)
			{
				printf("get_rs_entry failed\n");
				return;
			}	
#if 0
        	get_simple_svc( sysUpTime, 
			&(pHE->rs_entry->LastEnterTime),&len);
        	pHE->rs_entry->StationStatus = 1; 
#endif
		}
	
		pFirst->rs_entry->LastUNA[0] = 6;
		MCompareAddress(&(pFirst->rs_entry->LastUNA[1]),
			&(pHE->macAddress[1]), compare);

		if ( compare != 0 )
		/* UNA of the HLS Con has changed */
		{
			memcpy(&(pFirst->rs_entry->LastUNA[1]), 
				&(pHE->macAddress[1]), 6);

			fddiHost_control_tbl[MacNum].HasUNAChanged = TRUE;
#ifdef TEST_MAPPER
printf("\nUNA of HLS Con has Changed\n ");
#endif
		}
#if 0
		printf("UNA Head:\n");
		print_HostEntry(pHE);
		print_HostEntry(pFirst);
#endif
		set_next_prev(Head,pFirst,pHE);
	}
			
	pSrc->rs_entry->LastUNA[0] = 6;
	MCompareAddress(&(pSrc->rs_entry->LastUNA[1]),
			&(pUNA->macAddress[1]), compare);
	if ( compare != 0 )
	/* UNA of the Src has changed */
	{
		memcpy(&(pSrc->rs_entry->LastUNA[1]), 
			&(pUNA->macAddress[1]), 6);

		fddiHost_control_tbl[MacNum].HasUNAChanged = TRUE; 
#ifdef TEST_MAPPER
printf("\nUNA of Src has Changed\n ");
#endif
	}

	printf("In BuilRO UNA Src:\n ");
	print_HostEntry(pUNA);
	print_HostEntry(pSrc);

	set_next_prev(Head,pSrc,pUNA);
	 
	scr_pause();

	/* check if the ring is closed with the host entries
	discovered so far for the RingOrder Queue */
	pcur = pFirst ;

	while (TRUE)
	{
#ifdef TEST_MAPPER
		print_HostEntry(pcur);
		/*
		printf("value of pcur %lx\n", pcur);
		*/
#endif
		pcur = (HOSTENTRY *) next_in_queue
			(Head, pcur);
	
		if ( pcur == NULL) 
		{ 
			printf("Ring NOT Closed for mac: %d\n", MacNum);
			break;
		}
		if ( pcur == pFirst )
		{
			printf("Ring Closed for mac: %d\n", MacNum);
			fddiHost_control_tbl[MacNum].IsRingMapValid = FALSE;
			ReInitWorkRingMap(MacNum);	
			fddiHost_control_tbl[MacNum].IsRingMapValid = TRUE;
			break;
		}
	}

	return;
}

#ifdef 0
/*****************************************************************************
 This routine copies the Working RingOrder queue to Current RingOrder queue
 provided the RingOrder has changed. 
 *****************************************************************************/
void CopyRingMap(MacNum)
	uInt MacNum;
{
HOSTENTRY *pFirst, *pcur;
uInt curq_size, i, workq_size;
queue_head *CurHead, *WorkHead;
uInt loopcount = 0;

	printf("Calling CopyRingMap\n");

	if ( fddiHost_control_tbl[MacNum].RingOrderChanged == 0 &&
		fddiHost_control_tbl[MacNum].FirstTimeCopy ) 
	/* Ring Order did not change; so do not perform copying */
	{
printf("Ring Order did not change\n");
		return;
	}

	if ( fddiHost_control_tbl[MacNum].FirstTimeCopy ) 
	{
		/* set RingOderChanged flag to false */
		fddiHost_control_tbl[MacNum].RingOrderChanged = FALSE;
		printf( "loopcount: %d, ROChanged: %d\n", ++loopcount, 
			fddiHost_control_tbl[MacNum].RingOrderChanged);

		CurHead = &(fddiHost_control_tbl[MacNum].RingOrderHead);

		/* get the size of Current Ring Order Queue */
		curq_size = size_of_queue(CurHead);

		printf("before de_queue q_size %d\n", curq_size);

		while (TRUE)
		{
			if (is_empty_queue(CurHead))
				break;
			pcur = (HOSTENTRY *)de_queue(CurHead);
			set_to_null(CurHead, pcur);

		}
	
		curq_size = size_of_queue(CurHead);
		printf("aftre de_queue q_size %d\n", curq_size);
	
		/* reintialize the Current RingOrder queue */
		CurHead->front = NULL;
		CurHead->back  = NULL;
		CurHead->size  = 0 ;

	}

	WorkHead = &(fddiHost_control_tbl[MacNum].WorkRingOrderHead);
	CurHead = &(fddiHost_control_tbl[MacNum].RingOrderHead);

	pFirst = (HOSTENTRY *) first_in_queue(WorkHead);

	pcur = pFirst; 

	workq_size = 0;

	while (TRUE) 
	{
		append_queue(CurHead, pcur);
		workq_size++;
		pcur = (HOSTENTRY *) next_in_queue(WorkHead, pcur);
		if (pcur == pFirst)
		{
			printf("Ring Map Copied for Mac: %d\n", MacNum);
			break;
		}
	}

	WorkHead->size = workq_size;

#ifdef TEST_MAPPER
		printf("Determined Size of Work RO Queue %d\n", workq_size);
		printf("New Current Ring Map\n");
		scr_pause();
#endif

	pFirst = pcur = (HOSTENTRY *) first_in_queue(CurHead);


	while (TRUE) 
	{
#ifdef TEST_MAPPER
		print_HostEntry(pcur);
#endif
		pcur = (HOSTENTRY *) next_in_queue(CurHead,pcur);
	
		if (pcur == pFirst)
		{
			break;
		}
	}
		
	/* copied Working RingOrder Queue to Current RingOrder Queue    
	 for first time  
	*/
	fddiHost_control_tbl[MacNum].FirstTimeCopy = TRUE;

	scr_pause();
}
#endif

/*****************************************************************************
 This routine updates the status of hosts after a new ring map is built. 
 *****************************************************************************/
void UpdateHostStaus(MacNum)
	uInt MacNum;
{
queue_head *WorkHead, *CurHead;
HOSTENTRY *pFirst, *pcur, *temp1, *temp2;
	
	WorkHead = fddiHost_control_tbl[MacNum].WorkHead;
	CurHead = fddiHost_control_tbl[MacNum].CurHead;

#ifdef TEST_MAPPER
printf("In UpdateHostStatus loop:\n");
#endif
	pFirst = pcur = (HOSTENTRY *) first_in_queue(CurHead);

	while (TRUE) 
	{
		pcur = (HOSTENTRY *) next_in_queue(CurHead,pcur);
		temp1 = (HOSTENTRY *) prev_in_queue(CurHead,pcur);
		temp2 = (HOSTENTRY *) next_in_queue(CurHead,pcur);
print_HostEntry(pcur);
printf("Cur Queue: temp1 %lx, pcur %lx, temp2 %lx\n", temp1, pcur, temp2);
		if ( IsHostActive(WorkHead,pcur) == 0)
		{
#ifdef TEST_MAPPER
printf("Has become Inactive:\n");
#endif
			#ifdef 0
        		pHE->rs_entry->StationStatus = 3; 
        		get_simple_svc( sysUpTime, 
				&(pRSE->rs_entry->LastExitTime), &len);
			#endif
		}
scr_pause();
		if (pcur == pFirst)
			break;
	}
}

void CompQueueSize(MacNum)
	uInt MacNum;
{
queue_head *WorkHead;
HOSTENTRY *pFirst, *pcur;
uInt workq_size;

	WorkHead = fddiHost_control_tbl[MacNum].WorkHead;
	pFirst = pcur = (HOSTENTRY *) first_in_queue(WorkHead);
	workq_size = 0;

	while (TRUE) 
	{
		workq_size++;
		pcur = (HOSTENTRY *) next_in_queue(WorkHead, pcur);
		if (pcur == pFirst)
			break;
	}

	WorkHead->size = workq_size;

#ifdef TEST_MAPPER
	printf("Computed Workq_size: %d\n", WorkHead->size );
#endif
	return;
}

/*****************************************************************************
 This routine reinitializes the Working RingOrder queue after a closed ring is 
 formed. 
 *****************************************************************************/
void ReInitWorkRingMap(MacNum)
	uInt MacNum;
{
uInt curq_size;
HOSTENTRY *pcur, *pFirst;
queue_head *WorkHead, *CurHead, *temp;

#ifdef TEST_MAPPER
	printf("Calling ReInitWorkRiMap for Mac: %d\n", MacNum);
#endif

	/* compute size of Work RingOrder Queue */
	CompQueueSize(MacNum);

	if (fddiHost_control_tbl[MacNum].HasUNAChanged)  
	{
#ifdef TEST_MAPPER
	printf("UNAs changed. So Swap Heads\n");
#endif
		curq_size = size_of_queue(fddiHost_control_tbl[MacNum].CurHead);
		printf("curq_size %d\n", curq_size);

		if (!(is_empty_queue( fddiHost_control_tbl[MacNum].CurHead)))
		/* if Current RingOrder Queue is not empty then update
		the status of Hosts 
		 */
		{
			printf("Calling UpdateHostStatus\n");
			UpdateHostStaus(MacNum);
		}
		temp = fddiHost_control_tbl[MacNum].CurHead;
		fddiHost_control_tbl[MacNum].CurHead = 
			fddiHost_control_tbl[MacNum].WorkHead;
		fddiHost_control_tbl[MacNum].WorkHead = temp; 

		fddiHost_control_tbl[MacNum].HasUNAChanged = FALSE;  
	}

	WorkHead = fddiHost_control_tbl[MacNum].WorkHead;
	CurHead = fddiHost_control_tbl[MacNum].CurHead;

#ifdef TEST_MAPPER
		printf("Current Ring Map for Mac: %d\n", MacNum);
#endif

	pFirst = pcur = (HOSTENTRY *) first_in_queue(CurHead);

	while (TRUE) 
	{
#ifdef TEST_MAPPER
		print_HostEntry(pcur);
#endif
		pcur = (HOSTENTRY *) next_in_queue(CurHead,pcur);
		if (pcur == pFirst)
			break;
	}

	scr_pause();
	printf("Doing ReInitWorkRiMap\n");

	/* Empty the Work RingOrder queue inorder to build 
	 * a new ring map
	 */
	while (TRUE)
	{
		if (is_empty_queue(WorkHead))
			break;
		pcur = (HOSTENTRY *)de_queue(WorkHead);
		set_to_null(WorkHead,pcur);

	}
	

	/* reintialize the Working RingOrder queue */
	WorkHead->front = NULL;
	WorkHead->back  = NULL;
	WorkHead->size  = 0 ;
	


	InitRingMap(MacNum, WorkHead);
}
		
/*****************************************************************************
 * This function checks if the host entry for the given MAC Addr is present 
 * in the RingOrder Queue.              
 *****************************************************************************/
HOSTENTRY *OnTheRing(addr,RingOrderHead)
	u_char *addr;
	queue_head *RingOrderHead;
{
        HOSTENTRY *pRSE, *pFirstRSE;
 
        pFirstRSE = pRSE = (HOSTENTRY *)first_in_queue(RingOrderHead);
        while ( pRSE != NULL)
        {
                if ( !memcmp(&(pRSE->macAddress[1]), addr, 6) )
                        return pRSE;
                pRSE = (HOSTENTRY *)next_in_queue(RingOrderHead, pRSE);
                if ( pRSE == pFirstRSE) 
			break;
        }
        return NULL;
}


/*****************************************************************************
 * This function checks if the host entry pointed to by pRSE is present 
 * in the RingOrder Queue.              
 *****************************************************************************/
int InTheRing(pRSE, RingOrderHead)
	HOSTENTRY *pRSE;
	queue_head *RingOrderHead;
{
        HOSTENTRY *pRingRSE, *pFirstRSE;
 
        pFirstRSE = pRingRSE = (HOSTENTRY *)first_in_queue(RingOrderHead);
        if ( pFirstRSE == NULL )
                return FALSE;
        while ( pRingRSE != pRSE)
        {
                pRingRSE = (HOSTENTRY *)next_in_queue(RingOrderHead, pRingRSE);
                if ( pRingRSE == pFirstRSE )
                        return FALSE;
        }
        return TRUE;
}

/*****************************************************************************
 * This function inserts a Station into the Ring Order Queue. 
 *****************************************************************************/
void InsertRingOrderEntry(pUNA, pRSE, RingOrderHead, MacNum)
	HOSTENTRY *pUNA, *pRSE;
	queue_head *RingOrderHead;
	uint16 MacNum;
{
        uint    len = 4;
        HOSTENTRY *pDNA;
 
#ifdef 0
        if ( pRSE->pNPStats->status == RSE_INACTIVE)
                detatch_queue( &InactRSEHead, pRSE);

        if ( pUNA == NULL)
                push_queue( RingOrderHead, pRSE);
        else
#endif
        insert_queue(RingOrderHead, pRSE, pUNA);
 
        pRSE->rs_entry->StationStatus = 1;
        fddi_rs_control_tbl[MacNum].ActiveStations++;
        fddi_rs_control_tbl[MacNum].Changes++;
        get_simple_svc( sysUpTime, &(pRSE->rs_entry->LastEnterTime), &len);
 
        if ( pUNA != NULL)
                memcpy(&(pRSE->rs_entry->LastUNA[1]), &(pUNA->macAddress[1]), 6);

#if TEST_MAPPER
	printf("Inserted: ");
	print_HostEntry(pRSE);
#endif

#if 0
        pDNA = (HOSTENTRY *)next_in_queue(RingOrderHead, pRSE);
        if ( pDNA)
                memcpy(&(pDNA->rs_entry->LastUNA[1]), &(pRSE->macAddress[1]), 6);
#endif
	return;
}
 
/*****************************************************************************
 * This function removes a Station from the Ring Order Queue. 
 *****************************************************************************/
void RemoveRingOrderEntry(pRSE, RingOrderHead, MacNum)
        HOSTENTRY *pRSE;
        queue_head *RingOrderHead;
	uint16 MacNum;
{
uint    len=4;
HOSTENTRY *pDNA;

        /* update UNA of the downstream neighbor */
        pDNA = (HOSTENTRY *)next_in_queue(RingOrderHead, pRSE);
        if ( pDNA)
                memcpy(&(pDNA->rs_entry->LastUNA[1]), 
			pRSE->rs_entry->LastUNA, 6);
        detatch_queue(RingOrderHead, pRSE);
#ifdef 0
        append_queue( &InactRSEHead, pRSE);
#endif
        pRSE->rs_entry->StationStatus = 3;
        fddi_rs_control_tbl[MacNum].ActiveStations--;
        fddi_rs_control_tbl[MacNum].Changes++;
        get_simple_svc( sysUpTime, &(pRSE->rs_entry->LastExitTime), &len);

	return;
}


/*****************************************************************************
 This routine uses SRC Addr and UNA Addr obtained from SIF Response Frame to
 update the Ring ( RingOrder Queue ). 
 *****************************************************************************/
UpdateRingOrder(pSrc, UNAAddr, MacNum)
	HOSTENTRY *pSrc;
	u_char *UNAAddr;	
	uint16 MacNum;
{
        HOSTENTRY *pPrevRSE, *pUNARSE;
	queue_head *ROHead;
 
	/* get head of RingOrder queue */
	ROHead = &(fddiHost_control_tbl[MacNum].RingOrderHead);

#ifdef TEST_MAPPER
        print_MacAddr( "\nUpdate ring order:  Source ", &(pSrc->macAddress[1]));
        print_MacAddr( "  UNA ", UNAAddr);
#endif
        if ( OnTheRing(&(pSrc->macAddress[1]),ROHead) )         
	/* MAC on the ring */
        {
                if ( memcmp(&(pSrc->rs_entry->LastUNA[1]), UNAAddr, 6) )
                {       /* UNA has changed, delete stations in between */
                        if ( (pUNARSE=OnTheRing(UNAAddr,ROHead)) )
                        {       /* UNA on the ring */
                                memcpy(&(pSrc->rs_entry->LastUNA[1]), UNAAddr, 6);
                                pPrevRSE = (HOSTENTRY *)prev_in_queue(ROHead, pSrc);
                                while ( pPrevRSE != pUNARSE)
                                {
                                        RemoveRingOrderEntry( pPrevRSE,ROHead,
								MacNum);
                                        pPrevRSE = (HOSTENTRY *)prev_in_queue
								( ROHead, pSrc);
                                }
                        }
                }
        }
        else    
	/* MAC not on the ring */
        {
                if ( (pUNARSE = OnTheRing(UNAAddr,ROHead) ) != NULL)
		/* insert MAC after UNA provided UNA on ring */
                        InsertRingOrderEntry(pUNARSE,pSrc,ROHead,MacNum);
#ifdef 0
		else
		{ /* Both MAC and UNA not on the ring */

			/* do nothing */
                        if ( StationCtrlTab.activeStationNum == 0)
                                InsertRingOrderEntry( NULL, pSRc);
                }
#endif
        }
#ifdef TEST_MAPPER
        printf( "  finished.");
#endif
}

int scr_pause(void)
{
    int st;
 
    printf("<T any key>");
    while ((st = getch()) == -1)
        ReSchedule();
        /*
         *      12.19.91        K Kong
         *      abort on ctrl-c.
         *
         */
	/*
    if (st == 0x03 || st == TELNET_EOF || !ConsoleActive)
        st = TELNET_EOF;
	 */ 

    printf("\n");
    return st;
}

