/*********************************************************************
	Management Application Module

	MAP PATH Control Module

	File:		mapmpath.c
	Created:	04/01/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module provides the Station Control menu PATH submenu
	functions.

	Modification History:
*********************************************************************/

#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"


extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	uInt32	DoMIBSet ();
extern	void	MIBErrorMessage ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();


/*********************************************************************
	Global Variables
*********************************************************************/

static	uInt16	pathEntity;

/*********************************************************************
	Menu Command PATH Menu
*********************************************************************/

uInt16
SetPATHEntity ()
/*********************************************************************
Function:	Get the PATH entity index from user.
Parameters:	None.
Input:		None.
Output:		None.
Return:		Entity value of 1 or greater or 0 if invalid value given.
*********************************************************************/
{
uInt16	entity;

	wprintw (inputwin, "Enter PATH entity number (1 - %d): ", 1);
	wscanw (inputwin, "%d", &entity);
	if (entity < 1 || entity > 1)
		return (0);
	
	return (entity);
}

void
DisplayPATHParameters ()
/*********************************************************************
Function:	Display the PATH parameters.
Parameters:	None.
Input:		pathEntity	= MIB's PATH entity index.
Output:		Updates mapInfo database.
Return:		None.
*********************************************************************/
{
WINDOW		*win = NULL;
TLVParamType	mibData;
uInt16		pathID;

	/* read MIB data */
	pathID = pathEntity - 1;

	mibData.paramType = fddiPATHClassTrace_MaxExpiration;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassConfigGrp.Trace_MaxExpiration 
		= mibData.PATHPARAM32;

	mibData.paramType = fddiPATHClassTVXLowerBound;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassConfigGrp.TVXLowerBound = mibData.PATHPARAM32;

	mibData.paramType = fddiPATHClassT_MaxLowerBound;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassConfigGrp.T_MaxLowerBound 
		= mibData.PATHPARAM32;

	mibData.paramType = fddiPATHClassPATHClassType;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassPATHConfigGrp[pathID].Type = mibData.PATHPARAM16;

	mibData.paramType = fddiPATHClassPATHPORTOrder;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassPATHConfigGrp[pathID].PORTOrder = mibData.PATHPARAM16;

	mibData.paramType = fddiPATHClassPATHRingLatency;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassPATHConfigGrp[pathID].RingLatency = mibData.PATHPARAM32;

	mibData.paramType = fddiPATHClassPATHTraceStatus;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassPATHConfigGrp[pathID].TraceStatus = mibData.PATHPARAM16;

	mibData.paramType = fddiPATHClassPATHT_Rmode;
	mibData.paramLen = 4;
	mibData.PATHINDEX = pathEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.ClassPATHConfigGrp[pathID].T_Rmode = mibData.PATHPARAM32;

	wmove (win, 0, 0);
	win = WindowGet (DISPLAY_WIN);
	wprintw (win, "   PATH %d Operating Parameters\n\n", pathEntity);

	wprintw (win, "1. Trace Max        : ");
	wprintw (win, "%9d usecs",
	      MFddi2Usecs (-mapInfo.ClassConfigGrp.Trace_MaxExpiration));
	wprintw (win, "\t\tType : ");
	if (mapInfo.ClassPATHConfigGrp[pathID].Type == PA_PRIMARY)
		wprintw (win, "Primary\n");
	else if (mapInfo.ClassPATHConfigGrp[pathID].Type == PA_SECONDARY)
		wprintw (win, "Secondary\n");
	else if (mapInfo.ClassPATHConfigGrp[pathID].Type == PA_LOCAL)
		wprintw (win, "Local\n");
	else
		wprintw (win, "Unknown\n");

	wprintw (win, "2. TVX Lower Bound  : ");
	wprintw (win, "%9d usecs",
		-MFddi2Usecs (mapInfo.ClassConfigGrp.TVXLowerBound));
	wprintw (win, "\t\tPORT Order  : ");
	wprintw (win, "%s\n",
		PORTORDER[mapInfo.ClassPATHConfigGrp[pathID].PORTOrder]);

	wprintw (win, "3. T_Max Lower Bound: ");
	wprintw (win, "%9d usecs",
		-MFddi2Usecs (mapInfo.ClassConfigGrp.T_MaxLowerBound));
	wprintw (win, "\t\tTrace Status:");
	wprintw (win, "%s\n",
	    TRACESTATUS[mapInfo.ClassPATHConfigGrp[pathID].TraceStatus]);

	wprintw (win, "4. Ring Latency     : ");
	wprintw (win, "%9d usecs\n",
		MFddi2Usecs (mapInfo.ClassPATHConfigGrp[pathID].RingLatency));
	wprintw (win, "5. T_Rmode          : ");
	wprintw (win, "%9d usecs\n",
		MFddi2Usecs (mapInfo.ClassPATHConfigGrp[pathID].T_Rmode));

	return;
}

void
PATHParameters ()
/*********************************************************************
Function:	Display/change PATH parameters.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
int		oldWorkWin;
int		c;
uInt32		result;
WINDOW		*win;

	/* get PATH index */
	if ((pathEntity = SetPATHEntity ()) == 0)
		return;

	oldWorkWin = WindowVisible (WORK_WIN, FALSE);
	WindowUpdate (DISPLAY_WIN, DisplayPATHParameters);
	WindowVisible (DISPLAY_WIN, TRUE);
	win = WindowGet (DISPLAY_WIN);
	werase (win);

	/* set up window */
	DisplayPATHParameters ();

	wprintw (win, "   Enter # to change (RETURN to exit)");

	werase (inputwin);

	c = 0;
	while (c != CHAR_RETURN)
	{
		c = WGETCH (inputwin);

		result = 0;
		switch (c)
		{
		case '1':
			/* set Trace Max */
			wprintw (inputwin, "Enter new Trace Max (in usecs): ");
			mibData.paramType = fddiPATHClassTrace_MaxExpiration;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.PATHPARAM32);
			break;

		case '2':
			/* set TVX Lower Bound */
			wprintw (inputwin,
				"Enter new TVX Lower Bound (in usecs): ");
			mibData.paramType = fddiPATHClassTVXLowerBound;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.PATHPARAM32);
			mibData.PATHPARAM32
				= -MUsecs2Fddi (mibData.PATHPARAM32);
			break;

		case '3':
			/* set T_Max Lower Bound */
			wprintw (inputwin,
				"Enter new T_Max Lower Bound (in usecs): ");
			mibData.paramType = fddiPATHClassT_MaxLowerBound;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.PATHPARAM32);
			mibData.PATHPARAM32 
				= -MUsecs2Fddi (mibData.PATHPARAM32);
			break;

		case '4':
			/* set Ring Latency */
			wprintw (inputwin,
				"Enter new Ring Latency (in usecs): ");
			mibData.paramType = fddiPATHClassPATHRingLatency;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.PATHPARAM32);
			mibData.PATHPARAM32 
				= MUsecs2Fddi (mibData.PATHPARAM32);
			break;

		case '5':
			/* set T_Rmode */
			wprintw (inputwin,
				"Enter new T_Rmode (in usecs): ");
			mibData.paramType = fddiPATHClassPATHT_Rmode;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.PATHPARAM32);
			mibData.PATHPARAM32 
				= MUsecs2Fddi (mibData.PATHPARAM32);
			break;
		}

		if (c >= '1' && c <= '5')
		{
			mibData.PATHINDEX = pathEntity;
			result = DoMIBSet (sizeof (mibData),
				(uChar *) &mibData, &setCount);
			if (result != RC_SUCCESS)
				MIBErrorMessage ("PATH parameter not set",
					result);
		}
	}

	WindowVisible (WORK_WIN, oldWorkWin);
	WindowVisible (DISPLAY_WIN, FALSE);
	werase (win);

	return;
}
