/*********************************************************************
	Management Application Module

	MAP MAC Control Module

	File:		mapmmac.c
	Created:	03/25/91

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module provides the Station Control menu MAC submenu
	functions.

	Modification History:
*********************************************************************/

#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"


extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	void	DoSMTWindow ();
extern	void	DoMACStatWindow ();
extern	uInt32	DoMIBSet ();
extern	void	MIBErrorMessage ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();


/*********************************************************************
	Menu Command MAC Menu
*********************************************************************/

static	uInt16	macEntity;

void
DisplayMACParameters ()
/*********************************************************************
Function:	Display the MAC parameters.
Parameters:	None.
Input:		macEntity	= MIB's MAC entity index.
Output:		Updates mapInfo database.
Return:		None.
*********************************************************************/
{
WINDOW	*win = NULL;
TLVParamType	mibData;
uInt16		macID;

	/* read MIB data */
	macID = macEntity - 1;

	mibData.paramType = fddiMACPathsRequested;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACConfigGrp[macID].PathsRequested = mibData.MACPARAM8;

	mibData.paramType = fddiMACT_Req;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACOperationGrp[macID].T_Req = mibData.MACPARAM32;

	mibData.paramType = fddiMACT_Min;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACOperationGrp[macID].T_Min = mibData.MACPARAM32;

	mibData.paramType = fddiMACT_Neg;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACOperationGrp[macID].T_Neg = mibData.MACPARAM32;

	mibData.paramType = fddiMACFrameStatus;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACOperationGrp[macID].FrameStatus = mibData.MACPARAM16;

	mibData.paramType = fddiMACFrameErrorThreshold;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACFrameErrorConditionGrp[macID].FrameErrorThreshold 
		= mibData.MACPARAM16;

	mibData.paramType = fddiMACNotCopiedThreshold;
	mibData.paramLen = 4;
	mibData.MACINDEX = macEntity;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACNotCopiedConditionGrp[macID].NotCopiedThreshold 
		= mibData.MACPARAM16;

	wmove (win, 0, 0);
	wprintw (win, "   MAC %d Operating Parameters\n\n", macEntity);
	win = WindowGet (DISPLAY_WIN);

	wprintw (win, "1. Path Requested   : ");
	wprintw (win, "0x%02x", 
		mapInfo.MACConfigGrp[macID].PathsRequested);
	wprintw (win, "\t\tPaths Available : ");
	wprintw (win, "0x%02x\n", 
		mapInfo.MACConfigGrp[macID].PathsAvailable);

	wprintw (win, "2. Frame Status Set : ");
	wprintw (win, "0x%04x",
		mapInfo.MACOperationGrp[macID].FrameStatus);
	wprintw (win, "\t\tFrame Status Cap: ");
        wprintw (win, "0x%04x\n",
	    mapInfo.MACCapabilitiesGrp[macID].FrameStatusCapabilities);

	wprintw (win, "3. Frame Err Thresh : ");
	wprintw (win, "%9d%s\n",
	  mapInfo.MACFrameErrorConditionGrp[macID].FrameErrorThreshold,
	  ((mapInfo.MACFrameErrorConditionGrp[macID].FrameErrorThreshold == 0) ? " (R/O)" : NULL));

	wprintw (win, "4. Not Copied Thresh: ");
	wprintw (win, "%9d%s\n",
	   mapInfo.MACNotCopiedConditionGrp[macID].NotCopiedThreshold,
	  ((mapInfo.MACNotCopiedConditionGrp[macID].NotCopiedThreshold == 0) ? " (R/O)" : NULL));

	wprintw (win, "5. T_Req            : ");
	wprintw (win, "%9d usecs\n", 
		MFddi2Usecs (-mapInfo.MACOperationGrp[macID].T_Req));

	wprintw (win, "6. T_Min            : ");
	wprintw (win, "%9d usecs",
		MFddi2Usecs (-mapInfo.MACOperationGrp[macID].T_Min));
	wprintw (win, "\t\tT_Max : ");
	wprintw (win, "%9d usecs\n", 
		MFddi2Usecs (-mapInfo.MACOperationGrp[macID].T_Max));

	wprintw (win, "T_Neg           : ");
	wprintw (win, "%9d usecs\n", 
		MFddi2Usecs (-mapInfo.MACOperationGrp[macID].T_Neg));

	return;
}

void
MACParameters ()
/*********************************************************************
Function:	Display/change MAC parameters.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
int		oldWorkWin;
int		c;
uInt32		result;
WINDOW		*win;

	wprintw (inputwin, "Enter MAC entity number (1 - %d): \n",
		mapInfo.SMTStationConfigGrp.MAC_Ct);
	wscanw (inputwin, "%d", &macEntity);
	if (macEntity < 1 || macEntity > mapInfo.SMTStationConfigGrp.MAC_Ct)
		return;

	oldWorkWin = WindowVisible (WORK_WIN, FALSE);
	WindowUpdate (DISPLAY_WIN, DisplayMACParameters);
	WindowVisible (DISPLAY_WIN, TRUE);
	win = WindowGet (DISPLAY_WIN);
	werase (win);

	/* set up window */
	DisplayMACParameters ();

	werase (inputwin);

	wprintw (win, "   Enter # to change (RETURN to exit)");
	c = 0;
	while (c != CHAR_RETURN)
	{
		c = WGETCH (inputwin);

		result = 0;
		switch (c)
		{
		case '1':
			/* set path requested */
			wprintw (inputwin, "Enter new path: ");
			mibData.paramType = fddiMACPathsRequested;
			mibData.paramLen = 8;
			wscanw (inputwin, "%x", &mibData.MACPARAM8);
			break;

		case '2':
			/* set frame status */
			wprintw (inputwin, 
				"Enter new frame status bit string: ");
			mibData.paramType = fddiMACFrameStatus;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &mibData.MACPARAM16);
			break;

		case '3':
			/* set frame error threshold */
			wprintw (inputwin, "Enter new frame error threshold: ");
			mibData.paramType = fddiMACFrameErrorThreshold;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &mibData.MACPARAM16);
			break;

		case '4':
			/* set not copied threshold */
			wprintw (inputwin, "Enter new not copied threshold: ");
			mibData.paramType = fddiMACNotCopiedThreshold;
			mibData.paramLen = 8;
			wscanw (inputwin, "%d", &mibData.MACPARAM16);
			break;

		case '5':
			/* set T_Req */
			wprintw (inputwin, "Enter new T_Req (in usecs): ");
			mibData.paramType = fddiMACT_Req;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.MACPARAM32);
			mibData.MACPARAM32 = -MUsecs2Fddi (mibData.MACPARAM32);
			break;

		case '6':
			/* set T_Min */
			wprintw (inputwin, "Enter new T_Min (in usecs): ");
			mibData.paramType = fddiMACT_Min;
			mibData.paramLen = 8;
			wscanw (inputwin, "%ld", &mibData.MACPARAM32);
			mibData.MACPARAM32 = -MUsecs2Fddi (mibData.MACPARAM32);
			break;
		}

		if (c >= '1' && c <= '6')
		{
			mibData.MACINDEX = macEntity;
			result = DoMIBSet (sizeof (mibData),
				(uChar *) &mibData, &setCount);
			if (result != RC_SUCCESS)
				MIBErrorMessage ("MAC parameter not set",
					result);
		}
	}

	WindowVisible (WORK_WIN, oldWorkWin);
	WindowVisible (DISPLAY_WIN, FALSE);
	werase (win);

	return;
}

