/*********************************************************************
	Management Application Module

	MAP Display Module

	File:		mapdisp.c
	Created:	12/01/89

	SID:		1.2
	Last Modified:	5/2/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is provides the screen display routines for the
	management application.

	Modification History:
*********************************************************************/
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "fbmhdr.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include        "mibglbl.h"
#include        "csphdr.h"
#include        "cspglbl.h"
#include        "drv.h"
#include        "fdrmonty.h"
#include        "fdrextrn.h"
#include        "msgutil.h"
#include        "miscsmtmib.h"
#include        "fddiled.h"



extern	TLVParamType	*FindGroupAttr ();
extern	uInt32		MAPGetMIBAttr ();
extern	uInt32		ntohl ();
extern	uInt32		htonl ();
extern	uInt16		ntohs ();
extern	uInt16		htons ();
extern	void		DrawScreen ();
extern	void		AttrNetOrder ();
extern  uChar           PhysicalRingInit;
/*********************************************************************
	Window Structures
*********************************************************************/
extern uChar PortNum[];
extern
WINDOW	*statwin, 		/* station status */
	*inputwin, 		/* user input */
	*eventwin, 		/* event display */
	*workwin,		/* current display */
	*framewin,		/* frame buffer display */
	*parsewin,		/* frame parse display */
	*menuwin;		/* menu display */


/*********************************************************************
	Global Data
*********************************************************************/
extern  MIBBufferType   mibAttr;
      
uInt32 RemoteSetCount;
static uInt32 reconfig = FALSE;

/*********************************************************************
	Display Routines
*********************************************************************/

void EnableEventLog()
{
   eventLogging = TRUE;
}

void DisableEventLog()
{
   eventLogging = FALSE;
}


uInt32
InitMAPDisplay ()
/*********************************************************************
Function:	Provide local initialization support. Such support can
		include hardware initialization, local data initialization,
		system communications, etc.
Parameters:	None.
Input:
Output:
Return:		0 if initialization is successful, otherwise an error code
		is returned.
*********************************************************************/
{
uInt32	result;
extern	uInt32	InitMAPWindows ();

	result = InitMAPWindows ();
	if (result != 0)
		return (result);

	/*
	*	Set ESF frame class.
	*/
	FRAMECLASS[0xFF] = "ESF";

	return (0);
}

void
ExitMAPDisplay ()
/*********************************************************************
Function:	Restore display to exit application.
Parameters:	None.
Input:
Output:
Return:		None.
*********************************************************************/
{
extern	void	ExitMAPWindows ();

	ExitMAPWindows ();

	return;
}


/*********************************************************************
	Menu Display Routines
*********************************************************************/

void
DisplayMenu (menu)
	ItemType	*menu;
/*********************************************************************
Function:	Display a menu on the screen.
Parameters:	menu	= menu title item.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
int		i;
ItemType	*m;

	werase (menuwin);
	box (menuwin, 0, 0);
	wstandout (menuwin);
	mvwprintw (menuwin, 1, 4, "************ %s Menu ***********\n", menu->name);
	wstandend (menuwin);
	for (i = 0, m = menu->subItem;
		m && (i < menu->numItems); 
		i++)
	{
		mvwprintw (menuwin, 2 + i, 2, "%c %s\n", m->selector, m->name);
		m = m->nextItem;
	}
	mvwprintw (menuwin, 9, 4, "Press RETURN to Exit");
	wrefresh (menuwin);

	return;
}

void
RemoveMenu ()
/*********************************************************************
Function:	Remove menu display from screen.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
	werase (menuwin);
	wrefresh (menuwin);
	touchwin (workwin);

	return;
}


/*********************************************************************
	General Display Routines
*********************************************************************/

void
MIBErrorMessage (s, err)
	char	*s;
	uInt32	err;
{
	wprintw (inputwin, ">>> %s: Error 0x%04x", s, err);
	if (err <= 0x0C)
		wprintw (inputwin, " - %s", REASONCODE[err]);
	wprintw (inputwin, " <<<\n");
	return;
}

void printTLVStructOffset(TLVPtr)
TLVParamType	*TLVPtr;
{
   printf("smtAttr = %x   otherAttr = %x   pIndex = %x\n",
	  ((uChar*) &TLVPtr->SMTPVAL- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->paramValue.otherAttr- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->paramValue.otherAttr.paramIndex- (uChar*) TLVPtr));
   printf("smt8 = %x   smt16 = %x   smt32 = %x\n",
	  ((uChar*) &TLVPtr->SMTPVAL.smt8.data- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->SMTPVAL.smt16.data- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->SMTPVAL.smt32.data- (uChar*) TLVPtr));
   printf("smtId = %x   smtOther = %x\n",
	  ((uChar*) &TLVPtr->SMTPVAL.smtId- (uChar*) TLVPtr), 
	  (TLVPtr->SMTPVAL.smtOther- (uChar*) TLVPtr)); 
   printf("p8 = %x   p16 = %x   p32 = %x\n",
	  ((uChar*) &TLVPtr->MACPVAL.p8.data- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->MACPVAL.p16.data- (uChar*) TLVPtr), 
	  ((uChar*) &TLVPtr->MACPVAL.p32.data- (uChar*) TLVPtr));
   printf("pId = %x   pOther = %x\n",
	  ((uChar*) &TLVPtr->MACPVAL.pId- (uChar*) TLVPtr), 
	  (TLVPtr->MACPVAL.pOther- (uChar*) TLVPtr)); 
}

void
DisplayMIBAttr (mibData, HostOrder_flag)
	TLVParamType	*mibData;
        uInt32          HostOrder_flag;
{
uInt16	len, type;
int	i, count;

	count = 0;

/*    printTLVStructOffset(mibData);*/

    if (!HostOrder_flag)
    {
       mibData->paramType = ntohs (mibData->paramType);
       mibData->paramLen = ntohs (mibData->paramLen);
    }

    do
    {
	wprintw (inputwin, "MIB Attr %s %d (0x%04x) [length %d]",
		MIBOBJECT[(mibData->paramType >> 12) & 0xf],
		mibData->paramType & MIB_ID_MASK,
		mibData->paramType, mibData->paramLen);
	if (mibData->paramType >= fddiMAC)
		wprintw (inputwin, "Entity %d", mibData->MACINDEX);
	wprintw (inputwin, " =\n");

	len = mibData->paramLen;
	type = mibData->paramType;
	if (HostOrder_flag)
	         AttrNetOrder (mibData, NET_ORDER);
/*
        for (i=0, ch=(uChar*) mibData; i < 36; i++)
	  printf("%02x ", ch[i]);
        printf("\n");
*/

	if (type >= fddiMAC && len > 4)
	{
		for (i = 0; i < len - 4; i++)
			wprintw (inputwin, "%02x  ",
				mibData->MACOTHER[i]);
	}

	else
	{
		for (i = 0; i < len; i++)
			wprintw (inputwin, "%02x  ",
				mibData->SMTOTHER[i]);
	}

	wprintw (inputwin, "\n");

	mibData = (TLVParamType *) (((uChar *) mibData)
		+ len + sizeof (TLVHdrType));

	if (++count > 2)
	{
		wprintw (inputwin, "Press return to continue ");
		wscanw (inputwin, "%*s");
		count = 0;
	}

        if (!HostOrder_flag)
	{
	   mibData->paramType = ntohs (mibData->paramType);
	   mibData->paramLen = ntohs (mibData->paramLen);
	}

    } while ((mibData->paramType != 0) && (mibData->paramLen != 0));
/*
    wprintw (inputwin, "Press return to continue ");
    wscanw (inputwin, "%*s");
*/
	return;
}

void
PORTReStart (port)
uChar port;
/*********************************************************************
Function:	Give a start command to a port.
Parameters:	None.
Input:		mapInfo MIB database.
Output:		None.
Return:		None.
*********************************************************************/
{
TLVParamType	mibData;
TLVSetCountType	setCount;
uInt32		result=RC_SUCCESS, retry;

	/* clear buffers */
        retry = 30;
        while ((result != RC_SUCCESS) && retry--)
	{
	   MEMZERO (&mibData, sizeof (mibData));

	   mibData.paramType = fddiPORTAction;
	   mibData.paramLen = 8;
	   mibData.PORTINDEX = port;
+	   mibData.PORTPARAM16 = PORTAction_Start;

	   result = DoMIBSet (sizeof (mibData), (uChar *) &mibData, &setCount);
	   if (result != RC_SUCCESS)
	         MIBErrorMessage ("Start command failed.", result);
	}
}

void SetPCType(entity, curr_PC_type, new_PC_type)
uInt16 entity;
uChar curr_PC_type, new_PC_type;
{
   if (eventLogging)
      printf("  Reconfigure port %d from (%s) to (%s).\n", 
	     PortNum[entity], PCTYPE[curr_PC_type], PCTYPE[new_PC_type]);
   mib->PORTConfigGrp[entity].PC_Type = new_PC_type;
   phyData[entity].PC_Type = new_PC_type;
   mapInfo.PORTConfigGrp[entity].PC_Type = new_PC_type;
   DRV_MIBsReq((uInt32) entity, DRVMIB_PTYPE,
		  (uInt32) new_PC_type);
}

void RestoreConfigure(entity)
uInt16 entity;
{
   if ((cemData[PHY_A].ceState != CE_ISOLATED) ||
       (cemData[PHY_B].ceState != CE_ISOLATED) ||
       (!reconfig))
      return;

   reconfig = FALSE;

   SetPCType( PHY_A, phyData[PHY_A].PC_Type, PC_Type_A);
   SetPCType( PHY_B, phyData[PHY_B].PC_Type, PC_Type_B);
}


void ReConfigure(entity, PC_Type, PC_Neighbor)
uInt16 entity;
uChar  PC_Type, PC_Neighbor;
{
   uInt16 otherPhy, otherType;
   static count=0;

   if (entity == PHY_A)
   {
      if ((cemData[PHY_B].ceState != CE_ISOLATED) &&
	  (phyData[PHY_B].PC_Type == PC_Type_B))
	return;
      otherPhy = PHY_B;
      otherType = PC_Type_B;
   }
   else
   {
      if ((cemData[PHY_A].ceState != CE_ISOLATED) &&
	  (phyData[PHY_A].PC_Type == PC_Type_A))
	return;
      otherPhy = PHY_A;
      otherType = PC_Type_A;
   }
   
   reconfig = TRUE;
   switch (PC_Neighbor)
     {
     case PC_Type_A:
     case PC_Type_B:
     case PC_Type_S:
          SetPCType(entity, PC_Type, PC_Type_M);
	  PORTReStart(entity+1);
	  if (phyData[otherPhy].PC_Type == otherType)
	  {
	     SetPCType(otherPhy, otherType, PC_Type_M);
	     PORTReStart(otherPhy+1);
	  }
          break;

     case PC_Type_M:
          SetPCType(entity, PC_Type, PC_Type_S);
	  PORTReStart(entity+1);
	  if (phyData[otherPhy].PC_Type == otherType)
	  {
	     SetPCType(otherPhy, otherType, PC_Type_S);
	     PORTReStart(otherPhy+1);
	  }
          break;

     default:
	  if (++count > 6)
	  {
	     RestoreConfigure(entity);
	     count = 0;
	  }
	  break;
     }
}

void
ProcessSMTNotification (msg)
	SMTMessage	*msg;
{
union {
	TLVHdrType		*paramHdr;
	EvtCfgChgType		*evtCfgChg;
	CondDAType		*condDA;
	CondFrErrType		*condFrErr;
	CondNotCopiedType	*condNotCopied;
	EvtNbrChgType		*evtNbrChg;
	EvtTrStatType		*evtTrStat;
	CondLerType		*condLer;
	EvtConnectType		*evtConnect;
	CondEBErrType		*condEBError;
} event;
uInt16 entity, macID;
	/*
	*	Get the event.
	*/
	event.paramHdr = (TLVHdrType *) msg->p1.ptr;
        entity = msg->entity;

	/*
	*	Display the event data.
	*/
	if (eventLogging)
	   printf("\n***SMT ");
	switch (event.paramHdr->paramType)
	{
	case fddiSMTConfigurationChgEvent:
	    strobe_wdt();
	    ReadData();
#ifdef __FEBRIDGE
		FddiLedsOn();	/* set fddi rx/tx LEDS in case of config change */
#endif

	    if (mapInfo.SMTStatusGrp.CF_State == CF_ISOLATED)
	    {
	       DRV_MIBsReq((uInt32) 0, DRVMIB_RINGTYPE,
			   (uInt32) RING_ISO);
	    }
	    else if (mapInfo.SMTStatusGrp.CF_State == CF_THRU)
	    {
	       DRV_MIBsReq((uInt32) 0, DRVMIB_RINGTYPE,
			   (uInt32) RING_THRU);
	    }
	    else
	    {
	       DRV_MIBsReq((uInt32) 0, DRVMIB_RINGTYPE,
			   (uInt32) RING_WRAP);
#ifdef __FEBRIDGE
		   if (mapInfo.PORTConfigGrp[entity].PC_Neighbor == PC_Type_M)
		  	SetPTLedOn(entity);		/* turn on p/t LED */
#else
	       if (((mapInfo.PORTConfigGrp[entity].PC_Type == PC_TYPE_A)
		   || (mapInfo.PORTConfigGrp[entity].PC_Type == PC_TYPE_B))
		   && (mapInfo.PORTConfigGrp[entity].PC_Neighbor == PC_TYPE_M))
	       {
		  SetPortLed (Port2LedMap[entity], LED_PEER_TREE, LED_TURN_ON);
	       }
#endif
	    }

	    if (eventLogging)
	    {
	       wprintw (eventwin, "EVENT: Configuration Change\n");
	       DisplayPHYInfo (entity);
	       wprintw (eventwin, "  New configuration = %s\n",
			CFMSTATE[event.evtCfgChg->CF_State.data]);
	    }

#ifdef __AUTO_CONFIG
	    if (entity <= PHY_B)
	    {
	       RestoreConfigure(entity);
	    }
#endif

	    mibAttr[0].paramType = fddiPORTPathsRequested;
	    mibAttr[0].paramLen = 4;
	    mibAttr[0].PORTINDEX = entity + 1;
	    MAPGetMIBAttr (sizeof (TLVParamType), (uChar *) mibAttr, 
			      NULL);
            macID = (mibAttr[0].PORTPARAM8 & PA_PRIMARY) ?
	             PRIMARY_MAC : SECONDARY_MAC;
	    if (PhysicalRingInit && (entity > PHY_B))
	    {
	       if (cemData[entity].ceState != CE_ISOLATED)
	       {
		  fddiHost_control_tbl[macID].PortChanged = TRUE;
		  SendMsgToRiMapMBox ((uInt16) EV_OTHER, (uInt16) macID);
	       }
	       UpdateMyPortMap(macID, 
			       (entity+1),
			       (uChar) (cemData[entity].ceState != CE_ISOLATED),
			       (uChar) phyData[entity].PC_Type);
	    }
	    break;

	case fddiMACNeighborChangeEvent:
	    SendMsgToRiMapMBox ((uInt16) EV_OTHER, (uInt16) entity);
	    if (eventLogging)
	    {
		wprintw (eventwin, "EVENT: MAC Neighbor Change\n");
		wprintw (eventwin, "  New %s%s reported on MAC %d\n",
			(event.evtNbrChg->Condition & EVENT_UNA_CHANGED)
			? "UNA " : "",
			(event.evtNbrChg->Condition & EVENT_DNA_CHANGED)
			? "DNA" : "",
			event.evtNbrChg->MACIndex - 1);
		wprintw (eventwin,
"  Old UNA:%02x%02x %02x%02x %02x%02x    New UNA:%02x%02x %02x%02x %02x%02x\n",
			event.evtNbrChg->Old_UNA[0],
			event.evtNbrChg->Old_UNA[1],
			event.evtNbrChg->Old_UNA[2],
			event.evtNbrChg->Old_UNA[3],
			event.evtNbrChg->Old_UNA[4],
			event.evtNbrChg->Old_UNA[5],
			event.evtNbrChg->New_UNA[0],
			event.evtNbrChg->New_UNA[1],
			event.evtNbrChg->New_UNA[2],
			event.evtNbrChg->New_UNA[3],
			event.evtNbrChg->New_UNA[4],
			event.evtNbrChg->New_UNA[5]);
		wprintw (eventwin,
"  Old DNA:%02x%02x %02x%02x %02x%02x    New DNA:%02x%02x %02x%02x %02x%02x\n",
			event.evtNbrChg->Old_DNA[0],
			event.evtNbrChg->Old_DNA[1],
			event.evtNbrChg->Old_DNA[2],
			event.evtNbrChg->Old_DNA[3],
			event.evtNbrChg->Old_DNA[4],
			event.evtNbrChg->Old_DNA[5],
			event.evtNbrChg->New_DNA[0],
			event.evtNbrChg->New_DNA[1],
			event.evtNbrChg->New_DNA[2],
			event.evtNbrChg->New_DNA[3],
			event.evtNbrChg->New_DNA[4],
			event.evtNbrChg->New_DNA[5]);
	      }
	    break;

	case fddiMACDuplicateAddressCondition:

	    if (eventLogging)
		wprintw (eventwin, "CONDITION: Duplicate address on MAC %d - %s%s\n",
			event.condDA->MACIndex - 1,
			(event.condDA->Condition & DuplAddr_My_Duplicate)
			? "My Duplicate " : "",
			(event.condDA->Condition & DuplAddr_My_UNA_Duplicate)
			? "My UNA Duplicate" : "");
	    break;

	case fddiMACFrameErrorConditionEvent:
	    if (eventLogging)
		wprintw (eventwin, "CONDITION: Frame Error on MAC %d %s\n",
			event.condFrErr->MACIndex - 1,
			(event.condFrErr->Condition_State)
				? "ACTIVE" : "Not active");
		break;

	case fddiMACNotCopiedConditionEvent:
	    if (eventLogging)
		wprintw (eventwin, "CONDITION: Not Copied on MAC %d %s\n",
			event.condNotCopied->MACIndex - 1,
			(event.condNotCopied->Condition_State)
				? "ACTIVE" : "Not active");
		break;

	case fddiPATHTraceStatusEvent:
	        if (eventLogging)
		   wprintw (eventwin, "EVENT: Trace Status\n");
		if (event.evtTrStat->TraceStarted)
		{
		   SmtMibMacObjects[entity].PathTraceStarted++;
#if 1
		   TurnOnAllLed();
#endif
		   if (eventLogging)
		      wprintw (eventwin, "  Started");
		}
		else if (event.evtTrStat->TracePropagated)
		{
		   SmtMibMacObjects[entity].PathTracePropagated++;
		   if (eventLogging)
 			wprintw (eventwin, "  Propagated");
		}
		else if (event.evtTrStat->TraceTerminated)
		{
		   SmtMibMacObjects[entity].PathTraceTerminated++;
#if 1
		   TurnOffAllLed();
#endif
		   if (eventLogging)
		      wprintw (eventwin, "  Terminated");
		}

	       if (eventLogging)
		  wprintw (eventwin, "\n");

	    break;

	case fddiPORTUndesiredConnectionAttempt:
	    SmtMibPortObjects[entity].UndesiredConnectionCts++;

	    if (eventLogging)
	    {
		wprintw (eventwin, "EVENT: Undesirable Connection Attempted\n");
		wprintw (eventwin, "  Port %s (%d) to Neighbor Port %s %s (State = %s)\n",
			PCTYPE[event.evtConnect->PC_Type],
			PortNum[entity],
			PCTYPE[event.evtConnect->PC_Neighbor],
			(event.evtConnect->connectionAccepted)
				? "Accepted" : "REJECTED",
			CONSTATE[event.evtConnect->connectState]);
	    }

#ifdef __AUTO_CONFIG
	    if (entity <= PHY_B)
	    {
	       ReConfigure(entity, event.evtConnect->PC_Type,
			   event.evtConnect->PC_Neighbor);
	    }
#endif

	    break;

	case fddiPORTLerConditionEvent:
	    SmtMibPortObjects[entity].LerConditionCts++;
	    if (event.condLer->ConditionState) /* Alarm */
#ifdef __FEBRIDGE
		SetLELedOn(entity);
	    else
		SetLELedOff(entity);
#else
		SetPortLed(Port2LedMap[entity], LED_LINK_ERROR, LED_TURN_ON);
	    else
		SetPortLed(Port2LedMap[entity], LED_LINK_ERROR, LED_TURN_OFF);
#endif
	    
	    if (eventLogging)
		wprintw (eventwin, "CONDITION: LER on PORT %s %s\n",
			PCTYPE[mapInfo.PORTConfigGrp[event.condLer->PORTIndex - 1].PC_Type],
			(event.condLer->ConditionState)
				? "ACTIVE" : "Not active");
		break;

	case fddiPORTEBErrorConditionEvent:
#if 0
	    if (event.condEBError->ConditionState)
	       SetPortLed(Port2LedMap[entity], LED_LINK_ERROR, LED_TURN_ON);
	    else
	       SetPortLed(Port2LedMap[entity], LED_LINK_ERROR, LED_TURN_OFF);
#endif
	    SmtMibPortObjects[entity].EbErrorConditionCts++;

	    if (eventLogging)
		wprintw (eventwin, "CONDITION: EB Error on PORT %s %s\n",
			PCTYPE[mapInfo.PORTConfigGrp[event.condEBError->PORTIndex - 1].PC_Type],
			(event.condEBError->ConditionState)
				? "ACTIVE" : "Not active");
		break;
	}

	return;
}

void DisplayPMFGetResponse(frameHdr, infoLen)
SMTFrameHdrType *frameHdr;
uInt16 infoLen;
{
   TLVParamType *p, *TLVPtr;
   ReasonCodeParamType *RCode;
   TLVSetCountType *setCount;

   printf("\n");
   TLVPtr = (TLVParamType*) (frameHdr + 1);
   p = (TLVParamType*) ((uChar*) TLVPtr + infoLen);
   p->paramType = p->paramLen = 0;
   RCode = (ReasonCodeParamType*) FindFrameParam(REASON_CODE_PARAM_TYPE, 
						 frameHdr);
   if (RCode && (ntohl(RCode->reason) == RC_SUCCESS))
   {       
      if (setCount = (TLVSetCountType*) FindFrameParam(fddiSMTSetCount, 
						       frameHdr))
      {
	 RemoteSetCount = ntohl(setCount->paramValue.count);
	 printf("\n***Successful PMF Get Response:\n");
      }
      else
      {
	 printf("\n***Cannot find the PMF Get Response's Set Count\n");
      }
   }
   else
   {
      printf("\n***PMF Get Response's reason code = %x\n", ntohl(RCode->reason));
   }

   DisplayMIBAttr(TLVPtr, FALSE);
}
