/*********************************************************************
	Management Application Module

	MAP Entry Module

	File:		map.c
	Created:	12/01/89

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is the MAP entry point for starting connection
	processing. The MAP system initialization is directed from here.
	This module has two primary routines. MAPMain() initializes the
	management process. ProcessMAP() controls the operation of the
	application.

	Modification History:
*********************************************************************/
#include        "fddi.h"
#include        "smttypes.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include        "msgutil.h"
#include        "cmtflag.h"
#include        "dips.h"

#define INIT_DRV_ERROR        1
#define INIT_MSP_ERROR        2
#define INIT_CSP_ERROR        3
#define INIT_FBM_ERROR        4
#define INIT_MAP_ERROR        5

#undef  SMTDPT
#define SMTDPT(str)       if (get_debug() == DEBUG_ON) \
                               printf(str);

/*********************************************************************
	External Declarations
*********************************************************************/

extern	uInt32	InitMAPMessage ();
extern	uInt32	InitMAPLocal ();
extern	uInt32	InitMAPDisplay ();

/* Backplane Insertion Protocol tasks */
extern void brip_rcv_task();
extern void brip_free_task();
extern int brip_inited;
extern word brip_rcv_stk[512];
extern word brip_free_stk[512];
extern TIMER FDDIActionTimer;


/*********************************************************************
	Global Data
*********************************************************************/

Flag	eventLogging;
Flag	frameTracing;
Flag    RmonExist;
Flag    SMTInitialized=FALSE;
static Flag    SMTMibInitFlag=FALSE;
uChar MacInPromiscous[2];
MIBType	mapInfo;


/*********************************************************************
	MAP Routines
*********************************************************************/

uInt32
MAPMain ()
/*********************************************************************
Function:	Start-up code for the MAP system.
Parameters:	None.
Input:		None.
Output:		Initializes MAP system by calling initialization routines.
Return:		0 is returned if the initialization was successful. Otherwise,
		the initialization error is returned.
Notes:		If initialization is not successful, this routine guarantees
		that the system will be returned to a known state (e.g., no
		communication mechanisms will be left open).
*********************************************************************/
{
   int		result;

   /*
    *	Default event logging ON.
    */
   eventLogging = FALSE;

   /*
    *	Initialize system internal structures.
    */
   CreatTimer(&FDDIActionTimer);
 
   /*
    *	Initialize system internal structures.
    */
   SMTDPT("InitMAPMessage\n");
   if ((result = InitMAPMessage ()) != 0)
     return (result);

   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();

   /*
    *	Initialize menus.
    */
   SMTDPT("InitMAPMenu\n");
   if ((result = InitMAPMenu ()) != 0)
     return (result);
   
   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();
   /*
    *	Initialize frame trace buffer.
    */
   SMTDPT("InitFrameBuffer\n");
   if ((result = InitFrameBuffer ()) != 0)
     return (result);
   
   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();
   /*
    *	Initialize local interfaces.
    */
   SMTDPT("InitMAPLOcal\n");
   if ((result = InitMAPLocal ()) != 0)
   {
       /* turn off interrupt processing */
       return (result);
   }
   
   /*
    *	Initialize MIB Data.
    */
   SMTDPT("InitMAPInfo\n");
   InitMIBInfo ();
   
   /*
    *	Initialize display.
    */
   SMTDPT("InitMAPDisplay\n");
   if ((result = InitMAPDisplay ()) != 0)
      return (result);
   
   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();
   SMTDPT("Initialize MAP successfully.\n");
   return (0);
}

uInt32 InitSMTMib()
{
   if (!SMTMibInitFlag)
   {
      if (MIBMain ())
      {
	 return TRUE;
      }

      SMTMibInitFlag = TRUE;
   }
   return FALSE;
}


uInt32
init_fddi(source)
int source;
/*********************************************************************
Function:	FDDI initialization 
Parameters:	None.
Input:		None.
*********************************************************************/
{
   int i;
	
   if (SMTInitialized)
      return TRUE;

   MacInPromiscous[0] = MacInPromiscous[1] = FALSE;

   frameTracing = source; /* enable frame tracing if it's in the application */
   RmonExist = source;
   SMTDPT("InitFDDIMsgHdrDescr\n");
   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();
   InitFDDIMsgMBox (&FDDIMsgHdrDescr); 
   /*
    * make sure we bump the watch dog timer.
    * do not take this code out since the 
    * initialization takes some time.
   */
   strobe_wdt();
   InitFDDIMsgMBox (&SRFIntMsgDescr); 
   PutBPRxQuiet();  /* Switch backplane rx line to quiet line 24 */

   if (InitSMTMib())
   {
      printf("\nMIB initialization failure.\n");
      return FALSE;
   }

   printf("CMT-RMT Initialization\n");
   if (CSPMain ())
   {
      printf("\nCSP initialization failure.\n");
      return FALSE;
   }

   SMTDPT("InitMAPMain\n");
   if (MAPMain ())
   {
      printf("\nMAP initialization failure.\n");
      return FALSE;
   }

   SMTDPT("InitCSPMIBData\n");
   InitCSPMIBData ();

   ReSchedule();

   SMTDPT("InitDRV\n");
   if (DRV_Init (source))
   {
      printf("\nDRIVER initialization failure.\n");
      return FALSE;
   }

   ReSchedule();

#ifndef __CMT_ONLY
   SMTDPT("InitFBMMain\n");
   if (FBMMain ())
   {
      printf("\nFBM initialization failure.\n");
      return FALSE;
   }
#endif
   ReSchedule();
   SMTInitialized = TRUE;

#if 0
   if (!source) 
   {
      DoConnect();  /* Activate FDDI Ports' Connection if from boot */
   }
#else
   DoConnect();  /* Activate FDDI Ports' Connection */
#endif
   

	StartBRIP();		/* init the backplane stuff */
   return TRUE;

}


StartBRIP()
{  
	int time;

   init_fddi_brip();
   CreatTask(brip_free_task, brip_free_stk, sizeof(brip_free_stk), NULL );
   CreatTask(brip_rcv_task, brip_rcv_stk, sizeof(brip_rcv_stk), NULL );
	
   time = RealTimeTicks();
   while( !brip_inited)
     {
                    if ((RealTimeTicks() - time) > (60 * 100))
			{
			printf("Initialization of backplane code (brip) timed out \n");
			break;
			}
		ReSchedule();
      }
}


void
ProcessMAP ()
/*********************************************************************
Function:	Entry point for MAP operation.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{

  for (;;)
  {
     MainMenu ();
  }

  ExitCSPInterrupts ();
  ExitFBMFrameBuffer ();
}

