/******************************************************************
 *  Copyright (c) Hughes LAN Systems, 1993
 *
 *  $Log:   /user/pvcs/fddicon/include/trigger.h_v  
 * 
 *    Rev 1.9   15 Sep 1993 09:24:38   gregs
 * No change.
 * 
 *    Rev 1.8   23 Apr 1993 13:58:44   jang
 * changed TRIGGER_TYPE from byte to int
 * 
 *    Rev 1.7   23 Mar 1993 18:17:50   shekhar
 * 
 *    Rev 1.6   23 Feb 1993 12:35:26   nayan
 * 
 *    Rev 1.5   08 Jan 1993 10:42:54   shekhar
 * 
 *    Rev 1.3   30 Dec 1992 11:45:22   jang
 * include fddi.h instead of types.h
 * 
 *    Rev 1.2   29 Dec 1992 17:57:46   jang
 * modified to integrate with trig_db.c
 * 
 *    Rev 1.1   29 Dec 1992 12:42:20   jang
 * removed #ifdef REM
 *****************************************************************/
#ifndef _TRIGGER_H_
#define _TRIGGER_H_


#include <fddi.h>
#include <10bt.h>
#include <cpb.h>






/*
 * ERROR CODES
 */
#define TRIG_TAB_FULL       -1
#define TRIG_TAB_BAD_DAY    -2
#define TRIG_TAB_BAD_MINS   -3
#define TRIG_TAB_BAD_ACT    -4
#define TRIG_TAB_BAD_PORT   -5
#define TRIG_TAB_PORT_EXCL  -6
#define TRIG_TAB_NO_MATCH   -7
#define TRIG_TAB_NEXT_MATCH -8
#define TRIG_TAB_EMPTY      -9
/*
 *  DEFINE ACTIONS
 */
#define TRIG_ACT_WILDCARD   0       /* for purge only */
#define TRIG_ACT_DELETED    1       /* deleted entry in the data base */
#define TRIG_ENTRY_DELETED  TRIG_ACT_DELETED
#define TRIG_ACT_PORT_LOCK  2
#define TRIG_ACT_PORT_UNLOCK  3

#define END_TRIG_MATCH          115     /* put in trig_act_list[] to indicate
                                            end of the legal value */

/*
 *  constants for day
 */
#define TRIG_DAY_WILDCARD   0
#define TRIG_SUN            1
#define TRIG_SAT            2
#define TRIG_FRI            4
#define TRIG_THU            8
#define TRIG_WED            16
#define TRIG_TUE            32
#define TRIG_MON            64
#define TRIG_WEEKEND        131
#define TRIG_WEEKDAY        252
#define TRIG_EVERYDAY       255


#define TRIG_MIN_WILDCARD   -1      /* wild card for minutes */
#define TRIG_MIN_DEFAULT    0       /* default minutes value */


#define TRIG_PORT_WILDCARD   0x07fffffe  /* also used if portlist is omitted */




/*
 *  Trigger type data structure
 */
typedef struct trigger_struct {
    int    day;
    int    action;
    int    minutes;
    lword   portlist;
} TRIGGER_TYPE;

#define TRIG_MAX              100
#define TRIGGER_SIZE          sizeof(TRIGGER_TYPE) * TRIG_MAX + 2

/*
 *  used by the polling routine to take action to the ports in the portlist
 */
typedef struct trig_poll_struct {
    byte    action;
    int   portlist;
    /* commented by NAY 
    lword   portlist;
     */
} TRIG_POLL_TYPE;
#define TRIG_POLL_MAX           10


/*
 *  export functions & variables in trigger.c
 */
extern  int load_trig_table(void );
extern  int trigger_clear_all(void );
extern  int trigger_purge(TRIGGER_TYPE far *);
extern  int trigger_first(TRIGGER_TYPE far *);
extern  int trigger_find(TRIGGER_TYPE,TRIGGER_TYPE far *);
extern  int trigger_next(TRIGGER_TYPE,TRIGGER_TYPE far *);
extern  int trigger_best_match(TRIGGER_TYPE ,TRIGGER_TYPE far *);
extern  int trigger_insert(TRIGGER_TYPE far *);
extern  int def_trigger(unsigned int ,unsigned int ,CPB_P);
extern  int def_trig_act(unsigned int ,unsigned int ,CPB_P);
extern  int def_trig_port(unsigned int ,unsigned int ,CPB_P);
extern  int show_trig_all(unsigned int ,unsigned int ,CPB_P);
extern  int show_trig_port(unsigned int ,unsigned int ,CPB_P);
extern  int sh_trig_port_day(unsigned int ,unsigned int ,CPB_P );
extern  int show_trig_day(unsigned int ,unsigned int ,CPB_P );
extern  int sh_trig_day_port(unsigned int ,unsigned int ,CPB_P );
extern  int get_trigger_time(int *,int *,CPB_P);
extern  int get_trigger_day(int *,CPB_P, int);
extern  int purge_trig_all(unsigned int ,unsigned int ,CPB_P );
extern  int purge_trig_port(unsigned int ,unsigned int ,CPB_P );
extern  int pur_trig_port_day(unsigned int ,unsigned int ,CPB_P );
extern  int pur_trig_port_act(unsigned int ,unsigned int ,CPB_P );
extern  int purge_trig_day(unsigned int ,unsigned int ,CPB_P);
extern  int pur_trig_day_port(unsigned int ,unsigned int ,CPB_P );
extern  int pur_trig_day_act(unsigned int ,unsigned int ,CPB_P );
extern  void get_triggers(TRIGGER_TYPE far *);

#endif  /* _TRIGGER_H_ */
