/**********************************************************************
 *
 *   $Log:   /usr/shasta/pvcs/fddicon/include/fddiled.h_v  
 * 
 *    Rev 1.7   09 Apr 1993 16:21:44   jlin
 * 
 *    Rev 1.6   09 Apr 1993 14:30:54   jang
 * added new define FLICK_ACTLED_ON to support rmon
 * 
 *    Rev 1.5   08 Apr 1993 20:14:48   jlin
 * 
 *    Rev 1.4   08 Apr 1993 16:16:48   jlin
 * 
 *    Rev 1.3   07 Apr 1993 08:26:10   jang
 * include fddi.h
 */

#ifndef __FDDILED_H
#define __FDDILED_H

#include <fddi.h>

#define LED_PORT_NUM  (MAX_PORT_COUNT-2)

#define RMON_LED_AR            1
#define RMON_LED_PS            2
#define RMON_LED_PT            4
#define RMON_LED_LE            8

#define LED_PRIMARY_SECONDARY  1
#define LED_LINK_ERROR         2
#define LED_PEER_TREE          4
#define LED_ACTIVE_READY       8
#define LED_SET1               ( LED_PRIMARY_SECONDARY \
				| LED_PEER_TREE        \
			        | LED_LINK_ERROR)
#define LED_SET2               ( LED_PRIMARY_SECONDARY \
				| LED_PEER_TREE        \
			        | LED_ACTIVE_READY)
#define LED_ALL                (LED_SET1 | LED_ACTIVE_READY)
#define LED_TURN_ON            1
#define LED_TURN_OFF           0
#define LED_REG_NO             3
#define LOOP_DELAY             300


#define FLICK_ACTLED_ON        0x10

extern int led_test_active;
extern uChar LedStatus[LED_REG_NO];
extern uChar Port2LedMap[MAX_PORT_COUNT];
extern uChar UI2PortMap[MAX_PORT_COUNT];

#endif /* __FDDILED_H */


