 /**************************************************************************
 *  File            fddi.h
 *
 *  Description
 *      This header file is shared by the modules under 'fddicon' directory.
 *      All the source files should include this header file.
 *
 *  Copyright (c) Hughes Lan Systems, 1992 1993
 * **********************************************************************/
 
#ifndef _FDDI_H_
#define _FDDI_H_


#include <types.h>
#include <fddimap.h>


#define FAR           /* used by Microsoft Compiler */
#define far    FAR



typedef unsigned short  uint16;
typedef unsigned int    uint32;
typedef unsigned int    status_type;     /* OK | ERROR */


/*
*       Following types are used by the SMT modules
*	Integer Definitions
*	The target environment must be able to support 16- and 32-bit
*	signed and unsigned integer values.
*/
typedef	short		Int16;
typedef	unsigned short	uInt16;

typedef	int		Int32;
typedef	unsigned int	uInt32;

typedef	unsigned int	uInt;
typedef unsigned char   uByte;
typedef char            Byte;

/*
*	Character Definitions
*	The C type "char" is assumed to be a signed 8-bit value.
*/
typedef	unsigned char	uChar;

/*
*	Boolean Definitions
*	A Boolean variable may take on one of two values. The FDDI SMT
*	uses the term "flag" for Boolean variables. A flag may either be
*	set or cleared. The constant SET is equivalent to a logical
*	TRUE and the constant CLEAR is a logical FALSE.
*/
typedef	short	Flag;
typedef uChar   BOOLEAN;


#ifndef bool
typedef int	bool;
#endif

#ifndef OK
#define  OK    0
#endif

/* ERROR was defined as -1 in defines.h and tftp.h and it has different value.
may God bless us! */
#ifndef FDDI_ERROR
#define FDDI_ERROR  1
#endif


#ifndef TRUE
#define TRUE            1
#endif

#ifndef FALSE
#define FALSE           0
#endif

#ifndef DONT_CARE
#define DONT_CARE       FALSE
#endif

/*
*	Station Limitations
*	These values determine the system limits for various elements
*	within the station.
*/
#define	MAX_MAC_COUNT		FDDI_MAC_CT
#define	MAX_PATH_COUNT		FDDI_MAC_CT
#define	MAX_PORT_COUNT		(FDDI_MASTER_CT + FDDI_NONMASTER_CT)
#define	MAX_ATTACH_COUNT	MAX_PORT_COUNT

#define FDDI_MASTER_PORTS       MAX_PORT_COUNT  /* master card */
#define FDDI_SLAVE_PORTS        MAX_PORT_COUNT  /* slave card */



#define	MAX_PHY_COUNT		MAX_PORT_COUNT	/* for backward compatibility */
#define	MAX_ALIASES_COUNT	1     /* also apply for group addresses */
#define MAX_FREE_FDDI_MSGHDR    100

#define CSP_STACK_BYTE_SIZE     (0x2000)
#define FBM_STACK_BYTE_SIZE     (0xa000)


typedef struct SignalMsgType
{
   uInt16 type;
   uInt32 data;
   /* entity can be got from dev_num in GenericMsgType */
} SignalMsgType;

#define DBDBUF_FRAME_SIZE       4096
#define DBDBUF_RESERVED         32

/*--------- Moved from fddihdr.h -------------*/
/*
*	Maximum Frame Size (in bytes)
*/
#define	MAX_FRAME_SIZE		(DBDBUF_FRAME_SIZE - DBDBUF_RESERVED)

/*
*	Maximum SMT INFO field size (in bytes)
*/
#define MIN_OTHER_FIELDS        42
#define	MAX_SMT_INFO_LEN	(MAX_FRAME_SIZE - MIN_OTHER_FIELDS)
/*---------------------------------------------*/


#define FDDI_BUF_ALIGN          0x1000 /* PSP buf has to be 32 byte alignment */


#define PRIMARY_MAC            0
#define SECONDARY_MAC          1


/****
 fddi board ID
****/
#define FDDICON_MASTER          1    /* fddi concentrator master board */
#define FDDICON_SLAVE           2    /* fddi concentrator slave board */
#define FDDI_BRIDGE             3    /* fddi bridge */


#endif  /* _FDDITYPE_H_ */




